/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.ui.action;

import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JavaImplParser {
    private final String ANNOTATION_SCA_SERVICE = "org.osoa.sca.annotations.Service";
    private final String ANNOTATION_SCA_SERVICE_INTERFACES_ATTR = "interfaces";
    private IType javaType;
    boolean isImplBeanAnnotated = false;
    String interfaceName;
    String javaClassName;

    public JavaImplParser(IType javaType_) {
        this.javaType = javaType_;
    }

    public IStatus parse() {
        try {
            this.processSource(this.javaType);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtil.errorStatus((Throwable)e);
            SCAToolsUIPlugin.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    public void processSource(IType javaType) {
        ICompilationUnit icu = javaType.getCompilationUnit();
        CompilationUnit cu = this.parseForCompilationUnit(icu);
        List cuTypes = cu.types();
        for (Object cuTypeObject : cuTypes) {
            IAnnotationBinding[] annotationBindings;
            TypeDeclaration typeDecl;
            if (!(cuTypeObject instanceof TypeDeclaration) || !(typeDecl = (TypeDeclaration)cuTypeObject).getName().getIdentifier().equals(javaType.getElementName())) continue;
            ITypeBinding typeBinding = typeDecl.resolveBinding();
            IAnnotationBinding[] iAnnotationBindingArray = annotationBindings = typeBinding.getAnnotations();
            int n = annotationBindings.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                if ("org.osoa.sca.annotations.Service".equals(annotationBinding.getAnnotationType().getQualifiedName())) {
                    IMemberValuePairBinding[] attrs;
                    this.isImplBeanAnnotated = true;
                    this.javaClassName = javaType.getFullyQualifiedName();
                    IMemberValuePairBinding[] iMemberValuePairBindingArray = attrs = annotationBinding.getDeclaredMemberValuePairs();
                    int n3 = attrs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemberValuePairBinding attr = iMemberValuePairBindingArray[n4];
                        if (attr.getName().equals("interfaces")) {
                            this.interfaceName = (String)attr.getValue();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    protected CompilationUnit parseForCompilationUnit(ICompilationUnit icu) {
        ASTParser parser_ = ASTParser.newParser((int)3);
        parser_.setSource(icu);
        parser_.setResolveBindings(true);
        return (CompilationUnit)parser_.createAST(null);
    }

    public boolean isAnnotated() {
        return this.isImplBeanAnnotated;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }
}

