/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project.impltypes;

import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImplTypeLabelProvider
implements ITableLabelProvider,
IColorProvider {
    Hashtable<String, Image> labelImageMap = new Hashtable();

    public ImplTypeLabelProvider(Set<ImplTypeEntry> allImplTypes) {
        for (ImplTypeEntry entry : allImplTypes) {
            this.labelImageMap.put(entry.getID(), this.getImage(entry));
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ImplTypeEntry entry = (ImplTypeEntry)element;
        return this.labelImageMap.get(entry.getID());
    }

    public String getColumnText(Object element, int columnIndex) {
        ImplTypeEntry entry = (ImplTypeEntry)element;
        return entry.getName();
    }

    public void dispose() {
        for (Image image : this.labelImageMap.values()) {
            if (image == null) continue;
            image.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    private Image getImage(ImplTypeEntry entry) {
        Bundle iconBundle = Platform.getBundle((String)entry.getIconNamespace());
        URL iconURL = FileLocator.find((Bundle)iconBundle, (IPath)new Path(entry.getIconPath()), null);
        return ImageDescriptor.createFromURL((URL)iconURL).createImage();
    }
}

