/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeListener;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.preferences.SCAPreferencesComposite;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SCAProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private String INFOPOP_SCAPROJECT_PROPERTIES = "SCAPROJECTPROPERTIES";
    private SCAPreferencesComposite prefComposite;
    private IProject project;
    private Map<String, Boolean> oldSelectedMap;
    private Set<ImplTypeEntry> implTypes;
    private SCAPreferences preferences;
    private Button useProjectSettings;

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement();
        this.createProjectEnabledComposite(parent);
        this.prefComposite = new SCAPreferencesComposite(parent, 0, this.project, (IWorkbenchPreferenceContainer)this.getContainer());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.prefComposite, "com.ibm.ccl.sca.ui." + this.INFOPOP_SCAPROJECT_PROPERTIES);
        this.prefComposite.createContents();
        this.oldSelectedMap = new HashMap<String, Boolean>();
        this.implTypes = Activator.getDefault().getAllImplTypes();
        this.preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        this.applyDialogFont(this.prefComposite);
        this.storeOldSelectedImpls();
        boolean projectEnabled = this.preferences.isProjectEnabled(this.project);
        this.prefComposite.enableControls(projectEnabled);
        this.useProjectSettings.setSelection(projectEnabled);
        return this.prefComposite;
    }

    public void dispose() {
        this.prefComposite.dispose();
        super.dispose();
    }

    private void storeOldSelectedImpls() {
        for (ImplTypeEntry entry : this.implTypes) {
            String id = entry.getID();
            this.oldSelectedMap.put(id, this.preferences.getSelectedImplType(id, this.project));
        }
    }

    protected void performApply() {
        if (this.prefComposite.checkIfOkToSaveValues()) {
            this.preferences.setProjectEnabled(this.project, this.useProjectSettings.getSelection());
            this.prefComposite.storeValues();
            this.callListenersIfNecessary();
            this.updateClasspathForJavaProject();
        }
    }

    public boolean performCancel() {
        return this.prefComposite.performCancel();
    }

    protected void performDefaults() {
        this.prefComposite.performDefaults();
    }

    public boolean performOk() {
        boolean okToSave = this.prefComposite.checkIfOkToSaveValues();
        if (okToSave) {
            this.preferences.setProjectEnabled(this.project, this.useProjectSettings.getSelection());
            this.prefComposite.storeValues();
            this.callListenersIfNecessary();
            this.updateClasspathForJavaProject();
        }
        return okToSave;
    }

    private void updateClasspathForJavaProject() {
        try {
            if (this.project.getNature("org.eclipse.jdt.core.javanature") == null) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            javaProject.setRawClasspath(entries, null);
        }
        catch (CoreException coreException) {}
    }

    private void callListenersIfNecessary() {
        for (ImplTypeEntry entry : this.implTypes) {
            boolean newValue;
            String id = entry.getID();
            boolean oldValue = this.oldSelectedMap.get(id);
            if (oldValue == (newValue = this.preferences.getSelectedImplType(id, this.project))) continue;
            this.callListener(entry, newValue);
        }
    }

    private void callListener(ImplTypeEntry entry, boolean add) {
        try {
            IImplTypeChangeListener listener = entry.getListener();
            if (listener != null) {
                listener.implTypeChanged((IImplTypeChangeEvent)new ImplTypeChangeEvent(this.project, add));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void createProjectEnabledComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData();
        composite.setFont(parent.getFont());
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useProjectSettings = new Button(composite, 32);
        this.useProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCAProjectPropertyPage.this.prefComposite.enableControls(SCAProjectPropertyPage.this.useProjectSettings.getSelection());
            }
        });
        this.useProjectSettings.setText(Messages.SCAProjectPropertyPage_0);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.useProjectSettings.setLayoutData((Object)gd);
        Link workspaceSettings = UIUtils.createLinkToPreference(composite, Messages.SCAProjectPropertyPage_1, "com.ibm.ccl.sca.internal.ui.preferences.mainPreferencePage");
        workspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(composite.getFont());
    }
}

