/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeContentProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeLabelProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeViewerComparator;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class SCAProjectCreationPage
extends WizardNewProjectCreationPage {
    private String INFOPOP_SCAPROJECT_CREATION = "SCAPROJECTCREATION";
    public Combo serverTargetCombo;
    public Button createNewRuntime;
    public static int NUM_DEFAULT_IMPL_TYPES = 2;
    public static final String SCAFP_FACET_BASE = "com.ibm.websphere.scafp";
    public static final String IMPLEMENTATION_ID_JAVA = "implementation.java";
    public static final String IMPLEMENTATION_ID_COMPOSITE = "implementation.composite";
    Set<IRuntime> scaRuntimes;
    ArrayList<IRuntime> runtimes;
    private IProject existingProject;
    private Set<ImplTypeEntry> allImplTypes;
    private Set<ImplTypeEntry> selectedImplTypes;
    private ScrolledComposite implTypesScroll;
    private CheckboxTableViewer implTypesTableViewer;
    private boolean nextEnabled = false;

    public SCAProjectCreationPage(String pageName, IProject existingProject) {
        super(pageName);
        this.existingProject = existingProject;
        if (existingProject != null) {
            this.setInitialProjectName(existingProject.getName());
        }
        this.allImplTypes = Activator.getDefault().getAllImplTypes();
        this.selectedImplTypes = new HashSet<ImplTypeEntry>();
    }

    private void initControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Composite projectComposite = new Composite(composite, 0);
        projectComposite.setLayoutData((Object)new GridData(768));
        projectComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(projectComposite, 0);
        label.setText(Messages.PROJECT);
        Text text = new Text(projectComposite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.existingProject.getName());
        text.setEnabled(false);
        this.setPageComplete(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void createControl(Composite parent) {
        if (this.existingProject == null) {
            super.createControl(parent);
        } else {
            this.initControl(parent);
        }
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Composite pageui = (Composite)this.getControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageui, "com.ibm.ccl.sca.ui." + this.INFOPOP_SCAPROJECT_CREATION);
        Group runtimeGroup = uiUtils.createGroup(pageui, Messages.TARGET_RUNTIME, Messages.TARGET_RUNTIME_TOOLTIP, null, 3, -1, -1);
        this.serverTargetCombo = uiUtils.createCombo((Composite)runtimeGroup, null, Messages.TARGET_RUNTIME_TOOLTIP, null, 2056);
        if (ProjectFacetsManager.isProjectFacetDefined((String)SCAFP_FACET_BASE)) {
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)SCAFP_FACET_BASE);
            this.scaRuntimes = RuntimeManager.getRuntimes((Set)pf.getVersions());
        } else {
            this.scaRuntimes = new HashSet<IRuntime>();
        }
        this.runtimes = new ArrayList<IRuntime>(this.scaRuntimes);
        int i = 0;
        while (i < this.runtimes.size()) {
            this.serverTargetCombo.add(this.runtimes.get(i).getLocalizedName(), i);
            ++i;
        }
        this.serverTargetCombo.add(Messages.NONE);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
        this.createNewRuntime = uiUtils.createPushButton((Composite)runtimeGroup, Messages.NEW_RUNTIME, Messages.NEW_RUNTIME_TOOLTIP, null);
        this.createNewRuntime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean runtimeCreated = ServerUIUtil.showNewRuntimeWizard((Shell)SCAProjectCreationPage.this.getShell(), null, null, (String)"com.ibm.ws.ast.st.runtime.v70");
                if (runtimeCreated) {
                    if (!ProjectFacetsManager.isProjectFacetDefined((String)SCAProjectCreationPage.SCAFP_FACET_BASE)) {
                        return;
                    }
                    IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)SCAProjectCreationPage.SCAFP_FACET_BASE);
                    Set newRuntimes = RuntimeManager.getRuntimes((Set)pf.getVersions());
                    newRuntimes.removeAll(SCAProjectCreationPage.this.scaRuntimes);
                    SCAProjectCreationPage.this.serverTargetCombo.removeAll();
                    SCAProjectCreationPage.this.runtimes.addAll(newRuntimes);
                    int i = 0;
                    while (i < SCAProjectCreationPage.this.runtimes.size()) {
                        SCAProjectCreationPage.this.serverTargetCombo.add(SCAProjectCreationPage.this.runtimes.get(i).getLocalizedName(), i);
                        ++i;
                    }
                    SCAProjectCreationPage.this.serverTargetCombo.add(Messages.NONE);
                    if (SCAProjectCreationPage.this.runtimes.size() > 0) {
                        SCAProjectCreationPage.this.serverTargetCombo.select(SCAProjectCreationPage.this.runtimes.size() - 1);
                    }
                    SCAProjectCreationPage.this.scaRuntimes = new HashSet<IRuntime>(SCAProjectCreationPage.this.runtimes);
                }
            }
        });
        if (!this.containsDefaultImplTypes(this.allImplTypes) || this.existingProject != null) {
            Group projectGroup = uiUtils.createGroup(pageui, Messages.PROJECT_SETTINGS, null, null);
            GridData gridData = new GridData(1808);
            Label implTypesLabel = new Label((Composite)projectGroup, 16384);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = false;
            gridData.horizontalSpan = 1;
            gridData.verticalIndent = 20;
            implTypesLabel.setLayoutData((Object)gridData);
            implTypesLabel.setText(Messages.LABEL_IMPL_TYPES_WIZARD);
            this.implTypesScroll = new ScrolledComposite((Composite)projectGroup, 2816);
            this.implTypesScroll.setExpandHorizontal(true);
            this.implTypesScroll.setExpandVertical(true);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = false;
            gridData.horizontalSpan = 1;
            this.implTypesScroll.setLayoutData((Object)gridData);
            this.implTypesTableViewer = CheckboxTableViewer.newCheckList((Composite)this.implTypesScroll, (int)2);
            this.implTypesScroll.setContent((Control)this.implTypesTableViewer.getTable());
            this.implTypesTableViewer.setContentProvider((IContentProvider)new ImplTypeContentProvider());
            this.implTypesTableViewer.setLabelProvider((IBaseLabelProvider)new ImplTypeLabelProvider(this.allImplTypes));
            this.implTypesTableViewer.setComparator((ViewerComparator)new ImplTypeViewerComparator());
            this.implTypesTableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SCAProjectCreationPage.this.implTypeChecked(event, (ImplTypeEntry)event.getElement());
                }
            });
            this.setupTableViewer(this.implTypesTableViewer);
            this.setImplValuesAndTableView();
        } else {
            this.selectedImplTypes.addAll(this.allImplTypes);
            this.nextEnabled = true;
        }
    }

    private void setImplValuesAndTableView() {
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (preferences.getSelectedImplType(entry.getID(), null)) {
                this.implTypesTableViewer.setChecked((Object)entry, true);
                this.selectedImplTypes.add(entry);
                if (!entry.getID().equals(IMPLEMENTATION_ID_JAVA)) continue;
                this.nextEnabled = true;
                continue;
            }
            this.implTypesTableViewer.setChecked((Object)entry, false);
        }
    }

    public void saveImplValuesToPreferenceStore(IProject project) {
        boolean selection;
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        boolean listChanged = false;
        if (this.implTypesTableViewer == null) {
            return;
        }
        for (ImplTypeEntry entry : this.allImplTypes) {
            boolean oldValue;
            selection = this.implTypesTableViewer.getChecked((Object)entry);
            if (selection == (oldValue = preferences.getSelectedImplType(entry.getID(), null))) continue;
            listChanged = true;
            break;
        }
        if (listChanged) {
            preferences.setProjectEnabled(project, true);
            for (ImplTypeEntry entry : this.allImplTypes) {
                selection = this.implTypesTableViewer.getChecked((Object)entry);
                preferences.setSelectedImplType(entry.getID(), selection, project);
            }
            preferences.flushPreferences(project);
        }
    }

    private boolean containsDefaultImplTypes(Set<ImplTypeEntry> implTypes) {
        boolean containsJavaImpl = false;
        boolean containsCompositeImpl = false;
        for (ImplTypeEntry entry : implTypes) {
            if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                containsJavaImpl = true;
                continue;
            }
            if (!entry.getID().equals(IMPLEMENTATION_ID_COMPOSITE)) continue;
            containsCompositeImpl = true;
        }
        return containsJavaImpl && containsCompositeImpl && implTypes.size() == NUM_DEFAULT_IMPL_TYPES;
    }

    private void setupTableViewer(CheckboxTableViewer implTypesTableViewer) {
        implTypesTableViewer.setInput(this.allImplTypes);
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (!entry.isRequired()) continue;
            implTypesTableViewer.setGrayed((Object)entry, true);
        }
    }

    private void implTypeChecked(CheckStateChangedEvent event, ImplTypeEntry entry) {
        if (event.getChecked()) {
            entry.setSelected(true);
            if (!ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) {
                this.selectedImplTypes.add(entry);
                if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                    this.nextEnabled = true;
                    this.setPageComplete(this.isPageComplete());
                }
            }
        } else if (!entry.isRequired()) {
            entry.setSelected(false);
            for (ImplTypeEntry e : this.selectedImplTypes) {
                if (!e.getID().equals(entry.getID())) continue;
                this.selectedImplTypes.remove(e);
                if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                    this.nextEnabled = false;
                    this.setPageComplete(this.isPageComplete());
                }
                break;
            }
        } else {
            this.implTypesTableViewer.setChecked((Object)entry, true);
            entry.setSelected(true);
        }
    }

    public IRuntime getRuntimeSelection() {
        if (this.runtimes.size() <= this.serverTargetCombo.getSelectionIndex()) {
            return null;
        }
        return this.runtimes.get(this.serverTargetCombo.getSelectionIndex());
    }

    public Set<ImplTypeEntry> getAllImplTypes() {
        return this.allImplTypes;
    }

    public Set<ImplTypeEntry> getSelectedImplTypes() {
        return this.selectedImplTypes;
    }

    public void setVisible(boolean visible) {
        if (this.existingProject == null) {
            super.setVisible(visible);
        } else {
            this.getControl().setVisible(visible);
        }
    }

    protected boolean validatePage() {
        if (this.existingProject == null) {
            return super.validatePage();
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.nextEnabled;
    }
}

