/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeListener;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeContentProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeLabelProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeViewerComparator;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String PROJECT_PROPERTY_NAMESPACE = "com.ibm.ccl.sca.facets.core";
    private static final String JAVA_FACET_ID = "jst.java";
    Set<ImplTypeEntry> allImplTypes = new HashSet<ImplTypeEntry>();
    Set<ImplTypeEntry> selectedImplTypes = new HashSet<ImplTypeEntry>();
    private ScrolledComposite implTypesScroll;
    private CheckboxTableViewer implTypesTableViewer;
    private IProject project;

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement();
        this.allImplTypes = Activator.getDefault().getAllImplTypes();
        this.readImplTypesFromStore();
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        Label implTypesLabel = new Label(composite, 16384);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalIndent = 20;
        implTypesLabel.setLayoutData((Object)gridData);
        implTypesLabel.setText(Messages.LABEL_IMPL_TYPES_PROPERTY);
        this.implTypesScroll = new ScrolledComposite(composite, 2816);
        this.implTypesScroll.setExpandHorizontal(true);
        this.implTypesScroll.setExpandVertical(true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        this.implTypesScroll.setLayoutData((Object)gridData);
        this.implTypesTableViewer = CheckboxTableViewer.newCheckList((Composite)this.implTypesScroll, (int)2);
        this.implTypesScroll.setContent((Control)this.implTypesTableViewer.getTable());
        this.implTypesTableViewer.setContentProvider((IContentProvider)new ImplTypeContentProvider());
        this.implTypesTableViewer.setLabelProvider((IBaseLabelProvider)new ImplTypeLabelProvider(this.allImplTypes));
        this.implTypesTableViewer.setComparator((ViewerComparator)new ImplTypeViewerComparator());
        this.implTypesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectPropertyPage.this.implTypeChecked(event, (ImplTypeEntry)event.getElement());
            }
        });
        this.setupTableViewer(this.implTypesTableViewer);
        this.applyDialogFont(composite);
        return composite;
    }

    private void setupTableViewer(CheckboxTableViewer implTypesTableViewer) {
        implTypesTableViewer.setInput(this.allImplTypes);
        implTypesTableViewer.setCheckedElements(this.selectedImplTypes.toArray());
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (!entry.isRequired()) continue;
            implTypesTableViewer.setGrayed((Object)entry, true);
        }
    }

    private void implTypeChecked(CheckStateChangedEvent event, ImplTypeEntry entry) {
        block6: {
            try {
                if (event.getChecked()) {
                    entry.setSelected(true);
                    if (!ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) {
                        this.selectedImplTypes.add(entry);
                    }
                    break block6;
                }
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project, (boolean)true, null);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)JAVA_FACET_ID);
                boolean hasJavaFacet = facetedProject.hasProjectFacet(facet);
                if (!entry.isRequired() && !hasJavaFacet) {
                    entry.setSelected(false);
                    for (ImplTypeEntry e : this.selectedImplTypes) {
                        if (!e.getID().equals(entry.getID())) continue;
                        this.selectedImplTypes.remove(e);
                        break block6;
                    }
                    break block6;
                }
                this.implTypesTableViewer.setChecked((Object)entry, true);
                entry.setSelected(true);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void performApply() {
        this.callListenersIfNecessary();
        this.saveImplTypesToStore();
        super.performApply();
    }

    public boolean performCancel() {
        super.performCancel();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.callListenersIfNecessary();
        this.saveImplTypesToStore();
        return super.performOk();
    }

    private void callListenersIfNecessary() {
        try {
            for (ImplTypeEntry entry : this.allImplTypes) {
                QualifiedName qn = new QualifiedName(PROJECT_PROPERTY_NAMESPACE, entry.getID());
                if (this.project.getPersistentProperty(qn).equals(TRUE)) {
                    if (ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) continue;
                    this.callListener(entry, false);
                    continue;
                }
                if (!ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) continue;
                this.callListener(entry, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void callListener(ImplTypeEntry entry, boolean add) {
        try {
            IImplTypeChangeListener listener = entry.getListener();
            if (listener != null) {
                listener.implTypeChanged((IImplTypeChangeEvent)new ImplTypeChangeEvent(this.project, add));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readImplTypesFromStore() {
        try {
            for (ImplTypeEntry entry : this.allImplTypes) {
                QualifiedName qn = new QualifiedName(PROJECT_PROPERTY_NAMESPACE, entry.getID());
                String p = this.project.getPersistentProperty(qn);
                if (p == null || !p.equals(TRUE)) continue;
                this.selectedImplTypes.add(entry);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void saveImplTypesToStore() {
        try {
            for (ImplTypeEntry entry : this.allImplTypes) {
                QualifiedName qn = new QualifiedName(PROJECT_PROPERTY_NAMESPACE, entry.getID());
                if (ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) {
                    this.project.setPersistentProperty(qn, TRUE);
                    continue;
                }
                this.project.setPersistentProperty(qn, FALSE);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

