/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.provider;

import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.SCANodeRegistry;
import com.ibm.ccl.sca.internal.ui.navigator.framework.AbstractContentProvider;
import com.ibm.ccl.sca.internal.ui.navigator.framework.IRootObjectProvider;
import com.ibm.ccl.sca.internal.ui.navigator.framework.ModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.provider.IProjectBasedProvider;
import com.ibm.ccl.sca.internal.ui.navigator.provider.SCARootObjectProvider;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.ISCARootNodeFactory;
import com.ibm.ccl.sca.ui.navigator.SCABaseContentProvider;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;

public class SCAContentProvider
extends AbstractContentProvider
implements ISCARootNodeFactory,
IProjectBasedProvider {
    private List<SCABaseContentProvider> childProviders = SCANodeRegistry.getInstance().getContentProviders();
    private Map<String, SCARootNode> nodes;

    public SCAContentProvider() {
        for (SCABaseContentProvider provider : this.childProviders) {
            provider.setRootNodeFactory(this);
        }
        this.nodes = new Hashtable<String, SCARootNode>();
        this.rootObjectProvider = new SCARootObjectProvider(this);
        this.init();
    }

    List<SCABaseContentProvider> getChildProviders() {
        return this.childProviders;
    }

    @Override
    public synchronized void handleDelete(IProject project) {
        this.nodes.remove(project.getFullPath().toString());
        for (SCABaseContentProvider provider : this.childProviders) {
            if (!(provider instanceof IProjectBasedProvider)) continue;
            ((IProjectBasedProvider)((Object)provider)).handleDelete(project);
        }
    }

    @Override
    public ModelManager getModelManager(Object context, IRootObjectProvider rootObjectProvider) {
        return null;
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof ISCANode) {
            return ((ISCANode)element).getParent();
        }
        for (SCABaseContentProvider provider : this.childProviders) {
            Object parent = provider.getParent(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof SCARootNode) {
            return true;
        }
        for (SCABaseContentProvider provider : this.childProviders) {
            if (!provider.hasChildren(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized SCARootNode createRootNode(IProject project) {
        String projectPath = project.getFullPath().toString();
        SCARootNode root = this.nodes.get(projectPath);
        if (root == null) {
            root = new SCARootNode(project);
            this.nodes.put(projectPath, root);
        }
        return root;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            return new Object[]{this.createRootNode(project)};
        }
        if (parentElement instanceof IAdaptable) {
            Object[] models = null;
            if (Job.getJobManager().currentJob() != null) {
                models = this.rootObjectProvider.getModels(parentElement);
                this.rootObjectProvider.setModelLoaded(parentElement, true);
            } else {
                models = super.getChildren(parentElement);
            }
            return models;
        }
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return null;
    }

    @Override
    public void onRefresh(final Object element) {
        if (element instanceof IProject) {
            if (this.viewer == null) {
                return;
            }
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SCAContentProvider.this.viewer.refresh(element);
                }
            });
        } else {
            super.onRefresh(element);
        }
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (this.childProviders != null) {
            for (SCABaseContentProvider provider : this.childProviders) {
                provider.inputChanged(viewer, oldInput, newInput);
            }
        }
        if (newInput instanceof IWorkspaceRoot) {
            SCAModelManager.init((IWorkspace)((IWorkspaceRoot)newInput).getWorkspace());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SCABaseContentProvider provider : this.childProviders) {
            provider.dispose();
        }
        this.childProviders.clear();
        this.childProviders = null;
        this.nodes.clear();
        this.nodes = null;
    }
}

