/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.provider;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelChangeEvent;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.internal.ui.navigator.node.CompositeNode;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.internal.ui.navigator.provider.IProjectBasedProvider;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCABaseContentProvider;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CompositeContentProvider
extends SCABaseContentProvider
implements IProjectBasedProvider {
    private Map<String, CompositeNode> nodes = new Hashtable<String, CompositeNode>();

    @Override
    public synchronized void handleDelete(IProject project) {
        this.nodes.remove(project.getFullPath().toString());
    }

    public Object getParent(Object element) {
        if (element instanceof ISCAComposite) {
            ISCAComposite composite = (ISCAComposite)element;
            CompositeNode node = (CompositeNode)this.createTopLevelNode(this.rootNodeFactory.createRootNode(composite.getResource().getProject()));
            return node.getNamespaceNode(composite.getName().getNamespaceURI());
        }
        return null;
    }

    private List<ISCAComposite> getComposites(IProject project) {
        try {
            ISCAProject scaProject = SCAModelManager.createProject((IProject)project);
            return SCAModelManager.getComposites((ISCAProject)scaProject);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CompositeNode) {
            CompositeNode node = (CompositeNode)element;
            List<ISCAComposite> composites = this.getComposites(node.getProject());
            return composites != null && composites.size() > 0;
        }
        if (element instanceof NamespaceNode) {
            return true;
        }
        if (element instanceof ISCAComposite) {
            ISCAComposite composite = (ISCAComposite)element;
            return composite.getComponents().size() > 0;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CompositeNode) {
            return ((CompositeNode)parentElement).getNamespaceNodes();
        }
        if (parentElement instanceof NamespaceNode) {
            return ((NamespaceNode)parentElement).getChildren();
        }
        if (parentElement instanceof ISCAComposite) {
            ISCAComposite composite = (ISCAComposite)parentElement;
            List names = composite.getComponents();
            Object[] components = new ComponentNode[names.size()];
            int i = 0;
            while (i < names.size()) {
                components[i] = new ComponentNode(composite, (String)names.get(i));
                ++i;
            }
            return components;
        }
        return null;
    }

    @Override
    public synchronized ISCANode createTopLevelNode(SCARootNode root) {
        String projectPath = root.getProject().getFullPath().toString();
        CompositeNode compositeNode = this.nodes.get(projectPath);
        if (compositeNode == null) {
            compositeNode = new CompositeNode(root);
            this.nodes.put(projectPath, compositeNode);
        }
        return compositeNode;
    }

    @Override
    public Object processEvent(SCAModelChangeEvent event) {
        int type = event.getType();
        if (type != 17 && type != 18 && type != 20) {
            return null;
        }
        IResource resource = (IResource)event.getSource();
        CompositeNode node = this.nodes.get(resource.getProject().getFullPath().toString());
        if (node == null || node.calculateNamespaceNodes() || type == 20) {
            return node;
        }
        ISCAComposite composite = (ISCAComposite)resource.getAdapter(ISCAArtifact.class);
        if (type == 17) {
            return node.getNamespaceNode(composite.getName().getNamespaceURI());
        }
        return composite;
    }

    public void dispose() {
        this.nodes.clear();
        this.nodes = null;
    }
}

