/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.node;

import com.ibm.ccl.sca.internal.ui.navigator.node.CompositeNode;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.navigator.IDisposable;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class NamespaceNode
extends PlatformObject
implements ISCANode,
IDisposable,
IWorkbenchAdapter {
    private static final String NAMESPACE_NODE_IMG = "NAMESPACE_NODE_IMG";
    private static final String NAMESPACE_NODE_GIF = "icons/namespace_node.gif";
    private static ImageRegistry imageRegistry = SCAToolsUIPlugin.getDefault().getImageRegistry();
    private Object parent;
    private String namespace;
    private String id;
    private int oldSize;
    private boolean disposed = false;
    private List<Object> children = new ArrayList<Object>();

    static {
        imageRegistry.put(NAMESPACE_NODE_IMG, SCAToolsUIPlugin.getImageDescriptor(NAMESPACE_NODE_GIF));
    }

    public NamespaceNode(Object parent, String namespace) {
        this.parent = parent;
        if (namespace == null) {
            namespace = "";
        }
        this.namespace = namespace;
        this.id = parent != null ? parent + "_" + namespace : namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public IProject getProject() {
        if (this.parent instanceof CompositeNode) {
            return ((CompositeNode)this.parent).getProject();
        }
        return null;
    }

    @Override
    public Image getImage() {
        return imageRegistry.get(NAMESPACE_NODE_IMG);
    }

    @Override
    public String getText() {
        return this.namespace.length() > 0 ? this.namespace : Messages.LABEL_NO_NAMESPACE;
    }

    @Override
    public boolean allowPaste() {
        return false;
    }

    public void addChild(Object composite) {
        this.children.add(composite);
    }

    public boolean removeChild(Object composite) {
        return this.children.remove(composite);
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public void clearChildren() {
        this.oldSize = this.children.size();
        this.children.clear();
    }

    public boolean sizeReduced() {
        return this.children.size() < this.oldSize;
    }

    public Object[] getChildren(Object o) {
        return this.getChildren();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return imageRegistry.getDescriptor(NAMESPACE_NODE_IMG);
    }

    public String getLabel(Object o) {
        return this.getText();
    }

    public Object getParent(Object o) {
        return this.getParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NamespaceNode) {
            return this.id.equals(((NamespaceNode)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.children.clear();
        this.disposed = true;
    }
}

