/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.node;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class CompositeNode
extends PlatformObject
implements ISCANode {
    private static final String COMPOSITE_NODE_IMG = "COMPOSITE_NODE_IMG";
    private static final String COMPOSITE_NODE_GIF = "icons/composite_node.gif";
    private static ImageRegistry imageRegistry = SCAToolsUIPlugin.getDefault().getImageRegistry();
    private SCARootNode root;
    private Map<String, NamespaceNode> namespaceNodes = new Hashtable<String, NamespaceNode>();

    static {
        imageRegistry.put(COMPOSITE_NODE_IMG, SCAToolsUIPlugin.getImageDescriptor(COMPOSITE_NODE_GIF));
    }

    public CompositeNode(SCARootNode root) {
        this.root = root;
        this.calculateNamespaceNodes();
    }

    @Override
    public Object getParent() {
        return this.root;
    }

    @Override
    public IProject getProject() {
        return this.root.getProject();
    }

    @Override
    public Image getImage() {
        return imageRegistry.get(COMPOSITE_NODE_IMG);
    }

    @Override
    public String getText() {
        return Messages.COMPOSITES;
    }

    @Override
    public boolean allowPaste() {
        return true;
    }

    private boolean internalSizeReduced() {
        for (NamespaceNode node : this.namespaceNodes.values()) {
            if (!node.sizeReduced()) continue;
            return true;
        }
        return false;
    }

    public boolean calculateNamespaceNodes() {
        try {
            ISCAProject project = SCAModelManager.createProject((IProject)this.getProject());
            List composites = SCAModelManager.getComposites((ISCAProject)project);
            Hashtable<String, NamespaceNode> newNamespaceNodes = new Hashtable<String, NamespaceNode>();
            boolean added = false;
            int origSize = this.namespaceNodes.size();
            for (ISCAComposite composite : composites) {
                String namespace = composite.getName().getNamespaceURI();
                NamespaceNode namespaceNode = (NamespaceNode)newNamespaceNodes.get(namespace);
                if (namespaceNode == null) {
                    if (this.namespaceNodes.containsKey(namespace)) {
                        namespaceNode = this.namespaceNodes.remove(namespace);
                        namespaceNode.clearChildren();
                        newNamespaceNodes.put(namespace, namespaceNode);
                    } else {
                        namespaceNode = new NamespaceNode(this, namespace);
                        newNamespaceNodes.put(namespace, namespaceNode);
                        added = true;
                    }
                }
                namespaceNode.addChild(composite);
            }
            for (NamespaceNode oldNode : this.namespaceNodes.values()) {
                oldNode.dispose();
            }
            this.namespaceNodes = newNamespaceNodes;
            return added || this.namespaceNodes.size() < origSize || this.internalSizeReduced();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public Object[] getNamespaceNodes() {
        return this.namespaceNodes.values().toArray();
    }

    public NamespaceNode getNamespaceNode(String namespace) {
        return this.namespaceNodes.get(namespace);
    }
}

