/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.framework;

import com.ibm.ccl.sca.internal.ui.navigator.framework.ClearPlaceHolderJob;
import com.ibm.ccl.sca.internal.ui.navigator.framework.IRootObjectProvider;
import com.ibm.ccl.sca.internal.ui.navigator.framework.LoadingModelNode;
import com.ibm.ccl.sca.internal.ui.navigator.framework.LoadingModelUIJob;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;

public class LoadingModelJob
extends Job {
    private IRootObjectProvider rootObjectProvider;
    private LoadingModelNode placeHolder;
    private AbstractTreeViewer viewer;
    private IAdaptable parent;

    public LoadingModelJob(AbstractTreeViewer viewer, LoadingModelNode placeHolder, IAdaptable parent, IRootObjectProvider rootObjectProvider) {
        super(placeHolder.getText());
        this.viewer = viewer;
        this.placeHolder = placeHolder;
        this.parent = parent;
        this.rootObjectProvider = rootObjectProvider;
        this.setRule(new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        LoadingModelUIJob updateUIJob = new LoadingModelUIJob((StructuredViewer)this.viewer, this.placeHolder);
        updateUIJob.schedule();
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            Object[] rootObjects;
            Object[] objectArray = rootObjects = this.rootObjectProvider != null ? this.rootObjectProvider.getModels(this.parent) : null;
            if (rootObjects != null) {
                int x = 0;
                while (x < rootObjects.length) {
                    children.add(rootObjects[x]);
                    ++x;
                }
            }
            this.rootObjectProvider.setModelLoaded(this.parent, true);
        }
        finally {
            this.placeHolder.dispose();
            new ClearPlaceHolderJob(this.viewer, this.placeHolder, this.parent, children.toArray()).schedule();
        }
        return Status.OK_STATUS;
    }
}

