/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.framework;

import com.ibm.ccl.sca.internal.ui.navigator.framework.IRefreshHandlerListener;
import com.ibm.ccl.sca.internal.ui.navigator.framework.IRootObjectProvider;
import com.ibm.ccl.sca.internal.ui.navigator.framework.LoadingModelJob;
import com.ibm.ccl.sca.internal.ui.navigator.framework.LoadingModelNode;
import com.ibm.ccl.sca.internal.ui.navigator.framework.ModelManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractContentProvider
implements ITreeContentProvider,
IRefreshHandlerListener {
    protected IRootObjectProvider rootObjectProvider;
    protected String viewerId = null;
    protected String newViewerId = null;
    protected AbstractTreeViewer viewer;

    public abstract ModelManager getModelManager(Object var1, IRootObjectProvider var2);

    public abstract Object getParent(Object var1);

    public abstract boolean hasChildren(Object var1);

    public AbstractContentProvider() {
    }

    public AbstractContentProvider(String aViewerId) {
        this.viewerId = aViewerId;
    }

    protected void init() {
        this.rootObjectProvider.addRefreshHandlerListener(this);
    }

    public void dispose() {
        this.rootObjectProvider.removeRefreshHandlerListener(this);
        this.rootObjectProvider.dispose();
    }

    public Object[] getElements(Object anInputElement) {
        return this.getChildren(anInputElement);
    }

    public Object[] getChildren(Object aParentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        this.getModelManager(aParentElement, this.rootObjectProvider);
        if (LoadingModelNode.isBeingLoaded(aParentElement)) {
            children.add(LoadingModelNode.createPlaceHolder(aParentElement));
        } else if (this.rootObjectProvider.hasLoadedModels(aParentElement)) {
            children.addAll(Arrays.asList(this.rootObjectProvider.getModels(aParentElement)));
        } else {
            LoadingModelNode placeHolder = LoadingModelNode.createPlaceHolder(aParentElement);
            if (LoadingModelNode.canBeginLoading(aParentElement)) {
                new LoadingModelJob(this.viewer, placeHolder, (IAdaptable)aParentElement, this.rootObjectProvider).schedule();
            }
            children.add(placeHolder);
        }
        return children.toArray();
    }

    @Override
    public void onRefresh(final Object element) {
        if (Display.getCurrent() != null) {
            this.viewer.refresh(element, true);
        } else {
            UIJob job = new UIJob("Update the Navigator Content Viewer Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AbstractContentProvider.this.viewer.refresh(element, true);
                    return Status.OK_STATUS;
                }
            };
            ISchedulingRule rule = new ISchedulingRule(){

                public boolean contains(ISchedulingRule rule) {
                    return rule == this;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    return rule == this;
                }
            };
            job.setRule(rule);
            job.schedule();
        }
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = (AbstractTreeViewer)aViewer;
        if (aViewer instanceof CommonViewer) {
            this.newViewerId = ((CommonViewer)aViewer).getNavigatorContentService().getViewerId();
        }
    }
}

