/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.dnd;

import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.SCANodeRegistry;
import com.ibm.ccl.sca.internal.ui.navigator.dnd.SelectionHelper;
import com.ibm.ccl.sca.ui.navigator.ICopyMoveOperation;
import com.ibm.ccl.sca.ui.navigator.IPasteAssistant;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class DropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData transferType) {
        return LocalSelectionTransfer.getInstance().isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType);
    }

    private IStatus validateLocalDrop(Object target, int operation, TransferData transferData) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().nativeToJava(transferData);
        if (target instanceof IResource && selection.getFirstElement() instanceof IResource) {
            return null;
        }
        IResource[] resources = SelectionHelper.validateAndExtract(selection);
        if (resources == null) {
            return null;
        }
        for (IPasteAssistant pasteAssistant : SCANodeRegistry.getInstance().getPasteAssistants()) {
            if (!pasteAssistant.accept(target, resources)) continue;
            IContainer container = pasteAssistant.getContainer(target);
            if (container == null || operation != 1 && container.equals((Object)resources[0].getParent())) break;
            return Status.OK_STATUS;
        }
        return null;
    }

    private IStatus validateExternalDrop(Object target, int operation, TransferData transferData) {
        if (target instanceof IResource) {
            return null;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            return this.validateLocalDrop(target, operation, transferData);
        }
        if (FileTransfer.getInstance().isSupportedType(transferData)) {
            return this.validateExternalDrop(target, operation, transferData);
        }
        return null;
    }

    private IStatus handleLocalDrop(CommonDropAdapter dropAdapter, TransferData transferData, Object target) {
        int op = dropAdapter.getCurrentOperation();
        if (op != 1 && op != 2) {
            return Status.CANCEL_STATUS;
        }
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().nativeToJava(transferData);
        IResource[] resources = SelectionHelper.extract(selection);
        List<IPasteAssistant> pasteAssistants = SCANodeRegistry.getInstance().getPasteAssistants();
        for (IPasteAssistant pasteAssistant : pasteAssistants) {
            if (!pasteAssistant.accept(target, resources)) continue;
            IContainer container = pasteAssistant.getContainer(target);
            ICopyMoveOperation customOperation = null;
            if (!(target instanceof IResource) && SCAModelManager.hasSCAFacet((IProject)container.getProject()) && (customOperation = pasteAssistant.newCopyMoveOperation(this.getShell(), resources)) != null) {
                if (op == 1) {
                    customOperation.copyTo(container);
                } else {
                    customOperation.moveTo(container);
                }
            } else {
                Object defaultOperation = null;
                defaultOperation = op == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                defaultOperation.copyResources(resources, container);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleExternalDrop(CommonDropAdapter dropAdapter, Object transferData, Object target) {
        final String[] filenames = (String[])transferData;
        IContainer container = null;
        for (IPasteAssistant pasteAssistant : SCANodeRegistry.getInstance().getPasteAssistants()) {
            if (!pasteAssistant.accept(target, filenames)) continue;
            container = pasteAssistant.getContainer(target);
            break;
        }
        if (container == null) {
            return Status.CANCEL_STATUS;
        }
        final Shell shell = this.getShell();
        final IContainer destination = container;
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                shell.forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
                operation.copyFiles(filenames, destination);
            }
        });
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        TransferData transferData = dropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            this.handleLocalDrop(dropAdapter, transferData, target);
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            this.handleExternalDrop(dropAdapter, dropTargetEvent.data, target);
        }
        return null;
    }
}

