/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.dnd;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.internal.ui.navigator.action.CopyMoveCompositesOperation;
import com.ibm.ccl.sca.internal.ui.navigator.node.CompositeNode;
import com.ibm.ccl.sca.ui.navigator.ICopyMoveOperation;
import com.ibm.ccl.sca.ui.navigator.IPasteAssistant;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CompositePasteAssistant
implements IPasteAssistant {
    private static final String COMPOSITE_EXT = "composite";

    private IContainer getContainer(IProject project) {
        String path = SCAToolsCorePlugin.getInstance().getPreferences().getDefaultProjectFolder(project);
        return "".equals(path) ? project : project.getFolder((IPath)new Path(path));
    }

    @Override
    public IContainer getContainer(Object target) {
        if (target instanceof IContainer) {
            return (IContainer)target;
        }
        if (target instanceof IResource) {
            return ((IResource)target).getParent();
        }
        if (target instanceof ISCANode) {
            return this.getContainer(((ISCANode)target).getProject());
        }
        return ((ISCAComposite)target).getResource().getParent();
    }

    @Override
    public boolean accept(IStructuredSelection target, IResource[] resources) {
        return this.accept(target.getFirstElement(), resources);
    }

    @Override
    public boolean accept(Object target, IResource[] resources) {
        if (!(target instanceof IResource || target instanceof SCARootNode || target instanceof CompositeNode || target instanceof ISCAComposite)) {
            return false;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() != 1 || !resource.exists() || !COMPOSITE_EXT.equals(resource.getFileExtension())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean accept(IStructuredSelection selection, String[] filenames) {
        return this.accept(selection.getFirstElement(), filenames);
    }

    @Override
    public boolean accept(Object target, String[] filenames) {
        if (!(target instanceof IResource || target instanceof SCARootNode || target instanceof CompositeNode || target instanceof ISCAComposite)) {
            return false;
        }
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (!filename.endsWith(".composite")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public ICopyMoveOperation newCopyMoveOperation(Shell shell, IResource[] resources) {
        IResource resource;
        if (resources.length != 0 && (resource = resources[0]).getType() == 1 && COMPOSITE_EXT.equals(resource.getFileExtension())) {
            return new CopyMoveCompositesOperation(shell, resources);
        }
        return null;
    }
}

