/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeleteComponentAction
extends SelectionListenerAction {
    private Shell shell;

    public DeleteComponentAction(Shell shell) {
        super(Messages.DELETE);
        this.shell = shell;
    }

    private void performDelete(ISCAComposite composite, List<String> components) {
        try {
            Composite model = (Composite)composite.getModelObject();
            Iterator iter = model.getComponents().iterator();
            while (iter.hasNext()) {
                Component component = (Component)iter.next();
                String name = component.getName();
                if (!components.contains(name)) continue;
                components.remove(name);
                iter.remove();
            }
            IResource resource = composite.getResource();
            TuscanyModelHelper.getInstance().writeCompositeToFile(resource.getParent(), resource.getName(), model);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus(), 2);
        }
    }

    public void run() {
        if (!MessageDialog.openQuestion((Shell)this.shell, (String)Messages.LABEL_CONFIRM_DELETE_DIALOG_TITLE, (String)Messages.LABEL_CONFIRM_DELETE_COMPONENT)) {
            return;
        }
        ISCAComposite parent = null;
        ArrayList<String> components = null;
        for (ComponentNode component : this.getStructuredSelection()) {
            ISCAComposite newParent = (ISCAComposite)component.getParent();
            if (parent == null) {
                parent = newParent;
                components = new ArrayList<String>();
            } else if (!parent.equals(newParent)) {
                this.performDelete(parent, components);
                parent = newParent;
                components.clear();
            }
            components.add(component.getText());
        }
        if (parent != null) {
            this.performDelete(parent, components);
        }
    }
}

