/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.util.PlatformUtil;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeNameConflictDialog;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import com.ibm.ccl.sca.ui.navigator.ICopyMoveOperation;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Composite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class CopyMoveCompositesOperation
implements ICopyMoveOperation {
    private static final String COMPOSITE_EXT = "composite";
    private Shell shell;
    private List<ResourceAndComposite> composites = new ArrayList<ResourceAndComposite>();

    public CopyMoveCompositesOperation(Shell shell, IResource[] resources) {
        this.shell = shell;
        this.convertToComposites(resources);
    }

    private Composite readComposite(IResource resource) throws URISyntaxException {
        Path path = new Path(PlatformUtil.getFileURLFromPath((IPath)resource.getFullPath()));
        String folderFileURL = path.removeLastSegments(1).addTrailingSeparator().toString();
        ArrayList<URI> filenameURI = new ArrayList<URI>();
        filenameURI.add(new URI(null, path.lastSegment(), null));
        List list = TuscanyModelHelper.getInstance().loadArtifact(folderFileURL, filenameURI);
        return list.isEmpty() ? null : list.get(0);
    }

    private void convertToComposites(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Object adapted = resource.getAdapter(ISCAArtifact.class);
            try {
                ISCAComposite composite;
                if (adapted instanceof ISCAComposite) {
                    composite = (ISCAComposite)adapted;
                    this.composites.add(new ResourceAndComposite(resource, (Composite)composite.getModelObject()));
                } else if (resource.getType() == 1 && COMPOSITE_EXT.equals(resource.getFileExtension()) && (composite = this.readComposite(resource)) != null) {
                    this.composites.add(new ResourceAndComposite(resource, (Composite)composite));
                }
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (URISyntaxException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(StatusUtil.errorStatus((Throwable)e));
            }
            ++n2;
        }
    }

    private void fetchDestinationInfo(IContainer destination, List<QName> qNames, List<IResource> resources) throws CoreException {
        IProject project = destination.getProject();
        ISCAProject scaProject = SCAModelManager.createProject((IProject)project);
        for (ISCAComposite composite : SCAModelManager.getComposites((ISCAProject)scaProject)) {
            qNames.add(composite.getName());
            resources.add(composite.getResource());
        }
    }

    private void run(IContainer destination, boolean isMove) {
        try {
            ArrayList<QName> destinationQNames = new ArrayList<QName>();
            ArrayList<IResource> destinationResources = new ArrayList<IResource>();
            this.fetchDestinationInfo(destination, destinationQNames, destinationResources);
            for (ResourceAndComposite composite : this.composites) {
                IResource resource = composite.resource;
                String filename = resource.getName();
                QName qName = composite.composite.getName();
                IFile destinationFile = null;
                int removalIndex = -1;
                if (destination.findMember(filename) != null || destinationQNames.contains(qName)) {
                    CompositeNameConflictDialog dialog = new CompositeNameConflictDialog(this.shell);
                    dialog.setDestination(destination);
                    dialog.setQNames(destinationQNames);
                    dialog.setSourceFilename(filename);
                    dialog.setSourceQName(qName);
                    if (dialog.open() == 1) continue;
                    filename = dialog.getAdjustedFilename();
                    qName = dialog.getAdjustedQName();
                    if (dialog.hasPhysicalNameConflict()) {
                        destinationFile = destination.getFile((IPath)new Path(filename));
                        removalIndex = destinationResources.indexOf(destinationFile);
                    } else if (dialog.hasLogicalNameConflict()) {
                        removalIndex = destinationQNames.indexOf(qName);
                    }
                }
                try {
                    Composite clone = (Composite)composite.composite.clone();
                    clone.setName(qName);
                    IStatus status = TuscanyModelHelper.getInstance().writeCompositeToFile(destination, filename, clone);
                    if (status.isOK()) {
                        if (destinationFile == null) {
                            destinationFile = destination.getFile((IPath)new Path(filename));
                        }
                        if (removalIndex != -1) {
                            destinationQNames.remove(removalIndex);
                            IResource conflictingResource = (IResource)destinationResources.remove(removalIndex);
                            if (!conflictingResource.equals((Object)destinationFile)) {
                                conflictingResource.delete(true, null);
                            }
                        }
                        destinationQNames.add(qName);
                        destinationResources.add((IResource)destinationFile);
                        if (!isMove) continue;
                        resource.delete(true, null);
                        continue;
                    }
                    StatusManager.getManager().handle(status, 2);
                }
                catch (CloneNotSupportedException e) {
                    SCAToolsUIPlugin.getDefault().getLog().log(StatusUtil.errorStatus((Throwable)e));
                }
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus(), 2);
        }
    }

    @Override
    public void copyTo(IContainer container) {
        this.run(container, false);
    }

    @Override
    public void moveTo(IContainer container) {
        this.run(container, true);
    }

    private class ResourceAndComposite {
        IResource resource;
        Composite composite;

        ResourceAndComposite(IResource resource, Composite composite) {
            this.resource = resource;
            this.composite = composite;
        }
    }
}

