/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.internal.ui.navigator.action.PasteAction;
import com.ibm.ccl.sca.internal.ui.navigator.dnd.SelectionHelper;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyAction
extends SelectionListenerAction {
    private Clipboard clipboard;
    private PasteAction pasteAction;

    public CopyAction(Clipboard clipboard, PasteAction pasteAction) {
        super(Messages.COPY);
        this.clipboard = clipboard;
        this.pasteAction = pasteAction;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return SelectionHelper.validateAndExtract(selection) != null;
    }

    public void run() {
        List selected = this.getSelectedResources();
        IResource[] resources = new IResource[selected.size()];
        String[] filenames = new String[selected.size()];
        int fileIdx = 0;
        int i = 0;
        while (i < selected.size()) {
            IResource resource;
            resources[i] = resource = (IResource)selected.get(i);
            IPath location = resource.getLocation();
            if (location != null) {
                filenames[fileIdx++] = location.toOSString();
            }
            ++i;
        }
        if (fileIdx < filenames.length) {
            String[] oldArray = filenames;
            filenames = new String[fileIdx];
            System.arraycopy(oldArray, 0, filenames, 0, fileIdx);
        }
        this.clipboard.setContents(new Object[]{resources, filenames}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
        this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
    }
}

