/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class LinkHelper
implements ILinkHelper,
ISelectionListener {
    private static final String COMPOSITE_EXT = "composite";
    private static final String DIAGRAM_SUFFIX = "_diagram";
    private static final String DIAGRAM_EXT = "composite_diagram";
    private ISelection selection = null;

    public LinkHelper() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    private ISCAArtifact<?> findParentArtifact(Object object) {
        if (object instanceof ISCANode) {
            object = ((ISCANode)object).getParent();
        }
        if (object instanceof ISCAArtifact) {
            return (ISCAArtifact)object;
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        ISCAArtifact<?> artifact = this.findParentArtifact(selection.getFirstElement());
        if (artifact == null) {
            return;
        }
        IFile file = (IFile)artifact.getResource();
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && activeEditor.equals(editor)) {
            return;
        }
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        }
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        IResource resource = (IResource)anInput.getAdapter(IResource.class);
        if (DIAGRAM_EXT.equals(resource.getFileExtension())) {
            String name = resource.getName();
            name = name.substring(0, name.indexOf(DIAGRAM_SUFFIX));
            resource = resource.getParent().getFile((IPath)new Path(name));
        }
        if (resource.exists()) {
            IStructuredSelection structuredSelecction;
            ISCAArtifact<?> artifact;
            if (this.selection instanceof IStructuredSelection && (artifact = this.findParentArtifact((structuredSelecction = (IStructuredSelection)this.selection).getFirstElement())) != null && artifact.getResource().equals((Object)resource)) {
                return structuredSelecction;
            }
            try {
                SCAModelManager.createProject((IProject)resource.getProject());
                Object artifact2 = resource.getAdapter(ISCAArtifact.class);
                if (artifact2 != null) {
                    StructuredSelection newSelection = new StructuredSelection(artifact2);
                    this.selection = newSelection;
                    return newSelection;
                }
            }
            catch (CoreException coreException) {}
        }
        return StructuredSelection.EMPTY;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof CommonNavigator) {
            this.selection = selection;
        }
    }
}

