/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.extension.dialogs;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.List;
import org.apache.tuscany.sca.assembly.Composite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;

public class CompositeImplementationSelectionDialog
implements ISelectionDialog {
    private ICompositeSelectionDialog dialog;
    private IResource resource;

    public CompositeImplementationSelectionDialog(Shell shell, IResource resource) {
        this.dialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithSingleSelectTree(shell);
        this.resource = resource;
    }

    @Override
    public IDataBean getDataBean() {
        List<ISCAComposite> composites = this.dialog.getSelectedComposites();
        if (composites == null || composites.size() != 1) {
            return null;
        }
        ISCAComposite scaComposite = composites.get(0);
        com.ibm.ccl.sca.internal.core.bean.implementations.Composite compositeImpl = new com.ibm.ccl.sca.internal.core.bean.implementations.Composite();
        try {
            compositeImpl.setComposite((Composite)scaComposite.getModelObject(), true);
            compositeImpl.setCompositeFile((IFile)scaComposite.getResource());
        }
        catch (CoreException e) {
            Status error = new Status(4, "com.ibm.ccl.sca.ui", e.getLocalizedMessage());
            SCAToolsUIPlugin.getDefault().getLog().log((IStatus)error);
            return null;
        }
        return compositeImpl;
    }

    @Override
    public int open() {
        this.dialog.setCurrentResource(this.resource);
        this.dialog.initialize();
        return this.dialog.open();
    }

    @Override
    public boolean close() {
        return this.dialog.close();
    }
}

