/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.datatransfer.operations;

import com.ibm.ccl.sca.core.util.Logger;
import com.ibm.ccl.sca.internal.core.datatransfer.IImportDataStructureProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ImportOperation
extends WorkspaceModifyOperation {
    private static final int POLICY_DEFAULT = 0;
    private static final int POLICY_SKIP_CHILDREN = 1;
    private static final int POLICY_FORCE_OVERWRITE = 2;
    private Object source;
    private IPath destinationPath;
    private IContainer destinationContainer;
    private List<Object> selectedFilesList;
    private List<Object> rejectedFilesList;
    private IImportDataStructureProvider provider;
    private IProgressMonitor progressMonitor;
    protected IOverwriteQuery overwriteQuery;
    private Shell shell;
    private List<IStatus> statusErrorList = new ArrayList<IStatus>();
    private boolean isCreateContainerStructure = true;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;

    public ImportOperation(IPath containerPath, Object source, IImportDataStructureProvider provider, IOverwriteQuery overwriteImplementor) {
        this.destinationPath = containerPath;
        this.source = source;
        this.provider = provider;
        this.overwriteQuery = overwriteImplementor;
    }

    public ImportOperation(IPath containerPath, Object source, IImportDataStructureProvider provider, IOverwriteQuery overwriteImplementor, List<Object> filesToImport) {
        this(containerPath, source, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    public ImportOperation(IPath containerPath, IImportDataStructureProvider provider, IOverwriteQuery overwriteImplementor, List<Object> filesToImport) {
        this(containerPath, null, provider, overwriteImplementor);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        this.setFilesToImport(filesToImport);
    }

    void collectExistingReadonlyFiles(IPath sourceStart, List<?> list, ArrayList<Object> noOverwriteList, ArrayList<IFile> overwriteReadonlyList, int policy) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Iterator<?> iterator = list.iterator();
        Path sourceRootPath = null;
        if (this.source != null) {
            sourceRootPath = new Path(this.provider.getFullPath(this.source));
        }
        while (iterator.hasNext()) {
            IPath newDestinationPath;
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            Object nextSource = iterator.next();
            Path sourcePath = new Path(this.provider.getFullPath(nextSource));
            if (sourceRootPath == null) {
                newDestinationPath = sourceStart.append(this.provider.getLabel(nextSource));
            } else {
                int prefixLength = sourcePath.matchingFirstSegments((IPath)sourceRootPath);
                IPath relativeSourcePath = sourcePath.removeFirstSegments(prefixLength);
                newDestinationPath = this.destinationPath.append(relativeSourcePath);
            }
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            if (newDestination == null) continue;
            IFolder folder = this.getFolder(newDestination);
            if (folder != null) {
                if (!(policy == 2 || this.overwriteState != 1 && this.queryOverwrite(newDestinationPath))) {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    noOverwriteList.add(folder);
                    continue;
                }
                if (!this.provider.isFolder(nextSource)) continue;
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.collectExistingReadonlyFiles(newDestinationPath, this.provider.getChildren(nextSource), noOverwriteList, overwriteReadonlyList, 2);
                continue;
            }
            IFile file = this.getFile(newDestination);
            if (file == null) continue;
            if (!this.queryOverwriteFile(file, policy)) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                noOverwriteList.add(file.getFullPath());
                continue;
            }
            if (!file.isReadOnly()) continue;
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            overwriteReadonlyList.add(file);
        }
    }

    IContainer createContainersFor(IPath path) throws CoreException {
        IContainer currentFolder = this.destinationContainer;
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return currentFolder;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        if (currentFolder.getType() == 8) {
            return this.createFromRoot(path);
        }
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    private IContainer createFromRoot(IPath path) throws CoreException {
        int segmentCount = path.segmentCount();
        IProject currentFolder = ((IWorkspaceRoot)this.destinationContainer).getProject(path.segment(0));
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        int i = 1;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return currentFolder;
    }

    void deleteResource(IResource resource) {
        try {
            resource.delete(2, null);
        }
        catch (CoreException e) {
            Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
            this.statusErrorList.add(e.getStatus());
        }
    }

    protected void execute(IProgressMonitor progressMonitor) {
        block6: {
            this.progressMonitor = progressMonitor;
            try {
                try {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    if (this.selectedFilesList == null) {
                        progressMonitor.beginTask(Messages.SCA_IMPORTING_ARTIFACTS_MESSAGE, 1000);
                        ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                        progressMonitor.worked(30);
                        this.validateFiles(Arrays.asList(this.source));
                        progressMonitor.worked(50);
                        this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
                        this.importRecursivelyFrom(this.source, 0);
                        progressMonitor.worked(90);
                        break block6;
                    }
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    int creationCount = this.selectedFilesList.size();
                    progressMonitor.beginTask(Messages.SCA_IMPORTING_ARTIFACTS_MESSAGE, creationCount + 100);
                    ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                    progressMonitor.worked(30);
                    this.validateFiles(this.selectedFilesList);
                    progressMonitor.worked(50);
                    this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
                    this.importFileSystemObjects(this.selectedFilesList);
                    progressMonitor.done();
                }
                catch (CoreException e) {
                    Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
                    this.statusErrorList.add(e.getStatus());
                    progressMonitor.done();
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    IContainer getDestinationContainerFor(Object fileSystemObject) throws CoreException {
        Path pathname = new Path(this.provider.getFullPath(fileSystemObject));
        if (this.isCreateContainerStructure) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return this.createContainersFor(pathname.removeLastSegments(1));
        }
        if (this.source == fileSystemObject) {
            return null;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        Path sourcePath = new Path(this.provider.getFullPath(this.source));
        IPath destContainerPath = pathname.removeLastSegments(1);
        IPath relativePath = destContainerPath.removeFirstSegments(sourcePath.segmentCount()).setDevice(null);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return this.createContainersFor(relativePath);
    }

    IFile getFile(IResource resource) {
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        Object adapted = resource.getAdapter(IFile.class);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        if (adapted == null) {
            return null;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return (IFile)adapted;
    }

    IFolder getFolder(IResource resource) {
        if (resource instanceof IFolder) {
            return (IFolder)resource;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        Object adapted = resource.getAdapter(IFolder.class);
        if (adapted == null) {
            return null;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return (IFolder)adapted;
    }

    ArrayList<Object> getRejectedFiles(IStatus multiStatus, IFile[] files) {
        ArrayList<Object> filteredFiles = new ArrayList<Object>();
        IStatus[] status = multiStatus.getChildren();
        int i = 0;
        while (i < status.length) {
            if (!status[i].isOK()) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.statusErrorList.add(status[i]);
                filteredFiles.add(files[i].getFullPath());
            }
            ++i;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return filteredFiles;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.statusErrorList.size()];
        this.statusErrorList.toArray(errors);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return new MultiStatus("org.eclipse.ui", 0, errors, Messages.SCA_IMPORTING_OPEARATION_PROBLEMS_OCCURED_ERROR_MESSAGE, null);
    }

    void importFile(Object fileObject, int policy) {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(fileObject);
        }
        catch (CoreException e) {
            Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
            IStatus coreStatus = e.getStatus();
            String newMessage = NLS.bind((String)Messages.SCA_IMPORT_OPERATION_CORE_ERROR_MESSAGE, (Object)fileObject, (Object)coreStatus.getMessage());
            Status status = new Status(coreStatus.getSeverity(), coreStatus.getPlugin(), coreStatus.getCode(), newMessage, null);
            this.statusErrorList.add((IStatus)status);
            return;
        }
        String fileObjectPath = this.provider.getFullPath(fileObject);
        this.progressMonitor.subTask(fileObjectPath);
        IFile targetResource = containerResource.getFile((IPath)new Path(this.provider.getLabel(fileObject)));
        this.progressMonitor.worked(1);
        if (this.rejectedFilesList.contains(targetResource.getFullPath())) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return;
        }
        IPath targetPath = targetResource.getLocation();
        if (targetPath != null && targetPath.toFile().equals(new File(fileObjectPath))) {
            this.statusErrorList.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)Messages.SCA_CANNOT_IMPORT_TARGET_UNTO_ITSELF_ERROR_MESSAGE, (Object)fileObjectPath), null));
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return;
        }
        InputStream contentStream = this.provider.getContents(fileObject);
        if (contentStream == null) {
            this.statusErrorList.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)Messages.SCA_IMPORTING_OPERATION_CANNOT_OPEN_STREAM_ERROR_MESSAGE, (Object)fileObjectPath), null));
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return;
        }
        try {
            try {
                if (targetResource.exists()) {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    targetResource.setContents(contentStream, 2, null);
                } else {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    targetResource.create(contentStream, false, null);
                }
                this.setResourceAttributes(targetResource, fileObject);
            }
            catch (CoreException e) {
                Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
                this.statusErrorList.add(e.getStatus());
                try {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    contentStream.close();
                }
                catch (IOException e2) {
                    Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e2);
                    this.statusErrorList.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)Messages.SCA_IMPORTING_OPERATION_CANNOT_CLOSE_STREAM_ERROR_MESSAGE, (Object)fileObjectPath), (Throwable)e2));
                }
            }
        }
        finally {
            try {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                contentStream.close();
            }
            catch (IOException e) {
                Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
                this.statusErrorList.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)Messages.SCA_IMPORTING_OPERATION_CANNOT_CLOSE_STREAM_ERROR_MESSAGE, (Object)fileObjectPath), (Throwable)e));
            }
        }
    }

    private void setResourceAttributes(IFile targetResource, Object fileObject) {
        if (fileObject instanceof File) {
            try {
                targetResource.setResourceAttributes(ResourceAttributes.fromFile((File)((File)fileObject)));
            }
            catch (CoreException e) {
                Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
            }
        }
    }

    void importFileSystemObjects(List<Object> filesToImportList) {
        for (Object fileSystemObject : filesToImportList) {
            if (this.source == null) {
                IPath sourcePath = new Path(this.provider.getFullPath(fileSystemObject)).removeLastSegments(1);
                if (this.provider.isFolder(fileSystemObject) && sourcePath.isEmpty()) {
                    Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                    this.statusErrorList.add((IStatus)new Status(1, "org.eclipse.ui", 0, Messages.SCA_IMPORTING_OPERATION_CANNOT_COPY_ERROR_MESSAGE, null));
                    continue;
                }
                this.source = sourcePath.toFile();
            }
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            this.importRecursivelyFrom(fileSystemObject, 0);
        }
    }

    int importFolder(Object folderObject, int policy) {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(folderObject);
        }
        catch (CoreException e) {
            Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
            this.statusErrorList.add(e.getStatus());
            return policy;
        }
        if (containerResource == null) {
            return policy;
        }
        this.progressMonitor.subTask(this.provider.getFullPath(folderObject));
        IWorkspace workspace = this.destinationContainer.getWorkspace();
        IPath containerPath = containerResource.getFullPath();
        IPath resourcePath = containerPath.append(this.provider.getLabel(folderObject));
        if (resourcePath.equals((Object)containerPath)) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return policy;
        }
        if (workspace.getRoot().exists(resourcePath)) {
            if (this.rejectedFilesList.contains(resourcePath)) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return 1;
            }
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return 2;
        }
        try {
            workspace.getRoot().getFolder(resourcePath).create(false, true, null);
        }
        catch (CoreException e) {
            Logger.println((int)0, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message", (Throwable)e);
            this.statusErrorList.add(e.getStatus());
        }
        return policy;
    }

    void importRecursivelyFrom(Object fileSystemObject, int policy) {
        if (this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.provider.isFolder(fileSystemObject)) {
            this.importFile(fileSystemObject, policy);
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return;
        }
        int childPolicy = this.importFolder(fileSystemObject, policy);
        if (childPolicy != 1) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            Iterator iterator = this.provider.getChildren(fileSystemObject).iterator();
            while (iterator.hasNext()) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.importRecursivelyFrom(iterator.next(), childPolicy);
            }
        }
    }

    boolean queryOverwrite(IPath resourcePath) throws OperationCanceledException {
        String overwriteAnswer = this.overwriteQuery.queryOverwrite(resourcePath.makeRelative().toString());
        if (overwriteAnswer.equals("CANCEL")) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            throw new OperationCanceledException(Messages.SCA_DUMMY_EMPTY_STRING);
        }
        if (overwriteAnswer.equals("NO")) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return false;
        }
        if (overwriteAnswer.equals("NOALL")) {
            this.overwriteState = 1;
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return false;
        }
        if (overwriteAnswer.equals("ALL")) {
            this.overwriteState = 2;
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return true;
    }

    boolean queryOverwriteFile(IFile targetFile, int policy) {
        if (policy != 2) {
            if (this.overwriteState == 0 && !this.queryOverwrite(targetFile.getFullPath())) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return false;
            }
            if (this.overwriteState == 1) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return false;
            }
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return true;
    }

    public void setContext(Shell shell) {
        this.shell = shell;
    }

    public void setCreateContainerStructure(boolean value) {
        this.isCreateContainerStructure = value;
    }

    public void setFilesToImport(List<Object> filesToImport) {
        this.selectedFilesList = filesToImport;
    }

    public void setOverwriteResources(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }

    ArrayList<Object> validateEdit(List<?> existingFiles) {
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        if (existingFiles.size() > 0) {
            IFile[] files = existingFiles.toArray(new IFile[existingFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.shell);
            if (status.isMultiStatus()) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return this.getRejectedFiles(status, files);
            }
            if (!status.isOK()) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.statusErrorList.add(status);
                ArrayList<Object> filteredFiles = new ArrayList<Object>();
                int i = 0;
                while (i < files.length) {
                    filteredFiles.add(files[i].getFullPath());
                    ++i;
                }
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return filteredFiles;
            }
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return new ArrayList<Object>();
    }

    void validateFiles(List<Object> sourceFilesList) {
        ArrayList<Object> noOverwriteList = new ArrayList<Object>();
        ArrayList<IFile> overwriteReadonlyList = new ArrayList<IFile>();
        this.collectExistingReadonlyFiles(this.destinationPath, sourceFilesList, noOverwriteList, overwriteReadonlyList, 0);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        this.rejectedFilesList = this.validateEdit(overwriteReadonlyList);
        this.rejectedFilesList.addAll(noOverwriteList);
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
    }

    public static IPath getJavaBinariesPath(IResource projectToImportTo) {
        if (projectToImportTo.getType() == 4) {
            try {
                return JavaCore.create((IProject)projectToImportTo.getProject()).getOutputLocation();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static IPath getJavaSourcesPathSegment(IResource projectToImportTo) {
        if (projectToImportTo.getType() == 4) {
            try {
                IPackageFragment[] packageFragments = JavaCore.create((IProject)projectToImportTo.getProject()).getPackageFragments();
                if (packageFragments != null && packageFragments.length > 0) {
                    int i = 0;
                    while (i < packageFragments.length) {
                        String extension = packageFragments[i].getPath().getFileExtension();
                        if (extension == null || !extension.equals("")) {
                            return packageFragments[i].getPath();
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

