/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor.extension;

import com.ibm.ccl.sca.ui.contribution.editor.IImportExportEditHelper;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ImportEditHelper
implements IImportExportEditHelper {
    private ImportExportWrapper wrapper;
    private Text namespace;
    private Button okButton;

    @Override
    public void setData(ImportExportWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void createControls(Composite composite) {
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.ui");
        NamespaceImport namespaceImport = (NamespaceImport)this.wrapper.getData();
        this.namespace = utils.createText(composite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_NAMESPACE, null, null, 2048);
        if (namespaceImport.getNamespace() != null) {
            this.namespace.setText(namespaceImport.getNamespace());
        }
        this.namespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportEditHelper.this.updateButtonStatus();
            }
        });
    }

    private void updateButtonStatus() {
        if (this.namespace.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    @Override
    public void setOKButton(Button button) {
        this.okButton = button;
        this.updateButtonStatus();
    }

    @Override
    public void updateData() {
        NamespaceImport namespaceImport = (NamespaceImport)this.wrapper.getData();
        namespaceImport.setNamespace(this.namespace.getText());
    }
}

