/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor.extension;

import com.ibm.ccl.sca.ui.contribution.editor.IImportExportEditHelper;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.apache.tuscany.sca.contribution.namespace.NamespaceExport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ExportEditHelper
implements IImportExportEditHelper {
    private ImportExportWrapper wrapper;
    private Text namespace;
    private Button okButton;

    @Override
    public void setData(ImportExportWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void createControls(Composite composite) {
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.ui");
        NamespaceExport namespaceExport = (NamespaceExport)this.wrapper.getData();
        this.namespace = utils.createText(composite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_NAMESPACE, null, null, 2048);
        if (namespaceExport.getNamespace() != null) {
            this.namespace.setText(namespaceExport.getNamespace());
        }
        this.namespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportEditHelper.this.updateButtonStatus();
            }
        });
    }

    private void updateButtonStatus() {
        if (this.namespace.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    @Override
    public void setOKButton(Button button) {
        this.okButton = button;
        this.updateButtonStatus();
    }

    @Override
    public void updateData() {
        NamespaceExport namespaceExport = (NamespaceExport)this.wrapper.getData();
        namespaceExport.setNamespace(this.namespace.getText());
    }
}

