/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor;

import com.ibm.ccl.sca.ui.contribution.editor.IImportExportContentProviderDelegate;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportEditHelper;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportLabelProviderDelegate;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportObjectFactory;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ContributionEditorExtension
implements Comparable<ContributionEditorExtension> {
    private static final String TAGNAME_ATTR = "tagName";
    private static final String ICON_ATTR = "icon";
    private static final String FACTORY_ATTR = "factory";
    private static final String CONTENT_ATTR = "contentProvider";
    private static final String LABEL_ATTR = "labelProvider";
    private static final String EDITHELPER_ATTR = "editHelper";
    private IConfigurationElement config;
    private boolean isImport;
    private String contributorId = null;
    private String iconPath = null;
    private IImportExportObjectFactory factory = null;
    private IImportExportContentProviderDelegate contentProvider = null;
    private IImportExportLabelProviderDelegate labelProvider = null;

    public ContributionEditorExtension(IConfigurationElement config, boolean isImport) {
        this.config = config;
        this.isImport = isImport;
        this.contributorId = config.getContributor().getName();
        this.iconPath = config.getAttribute(ICON_ATTR);
    }

    public String getTagName() {
        return this.config.getAttribute(TAGNAME_ATTR);
    }

    public Image getImage() {
        if (this.iconPath == null) {
            return null;
        }
        String key = String.valueOf(this.iconPath) + "_" + this.contributorId;
        Image image = SCAToolsUIPlugin.getDefault().getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor descriptor = SCAToolsUIPlugin.imageDescriptorFromPlugin((String)this.contributorId, (String)this.iconPath);
            SCAToolsUIPlugin.getDefault().getImageRegistry().put(key, descriptor);
            image = SCAToolsUIPlugin.getDefault().getImageRegistry().get(key);
        }
        return image;
    }

    public IImportExportObjectFactory getObjectFactory() {
        if (this.factory == null) {
            try {
                this.factory = (IImportExportObjectFactory)this.config.createExecutableExtension(FACTORY_ATTR);
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return this.factory;
    }

    public IImportExportContentProviderDelegate getContentProvider() {
        if (this.contentProvider == null) {
            try {
                this.contentProvider = (IImportExportContentProviderDelegate)this.config.createExecutableExtension(CONTENT_ATTR);
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return this.contentProvider;
    }

    public IImportExportLabelProviderDelegate getLabelProvider() {
        if (this.labelProvider == null) {
            try {
                this.labelProvider = (IImportExportLabelProviderDelegate)this.config.createExecutableExtension(LABEL_ATTR);
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return this.labelProvider;
    }

    public IImportExportEditHelper getEditHelper() {
        try {
            return (IImportExportEditHelper)this.config.createExecutableExtension(EDITHELPER_ATTR);
        }
        catch (CoreException e) {
            SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    public boolean isImport() {
        return this.isImport;
    }

    @Override
    public int compareTo(ContributionEditorExtension o) {
        return this.getTagName().compareTo(o.getTagName());
    }
}

