/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtension;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtensionRegistry;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorHelper;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ImportExportSection;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.part.EditorPart;

public class ContributionEditor
extends EditorPart {
    private String INFOPOP_CONTRIBUTION_EDITOR = "CONTRIBUTION_EDITOR";
    private static final String SCA_CONTRIBUTION_GENERATED_XML = "sca-contribution-generated.xml";
    private static final String SCA_CONTRIBUTION_XML = "sca-contribution.xml";
    private static final String COMPOSITE = "COMPOSITE";
    private static final String COMPOSITE_ICON = "icons/composite_file.gif";
    private static final String COMPOSITE_READ_ONLY = "COMPOSITE_READ_ONLY";
    private static final String COMPOSITE_READ_ONLY_ICON = "icons/composite_file_readonly.gif";
    private static final String QNAME_MARKER_ID = "com.ibm.ccl.sca.core.UnresolvedQNameMarker";
    private static final String TARGETNAMESPACE_ATTR = "targetNamespace";
    private static final String LOCALNAME_ATTR = "localName";
    private static final String WARNING_ICON = "icons/warning_co.gif";
    private static final String ERROR_ICON = "icons/error_co.gif";
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;
    private IFile contribFile = null;
    private Contribution contrib = null;
    private Contribution readOnlyContribution = null;
    private List<org.apache.tuscany.sca.assembly.Composite> readOnlyComposites = null;
    private List<org.apache.tuscany.sca.assembly.Composite> allComposites = null;
    private Map<String, Editable> compositeAttributes = null;
    private Map<String, ContributionEditorExtension> extensions = null;
    private List<ImportExportWrapper> allImports = null;
    private List<ImportExportWrapper> allExports = null;
    private ImportExportSection importSection = null;
    private ImportExportSection exportSection = null;
    private boolean isDirty = false;
    private Object[] currentSelections = null;
    private TreeViewer compositeTree = null;
    private CompositeProvider compositeTreeContent = new CompositeProvider();
    private Button removeButton = null;
    private Button selectButton = null;
    private Button collapseAll = null;
    private Button expandAll = null;
    private static ImageRegistry imageRegistry = SCAToolsUIPlugin.getDefault().getImageRegistry();
    private String loadError = null;
    private IProject enclosingProject;
    private IFile inputFile_;
    IResourceChangeListener listener_;

    static {
        imageRegistry.put(COMPOSITE, SCAToolsUIPlugin.getImageDescriptor(COMPOSITE_ICON));
        imageRegistry.put(COMPOSITE_READ_ONLY, SCAToolsUIPlugin.getImageDescriptor(COMPOSITE_READ_ONLY_ICON));
    }

    public ContributionEditor() {
        this.compositeAttributes = new HashMap<String, Editable>();
        this.allComposites = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        this.extensions = ContributionEditorExtensionRegistry.INSTANCE.getExtensions();
        this.allImports = new ArrayList<ImportExportWrapper>();
        this.allExports = new ArrayList<ImportExportWrapper>();
    }

    private <T> void extractImportExports(List<T> addToList, List<ImportExportWrapper> list, Class<T> clz) {
        for (ImportExportWrapper wrapper : list) {
            if (wrapper.isGenerated()) continue;
            Object obj = wrapper.getData();
            addToList.add(clz.cast(obj));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        ArrayList<org.apache.tuscany.sca.assembly.Composite> compositesToWrite = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        compositesToWrite.addAll(this.allComposites);
        if (this.readOnlyComposites != null) {
            compositesToWrite.removeAll(this.readOnlyComposites);
        }
        if (this.contrib == null && this.allComposites.isEmpty()) {
            this.isDirty = false;
            this.firePropertyChange(257);
            return;
        }
        TuscanyModelHelper modelHelper = TuscanyModelHelper.getInstance();
        this.contrib = modelHelper.createContribution();
        this.contrib.getDeployables().addAll(compositesToWrite);
        this.extractImportExports(this.contrib.getImports(), this.importSection.getData(), Import.class);
        this.extractImportExports(this.contrib.getExports(), this.exportSection.getData(), Export.class);
        IStatus status = modelHelper.writeContributionToFile(this.contribFile, this.contrib);
        SCAToolsUIPlugin.getDefault().getLog().log(status);
        if (status.equals(Status.OK_STATUS)) {
            this.loadError = null;
            this.checkSelection();
            this.isDirty = false;
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(Messages.bind((String)Messages.ERROR_NOT_A_FILE, (Object)input.getName()));
        }
        TuscanyModelHelper helper = TuscanyModelHelper.getInstance();
        this.inputFile_ = ((IFileEditorInput)input).getFile();
        String inputFileName = this.inputFile_.getName();
        String projectName = this.inputFile_.getProject().getName();
        this.setPartName(Messages.bind((String)Messages.ContributionEditor_0, (Object)projectName));
        if (!inputFileName.equalsIgnoreCase(SCA_CONTRIBUTION_XML) && !inputFileName.equalsIgnoreCase(SCA_CONTRIBUTION_GENERATED_XML)) {
            throw new PartInitException(Messages.bind((String)Messages.ContributionEditor_ERROR_CONTRIB_EDITOR_INPUT_NOT_A_CONTRIBUTION_FILE, (Object)input.getName()));
        }
        IContainer parentContainer = this.inputFile_.getParent();
        IFolder outputFolder = null;
        if (parentContainer instanceof IFolder) {
            outputFolder = (IFolder)parentContainer;
        }
        if (outputFolder == null || !outputFolder.getName().equalsIgnoreCase("META-INF") || !(outputFolder.getParent() instanceof IProject)) {
            throw new PartInitException(Messages.bind((String)Messages.ContributionEditor_ERROR_CONTRIB_EDITOR_CONTRIBUTION_FILE_WRONG_LOCATION, (Object)input.getName()));
        }
        IFile readOnlyContribFile = null;
        if (inputFileName.equalsIgnoreCase(SCA_CONTRIBUTION_XML)) {
            this.contribFile = this.inputFile_;
            readOnlyContribFile = outputFolder.getFile(SCA_CONTRIBUTION_GENERATED_XML);
        }
        if (inputFileName.equalsIgnoreCase(SCA_CONTRIBUTION_GENERATED_XML)) {
            this.contribFile = outputFolder.getFile(SCA_CONTRIBUTION_XML);
            readOnlyContribFile = this.inputFile_;
        }
        if (readOnlyContribFile != null && readOnlyContribFile.exists()) {
            try {
                this.enclosingProject = readOnlyContribFile.getProject();
                this.readOnlyContribution = helper.loadContribution(readOnlyContribFile);
                this.readOnlyComposites = this.readOnlyContribution.getDeployables();
                this.populateImportExports(this.allImports, this.readOnlyContribution.getImports(), true);
                this.populateImportExports(this.allExports, this.readOnlyContribution.getExports(), true);
            }
            catch (Exception e) {
                this.loadError = e.getMessage();
            }
        }
        if (this.contribFile != null && this.contribFile.exists()) {
            try {
                this.enclosingProject = this.contribFile.getProject();
                this.contrib = helper.loadContribution(this.contribFile);
                this.allComposites = this.contrib.getDeployables();
                this.populateImportExports(this.allImports, this.contrib.getImports(), false);
                this.populateImportExports(this.allExports, this.contrib.getExports(), false);
            }
            catch (Exception e) {
                this.loadError = e.getMessage();
            }
        }
        if (this.allComposites == null) {
            this.allComposites = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        }
        for (org.apache.tuscany.sca.assembly.Composite composite : this.allComposites) {
            this.compositeAttributes.put(composite.getName().toString(), Editable.EDITABLE);
        }
        if (this.readOnlyComposites != null) {
            this.allComposites.addAll(this.readOnlyComposites);
            for (org.apache.tuscany.sca.assembly.Composite composite : this.readOnlyComposites) {
                this.compositeAttributes.put(composite.getName().toString(), Editable.READ_ONLY);
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.listener_ = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource resource = event.getResource();
                switch (event.getType()) {
                    case 2: {
                        if (resource == null) {
                            return;
                        }
                        if (resource.getType() != 4 || !resource.getName().equals(ContributionEditor.this.getEnclosingProject().getName())) break;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ContributionEditor.this.close(true);
                            }
                        });
                        break;
                    }
                    case 4: {
                        if (resource == null) {
                            return;
                        }
                        if (resource.getType() != 4 || !resource.getName().equals(ContributionEditor.this.getEnclosingProject().getName())) break;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ContributionEditor.this.close(false);
                            }
                        });
                        break;
                    }
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        IResourceDelta resourceDelta = delta.findMember(ContributionEditor.this.inputFile_.getFullPath());
                        if (resourceDelta == null || resourceDelta.getKind() != 2) break;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ContributionEditor.this.close(false);
                            }
                        });
                    }
                }
            }
        };
        this.inputFile_.getWorkspace().addResourceChangeListener(this.listener_, 7);
    }

    private void populateImportExports(List<ImportExportWrapper> addToList, List<?> importExports, boolean generated) {
        for (Object element : importExports) {
            String className = element.getClass().getName();
            ContributionEditorExtension extension = this.extensions.get(className);
            Object clone = extension == null ? element : extension.getObjectFactory().cloneObject(element);
            ImportExportWrapper wrapper = new ImportExportWrapper(className, clone);
            wrapper.setGenerated(generated);
            addToList.add(wrapper);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.form, "com.ibm.ccl.sca.ui." + this.INFOPOP_CONTRIBUTION_EDITOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        SashForm sash = new SashForm(this.form.getBody(), 0);
        sash.setLayout((Layout)new FillLayout());
        sash.setLayoutData((Object)new GridData(1808));
        this.toolkit.adapt((Composite)sash);
        Composite left = this.toolkit.createComposite((Composite)sash);
        left.setLayout((Layout)new GridLayout());
        left.setLayoutData((Object)new GridData(1808));
        this.createDeployableCompositeSection(left);
        Composite right = this.toolkit.createComposite((Composite)sash);
        right.setLayout((Layout)new GridLayout());
        right.setLayoutData((Object)new GridData(1808));
        SashForm rightSash = new SashForm(right, 512);
        rightSash.setLayout((Layout)new FillLayout());
        rightSash.setLayoutData((Object)new GridData(1808));
        this.toolkit.adapt((Composite)rightSash);
        this.importSection = new ImportExportSection(this.toolkit, this, true);
        this.importSection.createPartControl((Composite)rightSash);
        this.importSection.setData(this.allImports);
        this.exportSection = new ImportExportSection(this.toolkit, this, false);
        this.exportSection.createPartControl((Composite)rightSash);
        this.exportSection.setData(this.allExports);
        if (this.loadError != null) {
            this.form.setMessage(Messages.bind((String)Messages.ERROR_CONTRIB_EDITOR_LOAD, (Object)this.loadError), 3);
        }
    }

    public void setMessage(String message, int type) {
        if (this.loadError == null) {
            this.form.setMessage(message, type);
        }
    }

    private void createDeployableCompositeSection(Composite parent) {
        Section section = ContributionEditorHelper.createSection(this.toolkit, parent, Messages.LABEL_CONTRIB_EDITOR_DEPLOYABLE_COMPOSITES);
        this.compositeTree = ContributionEditorHelper.createTreeViewer(this.toolkit, section);
        this.compositeTree.setContentProvider((IContentProvider)this.compositeTreeContent);
        this.compositeTree.setLabelProvider((IBaseLabelProvider)new DecoratorLabelProvider());
        SelectionListener listener = new SelectionListener();
        this.compositeTree.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.compositeTree.getTree().addFocusListener((FocusListener)listener);
        this.compositeTree.setInput(this.allComposites);
        Composite buttonComposite = ContributionEditorHelper.createButtonComposite(this.toolkit, this.compositeTree);
        this.selectButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_SELECT_COMPOSITES, 8);
        this.removeButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_REMOVE_COMPOSITES, 8);
        this.expandAll = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_EXPAND_BUTTON, 8);
        this.collapseAll = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_COLLAPSE_BUTTON, 8);
        this.selectButton.setLayoutData((Object)new GridData(258));
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.expandAll.setLayoutData((Object)new GridData(258));
        this.collapseAll.setLayoutData((Object)new GridData(258));
        this.selectButton.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell topShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithCheckedTree(topShell);
                selectDialog.setCurrentResource((IResource)ContributionEditor.this.inputFile_);
                selectDialog.initialize();
                ArrayList<QName> qnamesToIgnore = new ArrayList<QName>();
                for (org.apache.tuscany.sca.assembly.Composite composite : ContributionEditor.this.allComposites) {
                    qnamesToIgnore.add(composite.getName());
                }
                selectDialog.setIgnoredQNames(qnamesToIgnore);
                if (selectDialog.open() == 0) {
                    ContributionEditor.this.addToTree(selectDialog.getSelectedComposites());
                }
                ContributionEditor.this.enableButtons();
            }
        });
        this.removeButton.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionEditor.this.removeSelectionFromTree(ContributionEditor.this.currentSelections);
                ContributionEditor.this.enableButtons();
            }
        });
        this.expandAll.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionEditor.this.compositeTree.expandAll();
            }
        });
        this.collapseAll.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionEditor.this.compositeTree.collapseAll();
            }
        });
        this.enableButtons();
    }

    private void enableButtons() {
        if (this.allComposites.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.expandAll.setEnabled(false);
            this.collapseAll.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.expandAll.setEnabled(true);
            this.collapseAll.setEnabled(true);
        }
    }

    private void handleReadOnly(Object obj) {
        this.removeButton.setEnabled(false);
        this.setMessage(Messages.WARNING_SELECTED_ITEM_READ_ONLY, 2);
    }

    private void restoreToEditable() {
        if (!this.allComposites.isEmpty()) {
            this.removeButton.setEnabled(true);
        }
        this.setMessage(null, 0);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void addToTree(List<ISCAComposite> composites) {
        if (composites == null || composites.isEmpty()) {
            return;
        }
        ArrayList<org.apache.tuscany.sca.assembly.Composite> compositeModels = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        for (ISCAComposite iSCAComposite : composites) {
            try {
                if (this.allComposites.contains(iSCAComposite.getModelObject())) continue;
                compositeModels.add((org.apache.tuscany.sca.assembly.Composite)iSCAComposite.getModelObject());
            }
            catch (CoreException coreException) {}
        }
        this.allComposites.addAll(compositeModels);
        for (org.apache.tuscany.sca.assembly.Composite composite : compositeModels) {
            this.compositeAttributes.put(composite.getName().toString(), Editable.EDITABLE);
        }
        this.compositeTreeContent.add(compositeModels);
        if (!compositeModels.isEmpty()) {
            this.isDirty = true;
            this.firePropertyChange(257);
        }
    }

    private void removeSelectionFromTree(Object[] selections) {
        if (selections == null || selections.length == 0) {
            return;
        }
        ArrayList<org.apache.tuscany.sca.assembly.Composite> compositesToRemove = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        Object[] objectArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof NamespaceNode) {
                NamespaceNode nsNode = (NamespaceNode)item;
                Object[] objectArray2 = nsNode.getChildren();
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object child = objectArray2[n4];
                    if (child instanceof org.apache.tuscany.sca.assembly.Composite) {
                        compositesToRemove.add((org.apache.tuscany.sca.assembly.Composite)child);
                        this.isDirty = true;
                    }
                    ++n4;
                }
                this.compositeTreeContent.removeNamespaceNode((NamespaceNode)item);
            }
            if (item instanceof org.apache.tuscany.sca.assembly.Composite) {
                compositesToRemove.add((org.apache.tuscany.sca.assembly.Composite)item);
                this.isDirty = true;
            }
            ++n2;
        }
        this.compositeTreeContent.remove(compositesToRemove);
        this.allComposites.removeAll(compositesToRemove);
        if (this.isDirty) {
            this.firePropertyChange(257);
        }
    }

    private boolean isReadOnly(org.apache.tuscany.sca.assembly.Composite composite) {
        Editable attribute = this.compositeAttributes.get(composite.getName().toString());
        if (attribute == null) {
            return true;
        }
        return attribute.equals((Object)Editable.READ_ONLY);
    }

    private boolean isReadOnly(NamespaceNode nsNode) {
        if (nsNode == null) {
            return true;
        }
        Object[] objectArray = nsNode.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.apache.tuscany.sca.assembly.Composite composite;
            Object child = objectArray[n2];
            if (child instanceof org.apache.tuscany.sca.assembly.Composite && this.isReadOnly(composite = (org.apache.tuscany.sca.assembly.Composite)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IMarker findMatchingMarker(org.apache.tuscany.sca.assembly.Composite composite) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.contribFile.findMarkers(QNAME_MARKER_ID, false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String targetNamespace = (String)marker.getAttribute(TARGETNAMESPACE_ATTR);
                String localName = (String)marker.getAttribute(LOCALNAME_ATTR);
                if (composite.getName().getNamespaceURI().equals(targetNamespace) && composite.getName().getLocalPart().equals(localName)) {
                    return marker;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private Image getDecoratedImage(Image base, int severity) {
        String key = severity == 2 ? ERROR_ICON : WARNING_ICON;
        Image image = imageRegistry.get(key);
        if (image == null) {
            DecorationOverlayIcon desc = new DecorationOverlayIcon(base, SCAToolsUIPlugin.getImageDescriptor(key), 2);
            imageRegistry.put(key, (ImageDescriptor)desc);
            image = imageRegistry.get(key);
        }
        return image;
    }

    private Image processImage(Image base, org.apache.tuscany.sca.assembly.Composite composite) {
        IMarker marker = this.findMatchingMarker(composite);
        if (marker != null) {
            int severity = marker.getAttribute("severity", 1);
            return this.getDecoratedImage(base, severity);
        }
        return base;
    }

    private void checkSelection() {
        boolean isReadOnly = false;
        IMarker marker = null;
        if (this.currentSelections != null) {
            Object[] objectArray = this.currentSelections;
            int n = this.currentSelections.length;
            int n2 = 0;
            while (n2 < n) {
                NamespaceNode nsNode;
                Object item = objectArray[n2];
                if (item instanceof org.apache.tuscany.sca.assembly.Composite) {
                    org.apache.tuscany.sca.assembly.Composite composite = (org.apache.tuscany.sca.assembly.Composite)item;
                    if (this.isReadOnly(composite)) {
                        isReadOnly = true;
                        this.handleReadOnly(composite);
                    } else if (this.currentSelections.length == 1) {
                        marker = this.findMatchingMarker(composite);
                    }
                }
                if (item instanceof NamespaceNode && this.isReadOnly(nsNode = (NamespaceNode)item)) {
                    isReadOnly = true;
                    this.handleReadOnly(nsNode);
                }
                ++n2;
            }
        }
        if (marker != null) {
            this.removeButton.setEnabled(true);
            try {
                String message = (String)marker.getAttribute("message");
                int severity = marker.getAttribute("severity", 1);
                int msgsev = severity == 2 ? 3 : 2;
                this.setMessage(message, msgsev);
            }
            catch (CoreException coreException) {
                this.setMessage(null, 0);
            }
        } else if (!isReadOnly) {
            this.restoreToEditable();
        }
    }

    void setDirty() {
        if (!this.isDirty) {
            this.isDirty = true;
            this.firePropertyChange(257);
        }
    }

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        this.inputFile_.getWorkspace().removeResourceChangeListener(this.listener_);
        super.dispose();
    }

    public IProject getEnclosingProject() {
        return this.enclosingProject;
    }

    public void close(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    private class CompositeProvider
    extends WorkbenchContentProvider {
        private Map<String, NamespaceNode> namespaceNodes = new Hashtable<String, NamespaceNode>();

        private CompositeProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.namespaceNodes.clear();
                for (Object item : (List)newInput) {
                    org.apache.tuscany.sca.assembly.Composite element;
                    QName qName;
                    if (!(item instanceof org.apache.tuscany.sca.assembly.Composite) || (qName = (element = (org.apache.tuscany.sca.assembly.Composite)item).getName()) == null) continue;
                    String namespace = qName.getNamespaceURI();
                    NamespaceNode namespaceNode = this.namespaceNodes.get(namespace);
                    if (namespaceNode == null) {
                        namespaceNode = new NamespaceNode(null, namespace);
                        this.namespaceNodes.put(namespace, namespaceNode);
                    }
                    namespaceNode.addChild(item);
                }
            }
        }

        public Object getParent(Object element) {
            QName name;
            if (element instanceof org.apache.tuscany.sca.assembly.Composite && (name = ((org.apache.tuscany.sca.assembly.Composite)element).getName()) != null) {
                return this.namespaceNodes.get(name.getNamespaceURI());
            }
            return super.getParent(element);
        }

        public Object[] getChildren(Object o) {
            if (o instanceof List) {
                return this.namespaceNodes.values().toArray();
            }
            if (o instanceof NamespaceNode) {
                return ((NamespaceNode)o).getChildren();
            }
            return new Object[0];
        }

        public void add(List<org.apache.tuscany.sca.assembly.Composite> composites) {
            HashSet<NamespaceNode> nsNodesToRefresh = new HashSet<NamespaceNode>();
            boolean needsToRefreshRoot = false;
            for (org.apache.tuscany.sca.assembly.Composite composite : composites) {
                QName qName = composite.getName();
                if (qName == null) continue;
                String namespace = qName.getNamespaceURI();
                NamespaceNode namespaceNode = this.namespaceNodes.get(namespace);
                if (namespaceNode == null) {
                    namespaceNode = new NamespaceNode(null, namespace);
                    this.namespaceNodes.put(namespace, namespaceNode);
                    needsToRefreshRoot = true;
                }
                namespaceNode.addChild(composite);
                nsNodesToRefresh.add(namespaceNode);
            }
            if (needsToRefreshRoot) {
                ContributionEditor.this.compositeTree.refresh();
            } else {
                for (NamespaceNode nsNode : nsNodesToRefresh) {
                    ContributionEditor.this.compositeTree.refresh((Object)nsNode);
                }
            }
        }

        public void removeNamespaceNode(NamespaceNode nsNode) {
            this.namespaceNodes.remove(nsNode.getNamespace());
            ContributionEditor.this.compositeTree.refresh();
        }

        public void remove(List<org.apache.tuscany.sca.assembly.Composite> composites) {
            HashSet<NamespaceNode> nsNodesToRefresh = new HashSet<NamespaceNode>();
            boolean needsToRefreshRoot = false;
            for (org.apache.tuscany.sca.assembly.Composite composite : composites) {
                String namespace;
                NamespaceNode namespaceNode;
                QName qName = composite.getName();
                if (qName == null || (namespaceNode = this.namespaceNodes.get(namespace = qName.getNamespaceURI())) == null) continue;
                namespaceNode.removeChild(composite);
                nsNodesToRefresh.add(namespaceNode);
                if (!namespaceNode.isEmpty()) continue;
                this.namespaceNodes.remove(namespaceNode.getNamespace());
                needsToRefreshRoot = true;
            }
            if (needsToRefreshRoot) {
                ContributionEditor.this.compositeTree.refresh();
            } else {
                for (NamespaceNode nsNode : nsNodesToRefresh) {
                    ContributionEditor.this.compositeTree.refresh((Object)nsNode);
                }
            }
        }
    }

    private class DecoratorLabelProvider
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        private DecoratorLabelProvider() {
        }

        public final Image getImage(Object element) {
            if (element instanceof org.apache.tuscany.sca.assembly.Composite) {
                org.apache.tuscany.sca.assembly.Composite cmp = (org.apache.tuscany.sca.assembly.Composite)element;
                if (ContributionEditor.this.isReadOnly(cmp)) {
                    return imageRegistry.get(ContributionEditor.COMPOSITE_READ_ONLY);
                }
                return ContributionEditor.this.processImage(imageRegistry.get(ContributionEditor.COMPOSITE), cmp);
            }
            if (element instanceof NamespaceNode) {
                return ((NamespaceNode)element).getImage();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object theElement = cell.getElement();
            StyledString styledString = this.getStyledText(theElement);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(theElement));
            super.update(cell);
        }

        public StyledString getStyledText(Object element) {
            String string = this.getText(element);
            return new StyledString(string);
        }

        public final String getText(Object treeItem) {
            String label = null;
            if (treeItem instanceof NamespaceNode) {
                label = ((NamespaceNode)treeItem).getText();
            } else if (treeItem instanceof org.apache.tuscany.sca.assembly.Composite) {
                org.apache.tuscany.sca.assembly.Composite element = (org.apache.tuscany.sca.assembly.Composite)treeItem;
                QName name = element.getName();
                if (name != null) {
                    label = name.getLocalPart();
                    if (label.length() == 0) {
                        label = Messages.LABEL_UNNAMED;
                    }
                } else {
                    label = Messages.LABEL_UNNAMED;
                }
            } else {
                label = treeItem.toString();
            }
            return label;
        }
    }

    private static enum Editable {
        READ_ONLY,
        EDITABLE;

    }

    private class SelectionListener
    extends FocusAdapter
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] oldSelections = ContributionEditor.this.currentSelections;
            if (event.getSelection() instanceof StructuredSelection) {
                ContributionEditor.this.currentSelections = ((StructuredSelection)event.getSelection()).toArray();
            }
            if (oldSelections != null && oldSelections.length > 0) {
                ContributionEditor.this.compositeTree.update(oldSelections, null);
            }
            if (ContributionEditor.this.currentSelections != null && ContributionEditor.this.currentSelections.length > 0) {
                ContributionEditor.this.compositeTree.update(ContributionEditor.this.currentSelections, null);
            }
            ContributionEditor.this.checkSelection();
        }

        public void focusGained(FocusEvent e) {
            ContributionEditor.this.checkSelection();
        }
    }
}

