/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.intents;

import com.ibm.ccl.sca.core.util.intents.IntentUtils;
import com.ibm.ccl.sca.core.util.intents.LockableQName;
import com.ibm.ccl.sca.internal.ui.common.controls.intents.IntentQNameLabelProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

public class IntentSelectionControl
extends Composite {
    private Text userDefinedIntentText;
    private Button usePredefinedIntents;
    private List<QName> selectedQNameList;
    private LockableQName[] intentsToShow;
    private TableViewer viewer;
    private Text description;

    public IntentSelectionControl(Composite parent, int style, List<QName> intentsToShow) {
        super(parent, style);
        this.intentsToShow = new LockableQName[intentsToShow.size()];
        IntentUtils.copyToLockableArray((LockableQName[])this.intentsToShow, intentsToShow, (int)0, (boolean)false);
    }

    public List<QName> getSelectedQNames() {
        return this.selectedQNameList;
    }

    public Control createControlArea() {
        GridData data = new GridData(1808);
        data.minimumWidth = 400;
        data.minimumHeight = 200;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayoutData(data);
        this.setLayout((Layout)layout);
        this.usePredefinedIntents = new Button((Composite)this, 16);
        this.usePredefinedIntents.setText(Messages.IntentSelectionControl_1);
        Label descriptionLabel = new Label((Composite)this, 0);
        descriptionLabel.setText(Messages.IntentSelectionControl_4);
        final Table table = new Table((Composite)this, 2050);
        this.viewer = new TableViewer(table);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 17;
        gd.heightHint = 30;
        gd.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gd);
        this.viewer.setLabelProvider((IBaseLabelProvider)new IntentQNameLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return IntentSelectionControl.this.intentsToShow;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List lockableQNames = ((IStructuredSelection)IntentSelectionControl.this.viewer.getSelection()).toList();
                if (lockableQNames.size() == 1) {
                    String intentName = ((LockableQName)lockableQNames.get(0)).getQname().getLocalPart();
                    IServicePolicy policy = IntentUtils.getPolicyFromName((String)intentName);
                    IntentSelectionControl.this.description.setText(policy.getDescriptor().getDescription());
                } else {
                    IntentSelectionControl.this.description.setText("");
                }
            }
        });
        this.viewer.setInput((Object)this.intentsToShow);
        this.description = new Text((Composite)this, 2632);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.description.setLayoutData((Object)gd);
        Button useUserDefinedIntent = new Button((Composite)this, 16);
        useUserDefinedIntent.setText(Messages.IntentSelectionControl_2);
        new Label((Composite)this, 0);
        this.userDefinedIntentText = new Text((Composite)this, 2052);
        data = new GridData(768);
        data.horizontalIndent = 17;
        data.widthHint = 100;
        this.userDefinedIntentText.setLayoutData((Object)data);
        new Label((Composite)this, 0);
        Text hintText = new Text((Composite)this, 8);
        hintText.setText(Messages.IntentSelectionControl_3);
        data = new GridData(768);
        data.horizontalIndent = 17;
        data.horizontalSpan = 2;
        hintText.setLayoutData((Object)data);
        hintText.setBackground(this.getBackground());
        new Label((Composite)this, 0);
        this.usePredefinedIntents.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IntentSelectionControl.this.handleRadioSelection(table, IntentSelectionControl.this.usePredefinedIntents.getSelection());
            }
        });
        this.usePredefinedIntents.setSelection(true);
        this.handleRadioSelection(table, true);
        return this;
    }

    private void handleRadioSelection(Table table, boolean isPredefined) {
        table.setEnabled(isPredefined);
        this.userDefinedIntentText.setEnabled(!isPredefined);
        if (!isPredefined) {
            this.description.setText("");
        }
    }

    public void saveCompositeValues() {
        if (this.usePredefinedIntents.getSelection()) {
            List lockableQNames = ((IStructuredSelection)this.viewer.getSelection()).toList();
            this.selectedQNameList = IntentUtils.convertLockableToQName((List)lockableQNames);
        } else {
            String userIntent = this.userDefinedIntentText.getText();
            if (userIntent.equals("")) {
                this.selectedQNameList = new ArrayList<QName>();
            } else {
                ArrayList<String> intentList = new ArrayList<String>(1);
                intentList.add(userIntent);
                this.selectedQNameList = IntentUtils.convertToQName(intentList);
            }
        }
    }
}

