/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.internal.ui.common.controls.BaseSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.ISelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.SelectionControlWithText;
import com.ibm.ccl.sca.internal.ui.common.controls.ValidateSelectedContentProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectionDialog
extends Dialog {
    private ValidateSelectedContentProvider treeContentProvider;
    private IBaseLabelProvider treeLabelProvider;
    private ISelectionControl control;
    private Object root;
    private String title;
    private Object selection;
    private boolean showUserDefinedField;
    private boolean deferedOkButtonState = false;
    private boolean deferedOkButtonValue;

    public SelectionDialog(Shell parentShell, String title, boolean showUserDefinedField) {
        super(parentShell);
        this.title = title;
        this.showUserDefinedField = showUserDefinedField;
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        this.control = this.showUserDefinedField ? new SelectionControlWithText(parent, 0, Messages.SelectionDialog_8, Messages.SelectionDialog_9) : new BaseSelectionControl(parent, 0);
        this.control.setContentProvider(this.treeContentProvider);
        this.control.setLabelProvider(this.treeLabelProvider);
        this.control.setRoot(this.root);
        this.control.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Button okButton = SelectionDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(((Boolean)evt.data).booleanValue());
                } else {
                    SelectionDialog.this.deferedOkButtonState = true;
                    SelectionDialog.this.deferedOkButtonValue = (Boolean)evt.data;
                }
            }
        });
        Composite controlComposite = this.control.createControls();
        return controlComposite;
    }

    protected Control createContents(Composite parent) {
        Control createdComposite = super.createContents(parent);
        if (this.deferedOkButtonState) {
            Button okButton = this.getButton(0);
            okButton.setEnabled(this.deferedOkButtonValue);
        }
        return createdComposite;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void okPressed() {
        this.selection = this.control.getSelection();
        super.okPressed();
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.treeLabelProvider = labelProvider;
    }

    public void setContentProvider(ValidateSelectedContentProvider contentProvider) {
        this.treeContentProvider = contentProvider;
    }

    public void setRoot(Object root) {
        this.root = root;
    }
}

