/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.AbstractSelectionListener;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeCheckedTreeGroup;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeTreeGroup;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.IPackButtonAction;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CompositeSelectionControl
implements ICompositeSelectionControl {
    protected CompositeTreeGroup compositeResourceGroup;
    protected List<IProject> input = new ArrayList<IProject>();
    protected boolean isRootObjectSet = false;
    protected Object rootObject = null;
    protected boolean useHeightHint;
    protected UIUtils uiUtils = new UIUtils(null);
    protected Font font;
    protected Composite composite;
    protected List<Button> buttons = new ArrayList<Button>();
    protected Button selectButton = null;
    protected Button deselectButton = null;
    protected Button expandAllButton;
    protected Button collapseAllButton;
    protected IResource resource_;
    protected IProject project_;
    protected ViewerFilter currentFilter_;
    protected ViewerFilter workingSetFilter_;
    protected ViewerFilter enclosingProjectFilter_;
    protected Set<String> workingSetProjectNames_ = new HashSet<String>();
    protected Set<String> enclosingProjectPlusReferencedProjectNames = new HashSet<String>();
    protected IWorkingSet[] workingSets_;
    protected TreeViewer treeViewer_;
    protected Button workspaceRadio_;
    protected Button workingSetRadio_;
    protected ViewerFilter enclosingProjectPlusReferencesFilter_;
    protected Map<ICompositeSelectionControl.SCOPE, Boolean> scopes;
    protected Button enclosingProjectPlusReferencesRadio_;
    protected Button enclosingProjectRadio_;
    protected Object[] grayedElements_;
    protected Object[] checkedElements_;
    protected Object[] expandedElements_;
    private ArrayList<SelectionListener> searchScopeChangeListeners_;

    protected CompositeSelectionControl(Composite parent) {
        this.font = parent.getFont();
        this.useHeightHint = this.inRegularFontMode(parent);
        this.composite = parent;
        this.scopes = new HashMap<ICompositeSelectionControl.SCOPE, Boolean>();
        this.scopes.put(ICompositeSelectionControl.SCOPE.HIDE_ALL_SCOPE, false);
        this.scopes.put(ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT, true);
        this.scopes.put(ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT_PLUS_DEPENDENCIES, true);
        this.scopes.put(ICompositeSelectionControl.SCOPE.WORKINGSET, true);
        this.scopes.put(ICompositeSelectionControl.SCOPE.WORKSPACE, true);
        this.searchScopeChangeListeners_ = new ArrayList();
    }

    public void createCheckedTreeSelectionWidget() {
        this.compositeResourceGroup = new CompositeCheckedTreeGroup(this.composite, null, 2048, this.useHeightHint);
    }

    public void createSingleSelectTreeSelectionWidget() {
        this.compositeResourceGroup = new CompositeTreeGroup(this.composite, null, 2052, this.useHeightHint);
    }

    public void createMultiSelectTreeSelectionWidget() {
        this.compositeResourceGroup = new CompositeTreeGroup(this.composite, null, 2050, this.useHeightHint);
    }

    public List<Button> createNavigationControlButtonsGroup() {
        SelectionAdapter listener;
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setFont(this.font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        if (this.compositeResourceGroup instanceof CompositeCheckedTreeGroup) {
            this.selectButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_SELECT_ALL_ARTIFACTS_LABEL_TEXT, null, null);
            listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((CompositeCheckedTreeGroup)CompositeSelectionControl.this.compositeResourceGroup).setAllSelections(true);
                }
            };
            this.selectButton.addSelectionListener((SelectionListener)listener);
            this.selectButton.setFont(this.font);
            this.buttons.add(this.selectButton);
            this.deselectButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_UNSELECT_ALL_ARTIFACTS_LABEL_TEXT, null, null);
            listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((CompositeCheckedTreeGroup)CompositeSelectionControl.this.compositeResourceGroup).setAllSelections(false);
                }
            };
            this.deselectButton.addSelectionListener((SelectionListener)listener);
            this.deselectButton.setFont(this.font);
            this.buttons.add(this.deselectButton);
        }
        this.expandAllButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_EXPAND_ALL_BUTTON_TEXT, null, null);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeSelectionControl.this.compositeResourceGroup.expandAll();
            }
        };
        this.expandAllButton.addSelectionListener((SelectionListener)listener);
        this.expandAllButton.setFont(this.font);
        this.buttons.add(this.expandAllButton);
        this.collapseAllButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_COLLAPSE_ALL_BUTTON_TEXT, null, null);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeSelectionControl.this.compositeResourceGroup.collapseAll();
            }
        };
        this.collapseAllButton.addSelectionListener((SelectionListener)listener);
        this.collapseAllButton.setFont(this.font);
        this.buttons.add(this.collapseAllButton);
        return this.buttons;
    }

    private boolean inRegularFontMode(Composite parent) {
        int displayHeight = parent.getDisplay().getClientArea().height;
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeightDividedByFontHeight = displayHeight / fontHeight;
        return displayHeightDividedByFontHeight > 50;
    }

    @Override
    public void packButtons(IPackButtonAction pack) {
        for (Button b : this.buttons) {
            pack.pack(b);
        }
    }

    @Override
    public void addSelectionListener2SelectAll(AbstractSelectionListener addAction) {
        if (this.selectButton != null) {
            addAction.addMe2Button(this.selectButton);
        }
    }

    @Override
    public void addSelectionListener2DeselectAll(AbstractSelectionListener addAction) {
        if (this.deselectButton != null) {
            addAction.addMe2Button(this.deselectButton);
        }
    }

    @Override
    public List<ISCAComposite> getSelectedComposites() {
        return this.compositeResourceGroup.getSelectedComposites();
    }

    @Override
    public List<Object> getSelected() {
        return this.compositeResourceGroup.getSelected();
    }

    @Override
    public boolean isEmpty() {
        return this.compositeResourceGroup.getItemsCount() == 0;
    }

    @Override
    public void addListenerObject(Object listener) {
        this.compositeResourceGroup.addListener(listener);
    }

    @Override
    public void removeListenerObject(Object listener) {
        this.compositeResourceGroup.removeListener(listener);
    }

    @Override
    public void select(Object element) {
        this.compositeResourceGroup.initialSelection(element);
    }

    @Override
    public void initialize() {
        if (!this.isRootObjectSet) {
            ISCAProject[] scaprojects = null;
            try {
                scaprojects = SCAModelUtil.convertSCAProjectsListToArray((List)SCAModelUtil.getSCAProjectsList());
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            IProject[] projects = SCAModelUtil.convertSCAProjectsListToIProjectsWithCompositesArray((ISCAProject[])scaprojects);
            if (projects != null && projects.length != 0) {
                int projectSize = projects.length;
                int i = 0;
                while (i < projectSize) {
                    if (projects[i] != null && projects[i].isOpen()) {
                        this.input.add(projects[i]);
                    }
                    ++i;
                }
                this.rootObject = this.input;
            }
        }
        this.compositeResourceGroup.setRootObject(this.rootObject);
        this.compositeResourceGroup.initialize();
        this.treeViewer_ = this.compositeResourceGroup.getTreeViewer();
        this.createNavigationControlButtonsGroup();
        boolean hideAllScope = this.scopes.get((Object)ICompositeSelectionControl.SCOPE.HIDE_ALL_SCOPE);
        if (!hideAllScope) {
            this.createSearchScope();
        }
        this.handleButtonsEnablement();
    }

    @Override
    public void setTreeContentProvider(ITreeContentProvider treeContentProvider) {
        this.compositeResourceGroup.setTreeContentProvider(treeContentProvider);
    }

    @Override
    public void setTreeLabelProvider(IBaseLabelProvider treeLabelProvider) {
        this.compositeResourceGroup.setTreeLabelProvider(treeLabelProvider);
    }

    @Override
    public void setSelectionListener(ISelectionChangedListener selectionListener) {
        this.compositeResourceGroup.setSelectionListener(selectionListener);
    }

    @Override
    public boolean isNothingSelected() {
        if (this.compositeResourceGroup instanceof CompositeCheckedTreeGroup) {
            return ((CompositeCheckedTreeGroup)this.compositeResourceGroup).isTreeFullyUnChecked();
        }
        return this.compositeResourceGroup.isNothingSelected();
    }

    @Override
    public void enableExpansionButtons(boolean enabled) {
        if (this.collapseAllButton != null) {
            this.collapseAllButton.setEnabled(enabled);
        }
        if (this.expandAllButton != null) {
            this.expandAllButton.setEnabled(enabled);
        }
    }

    @Override
    public void enableSelectionButtons(boolean enabled) {
        if (this.selectButton != null) {
            this.selectButton.setEnabled(enabled);
        }
        if (this.deselectButton != null) {
            this.deselectButton.setEnabled(enabled);
        }
    }

    @Override
    public void setRootObject(Object root) {
        this.isRootObjectSet = true;
        this.rootObject = root;
    }

    @Override
    public void updateRootObject(Object root) {
        this.compositeResourceGroup.setRoot(root);
    }

    @Override
    public void updateTreeViewer(Object[] elements, String[] properties) {
        this.treeViewer_.update(elements, properties);
    }

    @Override
    public void setIgnoredQNames(final List<QName> qnames) {
        this.compositeResourceGroup.setIgnoredQNames(qnames);
        ViewerFilter qnameFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof NamespaceNode) {
                    NamespaceNode nsNode = (NamespaceNode)element;
                    ArrayList<QName> childrenQName = new ArrayList<QName>();
                    Object[] objectArray = nsNode.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof ISCAComposite) {
                            childrenQName.add(((ISCAComposite)obj).getName());
                        }
                        if (obj instanceof IFile) {
                            ISCAComposite composite = (ISCAComposite)((IFile)obj).getAdapter(ISCAArtifact.class);
                            childrenQName.add(composite.getName());
                        }
                        ++n2;
                    }
                    childrenQName.removeAll(qnames);
                    return !childrenQName.isEmpty();
                }
                if (parentElement instanceof NamespaceNode) {
                    if (element instanceof ISCAComposite) {
                        return !qnames.contains(((ISCAComposite)element).getName());
                    }
                    if (element instanceof IFile) {
                        ISCAComposite composite = (ISCAComposite)((IFile)element).getAdapter(ISCAArtifact.class);
                        return !qnames.contains(composite.getName());
                    }
                }
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    ISCAProject scaProject = null;
                    try {
                        scaProject = SCAModelManager.createProject((IProject)project);
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                    ArrayList<QName> projectCompositeQNames = new ArrayList<QName>();
                    for (ISCAComposite composite : SCAModelManager.getComposites((ISCAProject)scaProject)) {
                        projectCompositeQNames.add(composite.getName());
                    }
                    projectCompositeQNames.removeAll(qnames);
                    return !projectCompositeQNames.isEmpty();
                }
                return true;
            }
        };
        this.treeViewer_.addFilter(qnameFilter);
        if (this.compositeResourceGroup.getItemsCount() == 0) {
            for (Button b : this.buttons) {
                b.setEnabled(false);
            }
        }
    }

    protected void createSearchScope() {
        this.enclosingProjectFilter_ = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (CompositeSelectionControl.this.project_ != null && element instanceof IProject) {
                    IProject project = (IProject)element;
                    String projectName = project.getName();
                    return projectName.equals(CompositeSelectionControl.this.project_.getName());
                }
                return true;
            }
        };
        this.enclosingProjectPlusReferencesFilter_ = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (CompositeSelectionControl.this.project_ != null && element instanceof IProject) {
                    IProject project = (IProject)element;
                    return CompositeSelectionControl.this.enclosingProjectPlusReferencedProjectNames.contains(project.getName());
                }
                return true;
            }
        };
        this.workingSetFilter_ = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    String projectName = project.getName();
                    return CompositeSelectionControl.this.workingSetProjectNames_.contains(projectName);
                }
                return true;
            }
        };
        Group scopeGroup = this.uiUtils.createGroup(this.composite, Messages.CompositeSelectionControl_SEARCH_SCOPE, null, null);
        Composite scopeComposite = this.uiUtils.createComposite((Composite)scopeGroup, 3);
        this.workspaceRadio_ = this.uiUtils.createRadioButton(scopeComposite, Messages.CompositeSelectionControl_WORKSPACE, null, null);
        this.workspaceRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeSelectionControl.this.treeViewer_ == null) {
                    return;
                }
                CompositeSelectionControl.this.checkStateSnapShot();
                if (CompositeSelectionControl.this.currentFilter_ != null) {
                    CompositeSelectionControl.this.treeViewer_.removeFilter(CompositeSelectionControl.this.currentFilter_);
                }
                CompositeSelectionControl.this.currentFilter_ = null;
                CompositeSelectionControl.this.restoreCheckState();
                CompositeSelectionControl.this.handleButtonsEnablement();
                CompositeSelectionControl.this.notifySearchScopeChangeListeners(e);
            }
        });
        boolean isWorkspaceScopeEnabled = this.scopes.get((Object)ICompositeSelectionControl.SCOPE.WORKSPACE);
        if (!isWorkspaceScopeEnabled) {
            this.workspaceRadio_.setEnabled(false);
            this.workspaceRadio_.setVisible(false);
        }
        this.enclosingProjectRadio_ = this.uiUtils.createRadioButton(scopeComposite, Messages.CompositeSelectionControl_ENCLOSING_PROJECT, null, null);
        this.enclosingProjectRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeSelectionControl.this.treeViewer_ == null) {
                    return;
                }
                CompositeSelectionControl.this.checkStateSnapShot();
                if (CompositeSelectionControl.this.currentFilter_ != null) {
                    CompositeSelectionControl.this.treeViewer_.removeFilter(CompositeSelectionControl.this.currentFilter_);
                }
                CompositeSelectionControl.this.currentFilter_ = CompositeSelectionControl.this.enclosingProjectFilter_;
                CompositeSelectionControl.this.treeViewer_.addFilter(CompositeSelectionControl.this.currentFilter_);
                CompositeSelectionControl.this.restoreCheckState();
                CompositeSelectionControl.this.handleButtonsEnablement();
                CompositeSelectionControl.this.notifySearchScopeChangeListeners(e);
            }
        });
        boolean isEnclosingProjectEnabled = this.scopes.get((Object)ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT);
        if (!isEnclosingProjectEnabled || this.project_ == null) {
            this.enclosingProjectRadio_.setEnabled(false);
            this.enclosingProjectRadio_.setVisible(false);
        }
        this.enclosingProjectPlusReferencesRadio_ = this.uiUtils.createRadioButton(scopeComposite, Messages.CompositeSelectionControl_ENCLOSING_PROJECT_PLUS_REFERENCES, null, null);
        this.enclosingProjectPlusReferencesRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeSelectionControl.this.treeViewer_ == null) {
                    return;
                }
                CompositeSelectionControl.this.checkStateSnapShot();
                if (CompositeSelectionControl.this.currentFilter_ != null) {
                    CompositeSelectionControl.this.treeViewer_.removeFilter(CompositeSelectionControl.this.currentFilter_);
                }
                CompositeSelectionControl.this.currentFilter_ = CompositeSelectionControl.this.enclosingProjectPlusReferencesFilter_;
                CompositeSelectionControl.this.treeViewer_.addFilter(CompositeSelectionControl.this.currentFilter_);
                CompositeSelectionControl.this.restoreCheckState();
                CompositeSelectionControl.this.handleButtonsEnablement();
                CompositeSelectionControl.this.notifySearchScopeChangeListeners(e);
            }
        });
        boolean isEnclosingProjectDependenciesEnabled = this.scopes.get((Object)ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT_PLUS_DEPENDENCIES);
        if (!isEnclosingProjectDependenciesEnabled || this.project_ == null) {
            this.enclosingProjectPlusReferencesRadio_.setEnabled(false);
            this.enclosingProjectPlusReferencesRadio_.setVisible(false);
        }
        this.workingSetRadio_ = this.uiUtils.createRadioButton(scopeComposite, Messages.CompositeSelectionControl_WORKING_SET, null, null);
        final Text workingSetText = new Text(scopeComposite, 2056);
        workingSetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CompositeSelectionControl.this.treeViewer_ == null) {
                    return;
                }
                if (!CompositeSelectionControl.this.workingSetRadio_.getSelection()) {
                    return;
                }
                CompositeSelectionControl.this.checkStateSnapShot();
                if (CompositeSelectionControl.this.currentFilter_ != null) {
                    CompositeSelectionControl.this.treeViewer_.removeFilter(CompositeSelectionControl.this.currentFilter_);
                }
                CompositeSelectionControl.this.currentFilter_ = CompositeSelectionControl.this.workingSetFilter_;
                CompositeSelectionControl.this.treeViewer_.addFilter(CompositeSelectionControl.this.currentFilter_);
                CompositeSelectionControl.this.restoreCheckState();
                CompositeSelectionControl.this.handleButtonsEnablement();
            }
        });
        this.workingSetRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeSelectionControl.this.treeViewer_ == null) {
                    return;
                }
                if (workingSetText.getText().length() == 0) {
                    return;
                }
                CompositeSelectionControl.this.checkStateSnapShot();
                if (CompositeSelectionControl.this.currentFilter_ != null) {
                    CompositeSelectionControl.this.treeViewer_.removeFilter(CompositeSelectionControl.this.currentFilter_);
                }
                CompositeSelectionControl.this.currentFilter_ = CompositeSelectionControl.this.workingSetFilter_;
                CompositeSelectionControl.this.treeViewer_.addFilter(CompositeSelectionControl.this.currentFilter_);
                CompositeSelectionControl.this.restoreCheckState();
                CompositeSelectionControl.this.handleButtonsEnablement();
                CompositeSelectionControl.this.notifySearchScopeChangeListeners(e);
            }
        });
        workingSetText.setLayoutData((Object)new GridData(1808));
        Button choose = new Button(scopeComposite, 8);
        choose.setText(Messages.CompositeSelectionControl_CHOOSE_BUTTON);
        choose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(CompositeSelectionControl.this.composite.getShell(), true);
                dialog.setSelection(CompositeSelectionControl.this.workingSets_);
                if (dialog.open() == 0) {
                    CompositeSelectionControl.this.workingSets_ = dialog.getSelection();
                    CompositeSelectionControl.this.workingSetProjectNames_.clear();
                    if (CompositeSelectionControl.this.workingSets_.length > 0) {
                        CompositeSelectionControl.this.workspaceRadio_.setSelection(false);
                        CompositeSelectionControl.this.enclosingProjectRadio_.setSelection(false);
                        CompositeSelectionControl.this.enclosingProjectPlusReferencesRadio_.setSelection(false);
                        CompositeSelectionControl.this.workingSetRadio_.setSelection(true);
                        CompositeSelectionControl.this.workingSetRadio_.setFocus();
                    }
                    boolean isWindowWorkingSet = false;
                    String workingSetNames = "";
                    IWorkingSet[] iWorkingSetArray = CompositeSelectionControl.this.workingSets_;
                    int n = CompositeSelectionControl.this.workingSets_.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkingSet ws = iWorkingSetArray[n2];
                        if (ws.isAggregateWorkingSet()) {
                            isWindowWorkingSet = true;
                        }
                        if (workingSetNames.length() > 0) {
                            workingSetNames = String.valueOf(workingSetNames) + Messages.CompositeSelectionControl_COMMA_SEPARATOR;
                        }
                        workingSetNames = String.valueOf(workingSetNames) + ws.getName();
                        IAdaptable[] iAdaptableArray = ws.getElements();
                        int n3 = iAdaptableArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IAdaptable element = iAdaptableArray[n4];
                            Object project = element.getAdapter(IProject.class);
                            if (project != null && project instanceof IProject) {
                                String projectName = ((IProject)project).getName();
                                CompositeSelectionControl.this.workingSetProjectNames_.add(projectName);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    if (isWindowWorkingSet) {
                        workingSetText.setText(Messages.CompositeSelectionControl_WINDOW_WORKING_SET);
                    } else {
                        workingSetText.setText(workingSetNames);
                    }
                    CompositeSelectionControl.this.notifySearchScopeChangeListeners(e);
                }
            }
        });
        boolean isWorkingSetEnabled = this.scopes.get((Object)ICompositeSelectionControl.SCOPE.WORKINGSET);
        if (!isWorkingSetEnabled) {
            this.workingSetRadio_.setEnabled(false);
            this.workingSetRadio_.setVisible(false);
            workingSetText.setEnabled(false);
            workingSetText.setVisible(false);
            choose.setEnabled(false);
            choose.setVisible(false);
        }
        if (this.project_ == null) {
            this.workspaceRadio_.setSelection(true);
        } else {
            this.currentFilter_ = this.enclosingProjectPlusReferencesFilter_;
            this.treeViewer_.addFilter(this.currentFilter_);
            this.enclosingProjectPlusReferencesRadio_.setSelection(true);
        }
    }

    @Override
    public void setCurrentResource(IResource resource) {
        this.resource_ = resource;
        if (resource != null) {
            this.project_ = this.resource_.getProject();
        }
        this.enclosingProjectPlusReferencedProjectNames.clear();
        this.buildProjectNamesForEnclosingProjectsPlusReferences(this.project_);
        if (this.treeViewer_ != null) {
            this.checkStateSnapShot();
            this.treeViewer_.refresh();
            this.restoreCheckState();
        }
        if (this.project_ != null) {
            if (this.enclosingProjectRadio_ != null) {
                this.enclosingProjectRadio_.setEnabled(true);
                this.enclosingProjectRadio_.setVisible(true);
            }
            if (this.enclosingProjectPlusReferencesRadio_ != null) {
                this.enclosingProjectPlusReferencesRadio_.setEnabled(true);
                this.enclosingProjectPlusReferencesRadio_.setVisible(true);
            }
        }
    }

    private void buildProjectNamesForEnclosingProjectsPlusReferences(IProject project) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (this.enclosingProjectPlusReferencedProjectNames.contains(projectName)) {
            return;
        }
        this.enclosingProjectPlusReferencedProjectNames.add(projectName);
        try {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject reference = iProjectArray[n2];
                if (!this.enclosingProjectPlusReferencedProjectNames.contains(reference.getName())) {
                    this.enclosingProjectPlusReferencedProjectNames.add(reference.getName());
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Status status = new Status(2, "com.ibm.ccl.sca.ui", Messages.bind((String)Messages.CompositeSelectionControl_ERROR_CANNOT_FIND_REFERENCED_PROJECT, (Object)project.getName()), e.getCause());
            SCAToolsUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void handleButtonsEnablement() {
        boolean enabled = this.compositeResourceGroup.getItemsCount() != 0;
        for (Button b : this.buttons) {
            b.setEnabled(enabled);
        }
    }

    private void checkStateSnapShot() {
        if (this.treeViewer_ == null) {
            return;
        }
        if (this.treeViewer_ instanceof CheckboxTreeViewer) {
            CheckboxTreeViewer checkTreeViewer = (CheckboxTreeViewer)this.treeViewer_;
            this.grayedElements_ = checkTreeViewer.getGrayedElements();
            this.checkedElements_ = checkTreeViewer.getCheckedElements();
        }
        this.expandedElements_ = this.treeViewer_.getExpandedElements();
    }

    private void restoreCheckState() {
        if (this.treeViewer_ == null) {
            return;
        }
        if (this.treeViewer_ instanceof CheckboxTreeViewer) {
            CheckboxTreeViewer checkTreeViewer = (CheckboxTreeViewer)this.treeViewer_;
            if (this.grayedElements_ != null) {
                checkTreeViewer.setGrayedElements(this.grayedElements_);
            }
            if (this.checkedElements_ != null) {
                checkTreeViewer.setCheckedElements(this.checkedElements_);
            }
        }
        if (this.expandedElements_ != null) {
            this.treeViewer_.setExpandedElements(this.expandedElements_);
        }
    }

    @Override
    public void setSearchScope(ICompositeSelectionControl.SCOPE scope, boolean enabled) {
        this.scopes.put(scope, new Boolean(enabled));
    }

    @Override
    public void addSearchScopeListener(SelectionListener listener) {
        this.searchScopeChangeListeners_.add(listener);
    }

    private void notifySearchScopeChangeListeners(SelectionEvent e) {
        for (SelectionListener listerner : this.searchScopeChangeListeners_) {
            listerner.widgetSelected(e);
        }
    }
}

