/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeAndContributionCheckedTreeGroup;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class CompositeAndContributionSelControl
extends CompositeSelectionControl {
    private ISCAProject[] scaProjects;
    private IProject[] projectsWithComposites;

    protected CompositeAndContributionSelControl(Composite parent) {
        super(parent);
    }

    @Override
    public void createCheckedTreeSelectionWidget() {
        this.compositeResourceGroup = new CompositeAndContributionCheckedTreeGroup(this.composite, null, 2048, this.useHeightHint);
    }

    public List<ISCAContribution> getSelectedContribution() {
        return ((CompositeAndContributionCheckedTreeGroup)this.compositeResourceGroup).getSelectedContributions();
    }

    public void setExportByContributions(boolean isExportContributions) {
        ((CompositeAndContributionCheckedTreeGroup)this.compositeResourceGroup).setExportByContributions(isExportContributions);
    }

    private void handleButtonsEnablement() {
        boolean enabled = this.compositeResourceGroup.getItemsCount() != 0;
        for (Button b : this.buttons) {
            b.setEnabled(enabled);
        }
    }

    public static CompositeAndContributionSelControl createCompositeSelectionControlAsCheckedTree(Composite composite) {
        CompositeAndContributionSelControl control = new CompositeAndContributionSelControl(composite);
        control.createCheckedTreeSelectionWidget();
        return control;
    }

    public void handleExportCompositesChoice(SelectionEvent e) {
        Object element;
        ITreeContentProvider compositesProvider = ((CompositeAndContributionCheckedTreeGroup)this.compositeResourceGroup).getCurrentCompositesTreeProvider();
        this.expandAllButton.setEnabled(true);
        this.collapseAllButton.setEnabled(true);
        CheckboxTreeViewer checkTreeViewer = (CheckboxTreeViewer)this.treeViewer_;
        Object[] checked = checkTreeViewer.getCheckedElements();
        Object[] grayed = checkTreeViewer.getGrayedElements();
        this.compositeResourceGroup.duplicatesMap.clear();
        this.compositeResourceGroup.setTreeContentProvider(compositesProvider);
        checkTreeViewer.setCheckedElements(checked);
        checkTreeViewer.setGrayedElements(grayed);
        HashSet<Object> grayedProjects = new HashSet<Object>();
        Object[] objectArray = grayed;
        int n = grayed.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof IProject) {
                grayedProjects.add(element);
            }
            ++n2;
        }
        objectArray = checked;
        n = checked.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof IProject && !grayedProjects.contains(element)) {
                checkTreeViewer.setSubtreeChecked(element, true);
            }
            ++n2;
        }
    }

    public void handleExportContributionChoice(SelectionEvent e) {
        Object element;
        ITreeContentProvider contributionsProvider = ((CompositeAndContributionCheckedTreeGroup)this.compositeResourceGroup).getCurrentContributionsTreeProvider();
        this.expandAllButton.setEnabled(false);
        this.collapseAllButton.setEnabled(false);
        CheckboxTreeViewer checkTreeViewer = (CheckboxTreeViewer)this.treeViewer_;
        Object[] checked = checkTreeViewer.getCheckedElements();
        Object[] grayed = checkTreeViewer.getGrayedElements();
        this.compositeResourceGroup.setTreeContentProvider(contributionsProvider);
        HashSet<Object> grayedProjects = new HashSet<Object>();
        Object[] objectArray = grayed;
        int n = grayed.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof IProject) {
                grayedProjects.add(element);
            }
            ++n2;
        }
        objectArray = checked;
        n = checked.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof IProject && !grayedProjects.contains(element)) {
                checkTreeViewer.setChecked(element, true);
            } else {
                checkTreeViewer.setChecked(element, false);
            }
            ++n2;
        }
    }

    public void initializeTreeView(boolean isInitializeViewByContributions) {
        if (!this.isRootObjectSet) {
            try {
                this.scaProjects = SCAModelUtil.convertSCAProjectsListToArray((List)SCAModelUtil.getSCAProjectsList());
            }
            catch (CoreException coreException) {}
            this.setExportByContributions(isInitializeViewByContributions);
            if (isInitializeViewByContributions) {
                if (this.scaProjects != null && this.scaProjects.length != 0) {
                    int projectSize = this.scaProjects.length;
                    int i = 0;
                    while (i < projectSize) {
                        List projectContributionsList = SCAModelManager.getContributions((ISCAProject)this.scaProjects[i]);
                        for (ISCAContribution scaContribution : projectContributionsList) {
                            if (scaContribution == null || scaContribution.isVirtual()) continue;
                            this.input.add(this.scaProjects[i].getProject());
                        }
                        ++i;
                    }
                    this.rootObject = this.input;
                }
            } else {
                this.projectsWithComposites = SCAModelUtil.convertSCAProjectsListToIProjectsWithCompositesArray((ISCAProject[])this.scaProjects);
                if (this.projectsWithComposites != null && this.projectsWithComposites.length != 0) {
                    int projectSize = this.projectsWithComposites.length;
                    int i = 0;
                    while (i < projectSize) {
                        if (this.projectsWithComposites[i] != null && this.projectsWithComposites[i].isOpen()) {
                            this.input.add(this.projectsWithComposites[i]);
                        }
                        ++i;
                    }
                    this.rootObject = this.input;
                }
            }
            this.compositeResourceGroup.setRootObject(this.rootObject);
            this.compositeResourceGroup.initialize();
            this.treeViewer_ = this.compositeResourceGroup.getTreeViewer();
            this.createNavigationControlButtonsGroup();
            this.initializeSearchScope();
            this.handleButtonsEnablement();
        }
    }

    protected void initializeSearchScope() {
        boolean hideAllScope = (Boolean)this.scopes.get((Object)ICompositeSelectionControl.SCOPE.HIDE_ALL_SCOPE);
        if (!hideAllScope) {
            this.createSearchScope();
        }
        this.handleButtonsEnablement();
    }
}

