/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.utils;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import com.ibm.ccl.sca.server.websphere.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class SCAModelUtil {
    public static ISCAProject getSCAProject(IProject project) throws CoreException {
        ISCAProject scaProject;
        IProjectFacet soaFeaturePackProjectFacet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.scafp");
        Set soaFeaturePackFacetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)soaFeaturePackProjectFacet);
        if (soaFeaturePackFacetedProjects.contains(project) && !SCAModelManager.getComposites((ISCAProject)(scaProject = SCAModelManager.createProject((IProject)project))).isEmpty()) {
            return scaProject;
        }
        return null;
    }

    public static List<ISCAProject> getSCAProjectsList() throws CoreException {
        IProjectFacet soaFeaturePackProjectFacet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.scafp");
        Set soaFeaturePackFacetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)soaFeaturePackProjectFacet);
        for (IFacetedProject soaFeaturePackFacetedProject : soaFeaturePackFacetedProjects) {
            IProject scaProject = soaFeaturePackFacetedProject.getProject();
            SCAModelManager.createProject((IProject)scaProject);
        }
        return SCAModelManager.getLoadedProjects();
    }

    public static List<ISCAProject> getSCAProjectsWithCompositesList(List<ISCAProject> scaProjectsList) throws CoreException {
        if (scaProjectsList == null || scaProjectsList.isEmpty()) {
            return null;
        }
        ArrayList<ISCAProject> scaProjectsWithCompositesList = new ArrayList<ISCAProject>();
        for (ISCAProject scaProject : scaProjectsList) {
            if (SCAModelManager.getComposites((ISCAProject)scaProject).isEmpty()) continue;
            scaProjectsWithCompositesList.add(scaProject);
        }
        return scaProjectsWithCompositesList;
    }

    public static List<ISCAContribution> getContributionsListFromSCAProject(ISCAProject scaProject) {
        return SCAModelManager.getContributions((ISCAProject)scaProject);
    }

    public static List<ISCAComposite> getISCAComposites(ISCAContribution contribution) {
        Logger.println(2, SCAModelUtil.class, "getISCAComposites(.) Enter.");
        ArrayList<ISCAComposite> composites = new ArrayList<ISCAComposite>();
        List<ISCAArtifact<?>> artifactList = SCAModelUtil.resolveArtifactsInContribution(contribution);
        if (artifactList != null) {
            for (ISCAArtifact<?> artifact : artifactList) {
                if (!(artifact instanceof ISCAComposite)) continue;
                composites.add((ISCAComposite)artifact);
                Logger.println(3, SCAModelUtil.class, "getISCAComposites(.) adding composite:" + ((ISCAComposite)artifact).getLogicalName());
            }
        }
        Logger.println(2, SCAModelUtil.class, "getISCAComposites(.) Exiting.");
        return composites;
    }

    public static List<ISCAArtifact<?>> resolveArtifactsInContribution(ISCAContribution contribution) {
        Logger.println(2, SCAModelUtil.class, "resolveArtifactsInContribution(.) Enter.");
        SCAModelResolver resolver = new SCAModelResolver(contribution);
        try {
            resolver.run(null);
        }
        catch (CoreException e) {
            Logger.println(0, SCAModelUtil.class, "resolveArtifactsInContribution(.)", "Exception when running contribution resolver.", (Throwable)e);
        }
        List artifactList = resolver.getArtifacts();
        Logger.println(2, SCAModelUtil.class, "resolveArtifactsInContribution(.) Exiting.");
        return artifactList;
    }
}

