/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.plugin;

import com.ibm.ccl.sca.server.websphere.utils.Logger;
import com.ibm.ccl.sca.server.websphere.utils.ProgressUtils;
import com.ibm.cic.licensing.common.LicenseCheck;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SCAWebSphereServerCorePlugin
extends Plugin {
    private static SCAWebSphereServerCorePlugin plugin;
    public static final String PLUGIN_ID = "com.ibm.ccl.sca.server.websphere";
    protected IPath installLocationPath = null;

    public SCAWebSphereServerCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LicenseCheck.requestLicense((Plugin)this, (String)"com.ibm.ccl.sca", (String)"1.0.0");
        SCAWebSphereServerCorePlugin.deleteTempDirectories((IProgressMonitor)new NullProgressMonitor());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static SCAWebSphereServerCorePlugin getInstance() {
        return plugin;
    }

    public boolean isDebug() {
        return Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.ibm.ccl.sca.server.websphere/debug"));
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IPath getPluginInstallLocation() {
        SCAWebSphereServerCorePlugin curPlugin = SCAWebSphereServerCorePlugin.getInstance();
        if (curPlugin.installLocationPath == null) {
            String installLocation = SCAWebSphereServerCorePlugin.getBundleFullLocationPath(SCAWebSphereServerCorePlugin.getInstance().getBundle());
            curPlugin.installLocationPath = new Path(installLocation);
        }
        return curPlugin.installLocationPath;
    }

    public static String getBundleFullLocationPath(Bundle curBundle) {
        if (curBundle == null) {
            return null;
        }
        URL installURL = curBundle.getEntry("/");
        String installLocation = null;
        try {
            URL realURL = FileLocator.resolve((URL)installURL);
            installLocation = realURL.getFile();
            if (installLocation != null && installLocation.startsWith("/") && installLocation.indexOf(":") > 0 && !(installLocation = installLocation.substring(1)).endsWith("/")) {
                installLocation = String.valueOf(installLocation) + "/";
            }
        }
        catch (IOException iOException) {
            Logger.println(0, "getTempDirectory()", "Failed to get the plug-in temporary directory ");
        }
        return installLocation;
    }

    public static void deleteDirectory(File directory, IProgressMonitor monitor) {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        try {
            File[] files = directory.listFiles();
            int size = files.length;
            monitor = ProgressUtils.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)"", (Object[])new String[]{directory.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)"", (Object[])new String[]{current.getAbsolutePath()}));
                    SCAWebSphereServerCorePlugin.deleteDirectory(current, ProgressUtils.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            directory.delete();
            monitor.done();
        }
        catch (Exception exception) {
            Logger.println(0, "Error deleting directory " + directory.getAbsolutePath());
        }
    }

    public static void deleteTempDirectories(IProgressMonitor monitor) {
        IPath statePath = SCAWebSphereServerCorePlugin.getInstance().getStateLocation();
        File directory = statePath.toFile();
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        try {
            File[] files = directory.listFiles();
            int size = files.length;
            monitor = ProgressUtils.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)"", (Object[])new String[]{directory.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)"", (Object[])new String[]{current.getAbsolutePath()}));
                    SCAWebSphereServerCorePlugin.deleteDirectory(current, ProgressUtils.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            monitor.done();
        }
        catch (Exception exception) {
            Logger.println(0, "Error cleaning up the temporary directories " + directory.getAbsolutePath());
        }
    }

    public static boolean deleteFilesFromDirectory(String directoryName) {
        boolean result = false;
        if (directoryName == null) {
            return false;
        }
        File directoryPath = new File(directoryName);
        if (directoryPath.isDirectory()) {
            String[] fileList = directoryPath.list();
            result = true;
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    File file = new File(String.valueOf(directoryName) + File.separator + fileList[i]);
                    if (file.exists()) {
                        result &= file.delete();
                    }
                    ++i;
                }
            }
        }
        return result;
    }
}

