/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.archive;

import com.ibm.ccl.sca.server.websphere.archive.ISCAMementoPersister;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class SCAMementoPersister
implements ISCAMementoPersister {
    private Document document;
    private Element element;

    private SCAMementoPersister(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    @Override
    public ISCAMementoPersister createChild(String type) {
        Element child = this.document.createElement(type);
        this.element.appendChild(child);
        return new SCAMementoPersister(this.document, child);
    }

    /*
     * Loose catch block
     */
    private static SCAMementoPersister createReadRoot(InputStream inputStream) {
        block13: {
            block12: {
                Document document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                document = parser.parse(new InputSource(inputStream));
                Node node = document.getFirstChild();
                if (!(node instanceof Element)) break block12;
                SCAMementoPersister sCAMementoPersister = new SCAMementoPersister(document, (Element)node);
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                return sCAMementoPersister;
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception3) {}
                    break block13;
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static SCAMementoPersister createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new SCAMementoPersister(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    @Override
    public ISCAMementoPersister getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int i = 0;
        while (i < size) {
            Element element2;
            Node node = nodes.item(i);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                return new SCAMementoPersister(this.document, element2);
            }
            ++i;
        }
        return null;
    }

    @Override
    public ISCAMementoPersister[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new ISCAMementoPersister[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int i = 0;
        while (i < size) {
            Element element2;
            Node node = nodes.item(i);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                list.add(element2);
            }
            ++i;
        }
        ISCAMementoPersister[] results = new ISCAMementoPersister[size];
        int i2 = 0;
        while (i2 < size) {
            results[i2] = new SCAMementoPersister(this.document, (Element)list.get(i2));
            ++i2;
        }
        return results;
    }

    @Override
    public String getString(String key) {
        Attr attribute = this.element.getAttributeNode(key);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public static ISCAMementoPersister loadMemento(String filename) throws IOException {
        SCAMementoPersister sCAMementoPersister;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(filename));
            sCAMementoPersister = SCAMementoPersister.createReadRoot(inputStream);
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return sCAMementoPersister;
    }

    @Override
    public void putStringValue(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    private void save(OutputStream outputStream) throws IOException {
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(this.document);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void putIntegerValue(String key, int integerValue) {
        this.element.setAttribute(key, String.valueOf(integerValue));
    }

    public void saveToFile(String filename) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(filename);
                this.save(fileOutputStream);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

