/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.java.ui.contribution.editor.extension;

import com.ibm.ccl.sca.java.ui.messages.Messages;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportEditHelper;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JavaImportEditHelper
implements IImportExportEditHelper {
    private ImportExportWrapper wrapper;
    private Text packageName;
    private Button selectButton;
    private Button okButton;

    public void setData(ImportExportWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void createControls(Composite composite) {
        final Shell shell = composite.getShell();
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.java.ui");
        JavaImport javaImport = (JavaImport)this.wrapper.getData();
        Composite packageComposite = utils.createComposite(composite, 3);
        this.packageName = utils.createText(packageComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_PACKAGE, null, null, 2048);
        if (javaImport.getPackage() != null) {
            this.packageName.setText(javaImport.getPackage());
        }
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaImportEditHelper.this.updateButtonStatus();
            }
        });
        this.selectButton = utils.createPushButton(packageComposite, Messages.JavaImportEditHelper_LABEL_BROWSE_JAVA_IMPORT_PACKAGE, null, null);
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    block6: {
                        IProject project = iProjectArray[n2];
                        if (project != null) {
                            IJavaProject javaProject;
                            IProjectNature javaNature;
                            try {
                                javaNature = project.getNature("org.eclipse.jdt.core.javanature");
                            }
                            catch (CoreException coreException) {
                                break block6;
                            }
                            if (javaNature != null && (javaProject = JavaCore.create((IProject)project)) != null) {
                                javaProjectList.add(javaProject);
                            }
                        }
                    }
                    ++n2;
                }
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])javaProjectList.toArray(new IJavaProject[javaProjectList.size()])), (int)9);
                PackageSelectionDialog dialog_ = new PackageSelectionDialog(shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), 12, scope);
                dialog_.setMultipleSelection(false);
                dialog_.setTitle(Messages.TITLE_JAVA_IMPORT_DIALOG);
                dialog_.setMessage(Messages.LABEL_NAME_PATTERN_JAVA_IMPORT);
                if (dialog_.open() == 0 && (result = dialog_.getResult()) != null && result.length == 1 && result[0] instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)result[0];
                    JavaImportEditHelper.this.packageName.setText(packageFragment.getElementName());
                }
            }
        });
    }

    private void updateButtonStatus() {
        if (this.packageName.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    public void setOKButton(Button button) {
        this.okButton = button;
        this.updateButtonStatus();
    }

    public void updateData() {
        JavaImport javaImport = (JavaImport)this.wrapper.getData();
        javaImport.setPackage(this.packageName.getText());
    }
}

