/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.java.annotations.quickfix;

import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.java.annotations.Activator;
import com.ibm.ccl.sca.java.annotations.messages.Messages;
import com.ibm.ccl.sca.java.annotations.quickfix.AddRuntimeTargetProposal;
import com.ibm.ccl.sca.java.annotations.quickfix.AddSCAFPFacetProposal;
import com.ibm.ccl.sca.java.annotations.quickfix.Convert60To70Proposal;
import com.ibm.ccl.sca.java.annotations.quickfix.Convert61To70Proposal;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class QuickFixProcessor
implements IQuickFixProcessor {
    public static final String OSOA_SCA_PKG_PREFIX = "org.osoa.sca.annotations";

    private boolean hasSCAFPFacet(IProject project, String facetName, String version) {
        boolean returnValue = false;
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetName, (String)version)) {
                returnValue = true;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return returnValue;
    }

    private final void collectProposals(List<IJavaCompletionProposal> proposalList, IProject project, String problemText, IInvocationContext context) {
        boolean canQuickFix = false;
        String autoImportTypeName = null;
        if (problemText.startsWith(OSOA_SCA_PKG_PREFIX)) {
            canQuickFix = true;
        } else if (problemText.equals("Service") || problemText.equals("Remotable") || problemText.equals("Reference")) {
            canQuickFix = true;
            autoImportTypeName = "org.osoa.sca.annotations." + problemText;
        }
        if (canQuickFix) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) {
                    proposalList.add(new AddSCAFPFacetProposal(project, "com.ibm.websphere.scafp", "1.0", autoImportTypeName, context, 100));
                } else {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
                    if (primaryRuntime != null) {
                        IRuntime runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
                        if (WASRuntimeUtil.isWASv70Runtime((IRuntime)runtime)) {
                            if (!this.hasSCAFPFacet(project, "com.ibm.websphere.scafp", "1.0")) {
                                proposalList.add(new AddSCAFPFacetProposal(project, "com.ibm.websphere.scafp", "1.0", autoImportTypeName, context, 100));
                            }
                        } else if (WASRuntimeUtil.isWASv60Runtime((IRuntime)runtime)) {
                            proposalList.add(new Convert60To70Proposal(project, "com.ibm.websphere.scafp", "1.0", autoImportTypeName, context, 100));
                        } else if (WASRuntimeUtil.isWASv61Runtime((IRuntime)runtime)) {
                            proposalList.add(new Convert61To70Proposal(project, "com.ibm.websphere.scafp", "1.0", autoImportTypeName, context, 100));
                        }
                    } else {
                        IProjectFacetVersion facetVersion = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.scafp").getVersion("1.0");
                        proposalList.add(new AddRuntimeTargetProposal(project, "com.ibm.websphere.scafp", "1.0", new IProjectFacetVersion[]{facetVersion}, autoImportTypeName, context, 100));
                    }
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(StatusUtil.errorStatus((String)Messages.QuickFixProcessor_5, (Throwable)e));
            }
        }
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> res = new ArrayList<IJavaCompletionProposal>();
        ICompilationUnit icu = context.getCompilationUnit();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            if (this.hasCorrections(icu, problem.getProblemId())) {
                String problemText = icu.getBuffer().getText(problem.getOffset(), problem.getLength());
                IProject project = icu.getResource().getProject();
                if (this.isJavaProject(project)) {
                    this.collectProposals(res, project, problemText, context);
                }
            }
            ++n2;
        }
        if (res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 0x1000002 || problemId == 268435846;
    }

    public boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

