/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation;

import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.IWebSphereValidationConstants;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class WSDLEndpointRule
extends AbstractValidationRule {
    private static final String ENDPOINT_STR = "#wsdl.endpoint(";

    public WSDLEndpointRule() {
        super("com.ibm.ccl.sca.facets.websphere.WSDLEndpointRule");
    }

    public String getDescription() {
        return Messages.DESC_WSDL_ENDPOINT_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        StartElement element = (StartElement)context.getModel();
        Attribute attribute = element.getAttributeByName(IWebSphereValidationConstants.WSDL_ELEMENT_ATTR);
        if (attribute != null && attribute.getValue().indexOf(ENDPOINT_STR) != -1) {
            context.postMessage(Messages.MSG_UNSUPPORTED_WSDL_ENDPOINT, "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
        }
    }
}

