/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.wizards;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.core.util.QNameHelpers;
import com.ibm.ccl.sca.core.util.intents.IntentUtils;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.ui.common.controls.intents.IntentSelectionDialog;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.internal.ui.project.SCAProjectWizard;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CompositeCreationPage
extends WizardPage {
    private String INFOPOP_NEWCOMPOSITE_CREATION = "NEWCOMPOSITE_CREATION";
    private Combo projectCombo_;
    private Text outputLocationCombo_;
    private Text compositeNameText_;
    private Text namespaceText_;
    private Button autoWireButton_;
    List<ISCAProject> scaProjects_;
    private IStructuredSelection selection_;
    private Button newSCAProjectButton_;
    private IProject target = null;
    private SCAPreferences preferences;
    private IContainer outputContainer = null;
    private Listener listener_;
    private IStatus currentStatus_;
    private List<QName> intents_;
    private Table requiresTable_;
    private final String INTENT_QNAME = "INTENT_QNAME";

    public CompositeCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection_ = selection;
        this.preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        this.setPageComplete(false);
        this.intents_ = new ArrayList<QName>();
    }

    public void createControl(Composite parent) {
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Composite pageui = uiUtils.createComposite(parent, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageui, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_NEWCOMPOSITE_CREATION);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)pageui);
        Dialog.applyDialogFont((Control)pageui);
        this.projectCombo_ = uiUtils.createCombo(pageui, Messages.LABEL_NEWCOMPOSITE_PROJECT, Messages.TOOLTIP_NEWCOMPOSITE_PROJECT, null, 2056);
        this.newSCAProjectButton_ = uiUtils.createPushButton(pageui, Messages.LABEL_NEWCOMPOSITE_NEW_PROJECT, Messages.TOOLTIP_NEWCOMPOSITE_NEW_PROJECT, null);
        this.outputLocationCombo_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_OUTPUT_LOCATION, Messages.TOOLTIP_NEWCOMPOSITE_OUTPUT_LOCATION, null, 2048);
        this.outputLocationCombo_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (CompositeCreationPage.this.determinePageComplete() == Status.OK_STATUS) {
                    CompositeCreationPage.this.setErrorMessage(null);
                    CompositeCreationPage.this.setPageComplete(true);
                } else {
                    CompositeCreationPage.this.setErrorMessage(CompositeCreationPage.this.currentStatus_.getMessage());
                    CompositeCreationPage.this.setPageComplete(false);
                }
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        });
        new Label(pageui, 0);
        this.projectCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = CompositeCreationPage.this.projectCombo_.getSelectionIndex();
                IProject selectedProj = CompositeCreationPage.this.scaProjects_.get(i).getProject();
                CompositeCreationPage.this.setOutputLocation(selectedProj);
                CompositeCreationPage.this.updateNamespaceAndRequires(selectedProj);
                if (CompositeCreationPage.this.determinePageComplete() == Status.OK_STATUS) {
                    CompositeCreationPage.this.setErrorMessage(null);
                    CompositeCreationPage.this.setPageComplete(true);
                } else {
                    CompositeCreationPage.this.setErrorMessage(CompositeCreationPage.this.currentStatus_.getMessage());
                    CompositeCreationPage.this.setPageComplete(false);
                }
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newSCAProjectButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SCAProjectWizard wizard = new SCAProjectWizard();
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                int returnCode = dialog.open();
                if (returnCode == 1) {
                    return;
                }
                try {
                    IProject newSCAProject = wizard.getSCAProject();
                    if (newSCAProject == null) {
                        return;
                    }
                    CompositeCreationPage.this.projectCombo_.removeAll();
                    CompositeCreationPage.this.populateProjectCombo(newSCAProject);
                }
                catch (CoreException modelException) {
                    Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CANNOT_GET_SCA_PROJECT_NEW, (Throwable)modelException);
                    Activator.getDefault().getLog().log((IStatus)errStatus);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compositeNameText_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_COMPOSITE_NAME, Messages.TOOLTIP_NEWCOMPOSITE_COMPOSITE_NAME, null, 2048);
        new Label(pageui, 0);
        this.compositeNameText_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (CompositeCreationPage.this.determinePageComplete() == Status.OK_STATUS) {
                    CompositeCreationPage.this.setErrorMessage(null);
                    CompositeCreationPage.this.setPageComplete(true);
                } else {
                    CompositeCreationPage.this.setErrorMessage(CompositeCreationPage.this.currentStatus_.getMessage());
                    CompositeCreationPage.this.setPageComplete(false);
                }
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        });
        this.namespaceText_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_TARGET_NAMESPACE, Messages.TOOLTIP_NEWCOMPOSITE_TARGET_NAMESPACE, null, 2048);
        new Label(pageui, 0);
        this.namespaceText_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (CompositeCreationPage.this.determinePageComplete() == Status.OK_STATUS) {
                    CompositeCreationPage.this.setErrorMessage(null);
                    CompositeCreationPage.this.setPageComplete(true);
                } else {
                    CompositeCreationPage.this.setErrorMessage(CompositeCreationPage.this.currentStatus_.getMessage());
                    CompositeCreationPage.this.setPageComplete(false);
                }
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        });
        Label advancedSettingsSeparator = new Label(pageui, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        griddata.verticalIndent = 12;
        advancedSettingsSeparator.setLayoutData((Object)griddata);
        Composite composite2 = uiUtils.createComposite(pageui, 2);
        griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        composite2.setLayoutData((Object)griddata);
        this.autoWireButton_ = uiUtils.createCheckbox(composite2, Messages.LABEL_NEWCOMPOSITE_AUTOWIRE, Messages.TOOLTIP_NEWCOMPOSITE_AUTOWIRE, null);
        griddata = new GridData(256);
        griddata.horizontalSpan = 3;
        this.autoWireButton_.setLayoutData((Object)griddata);
        Composite intentComposite = uiUtils.createComposite(pageui, 2);
        griddata = new GridData(1808);
        griddata.horizontalSpan = 3;
        intentComposite.setLayoutData((Object)griddata);
        uiUtils.createLabel(intentComposite, Messages.LABEL_NEWCOMPOSITE_REQUIRES, null, 0);
        new Label(intentComposite, 0);
        this.requiresTable_ = uiUtils.createTable(intentComposite, Messages.TOOLTIP_NEWCOMPOSITE_REQUIRES, null, 2048);
        griddata = new GridData(1808);
        this.requiresTable_.setLayoutData((Object)griddata);
        Composite buttonComposite = new Composite(intentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Button addIntents = uiUtils.createPushButton(buttonComposite, Messages.CompositeCreationPage_BUTTON_ADD, null, null);
        addIntents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List intentsNames = IntentUtils.getInteractionNames();
                intentsNames.addAll(IntentUtils.getImplementationNames());
                List intentsToShow = IntentUtils.convertToQName((List)intentsNames);
                intentsToShow.removeAll(CompositeCreationPage.this.intents_);
                IntentSelectionDialog dialog = new IntentSelectionDialog(CompositeCreationPage.this.getShell(), intentsToShow);
                if (dialog.createAndOpen() == 0) {
                    List selectedIntents = dialog.getSelectedQNames();
                    CompositeCreationPage.this.addRequires(selectedIntents);
                }
            }
        });
        Button removeIntents = uiUtils.createPushButton(buttonComposite, Messages.CompositeCreationPage_BUTTON_REMOVE, null, null);
        removeIntents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeCreationPage.this.removeRequires();
            }
        });
        this.setButtonLayoutData(addIntents);
        this.setButtonLayoutData(removeIntents);
        this.initializeControls();
    }

    private void setOutputLocation(IProject project) {
        IPath path = project.getFullPath();
        String defaultFolder = this.preferences.getDefaultProjectFolder(project);
        if (!defaultFolder.equals("")) {
            path = path.append(defaultFolder);
        }
        this.outputLocationCombo_.setText(path.toString());
    }

    private void initializeControls() {
        try {
            Object element;
            IProject initialProject = null;
            String defaultNamespace = null;
            if (this.target != null) {
                this.projectCombo_.setEnabled(false);
                this.newSCAProjectButton_.setEnabled(false);
                initialProject = this.target;
            } else if (this.selection_ instanceof TreeSelection) {
                Object element2 = ((TreeSelection)this.selection_).getFirstElement();
                if (element2 instanceof ICompilationUnit) {
                    ICompilationUnit icu = (ICompilationUnit)element2;
                    IType javaType = icu.getTypes()[0];
                    initialProject = javaType.getJavaProject().getProject();
                } else if (element2 instanceof IFile) {
                    ISCAComposite composite;
                    IFile file = (IFile)element2;
                    if (file.getFileExtension().equals("composite") && (composite = (ISCAComposite)file.getAdapter(ISCAArtifact.class)) != null) {
                        defaultNamespace = composite.getName().getNamespaceURI();
                    }
                    initialProject = file.getProject();
                } else if (element2 instanceof ISCANode) {
                    ISCANode node = (ISCANode)element2;
                    initialProject = node.getProject();
                    if (node instanceof NamespaceNode) {
                        defaultNamespace = ((NamespaceNode)node).getNamespace();
                    } else if (node instanceof ComponentNode) {
                        ISCAComposite composite = (ISCAComposite)node.getParent();
                        defaultNamespace = composite.getName().getNamespaceURI();
                    }
                } else if (element2 instanceof ISCAArtifact) {
                    ISCAArtifact artifact = (ISCAArtifact)element2;
                    initialProject = artifact.getParent();
                    if (element2 instanceof ISCAComposite) {
                        defaultNamespace = ((ISCAComposite)element2).getName().getNamespaceURI();
                    }
                } else if (element2 instanceof IProject) {
                    initialProject = (IProject)element2;
                }
            } else if (this.selection_ != null && (element = this.selection_.getFirstElement()) instanceof IProject) {
                initialProject = (IProject)element;
            }
            this.populateProjectCombo(initialProject);
            this.setRequires(IntentUtils.getDefaultIntentsForComposite((IProject)initialProject));
            if (defaultNamespace == null) {
                defaultNamespace = this.preferences.getNamespace(initialProject);
            }
            this.namespaceText_.setText(defaultNamespace);
        }
        catch (CoreException e) {
            Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.MSG_ERROR_INITIALIZE_COMPOSITE_WIZARD, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errStatus);
        }
    }

    private void updateNamespaceAndRequires(IProject project) {
        this.namespaceText_.setText(this.preferences.getNamespace(project));
        this.setRequires(IntentUtils.getDefaultIntentsForComposite((IProject)project));
    }

    private void setRequires(List<QName> intents) {
        this.intents_ = intents;
        this.requiresTable_.removeAll();
        for (QName intent : this.intents_) {
            TableItem item = new TableItem(this.requiresTable_, 0);
            item.setText(intent.getLocalPart());
            item.setData("INTENT_QNAME", (Object)intent);
        }
    }

    private void addRequires(List<QName> intents) {
        for (QName intent : intents) {
            TableItem item = new TableItem(this.requiresTable_, 0);
            item.setText(intent.getLocalPart());
            item.setData("INTENT_QNAME", (Object)intent);
        }
        this.intents_.addAll(intents);
    }

    private void removeRequires() {
        ArrayList<QName> intents = new ArrayList<QName>();
        TableItem[] tableItemArray = this.requiresTable_.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            QName intent = (QName)item.getData("INTENT_QNAME");
            intents.add(intent);
            this.requiresTable_.remove(this.requiresTable_.indexOf(item));
            ++n2;
        }
        this.intents_.removeAll(intents);
    }

    private void populateProjectCombo(IProject project) throws CoreException {
        int i = 0;
        int selectionIndex = 0;
        this.scaProjects_ = SCAModelUtil.getSCAProjectsList();
        for (ISCAProject scaProject : this.scaProjects_) {
            String projectName = scaProject.getProject().getName();
            this.projectCombo_.add(projectName);
            if (project != null && projectName.equals(project.getName())) {
                selectionIndex = i;
            }
            ++i;
        }
        if (project != null) {
            this.projectCombo_.select(selectionIndex);
            this.setOutputLocation(project);
        }
    }

    public IProject getProject() {
        int i = this.projectCombo_.getSelectionIndex();
        if (i < 0) {
            return null;
        }
        return this.scaProjects_.get(i).getProject();
    }

    public String getOutputLocation() {
        return this.outputLocationCombo_.getText();
    }

    public IContainer getOutputContainer() {
        return this.outputContainer;
    }

    public String getCompositeName() {
        return this.compositeNameText_.getText();
    }

    public String getNamespace() {
        return this.namespaceText_.getText();
    }

    public boolean getLocal() {
        return false;
    }

    public boolean getAutoWire() {
        return this.autoWireButton_.getSelection();
    }

    public String getIntents() {
        return IntentUtils.convertQNameListToString(this.intents_);
    }

    public void setTargetProject(IProject target) {
        this.target = target;
        if (this.projectCombo_ != null) {
            this.initializeControls();
        }
    }

    public void setName(QName name) {
        if (name == null) {
            return;
        }
        this.namespaceText_.setText(name.getNamespaceURI());
        this.compositeNameText_.setText(name.getLocalPart());
    }

    public void setIntents(List<QName> intents) {
        this.setRequires(intents);
    }

    public IStatus determinePageComplete() {
        IProject project = this.getProject();
        if (project == null) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_0);
            return this.currentStatus_;
        }
        String location = this.getOutputLocation();
        if (location == null || location.trim().length() == 0) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_1);
            return this.currentStatus_;
        }
        IStatus validatePathStatus = ResourcesPlugin.getWorkspace().validatePath(location, 6);
        if (validatePathStatus.getSeverity() == 4) {
            this.currentStatus_ = validatePathStatus;
            return this.currentStatus_;
        }
        String projectPath = "/" + project.getName();
        if (location.length() == projectPath.length() && !projectPath.equals(location) || location.length() != projectPath.length() && !location.startsWith(String.valueOf(projectPath) + "/")) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_3);
            return this.currentStatus_;
        }
        String name = this.getCompositeName();
        if (name == null || name.trim().length() == 0) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_4);
            return this.currentStatus_;
        }
        if (!QNameHelpers.isValidNCName((String)name)) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_ERROR_COMPOSITE_NAME_NOT_NCNAME);
            return this.currentStatus_;
        }
        String namespace = this.getNamespace();
        if (namespace == null || namespace.trim().length() == 0) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_5);
            return this.currentStatus_;
        }
        if (!QNameHelpers.isValidNamespace((String)namespace)) {
            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_NAMESPACE_INVALID);
            return this.currentStatus_;
        }
        location = location.trim();
        name = String.valueOf(name.trim()) + ".composite";
        if (project != null && location != null && name != null) {
            this.outputContainer = (location = location.replaceFirst("/" + project.getName(), "")).length() == 0 || location.equals("/") ? project : project.getFolder(location);
            IStatus validNameStatus = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (validNameStatus.getSeverity() == 4) {
                this.currentStatus_ = validNameStatus;
                return this.currentStatus_;
            }
            IFile composite = this.outputContainer.getFile((IPath)new Path(name));
            if (composite.exists()) {
                this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_10);
                return this.currentStatus_;
            }
            if (!Workspace.caseSensitive) {
                try {
                    IResource[] iResourceArray = this.outputContainer.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getName().equalsIgnoreCase(name)) {
                            this.currentStatus_ = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_11);
                            return this.currentStatus_;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        this.currentStatus_ = Status.OK_STATUS;
        return this.currentStatus_;
    }

    public void setListener(Listener listener) {
        this.listener_ = listener;
        this.currentStatus_ = null;
    }

    public IStatus getCurrentStatus() {
        return this.currentStatus_;
    }
}

