/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.widgets;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.core.bean.implementations.Java;
import com.ibm.ccl.sca.internal.core.bean.interfaces.WSDL;
import com.ibm.ccl.sca.internal.creation.core.data.ComponentData;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class JavaImplConfigWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_NEWCOMPONENT_JAVAIMPL_CONFIG = "NEWCOMPONENT_JAVAIMPL_CONFIG";
    protected Button customizeJAXBPackageName_;
    protected Text jaxbPackageNameText_;
    protected Text implFullClassNameText_;
    private Combo sourceFolderCombo_;
    private ComponentData componentData_;
    private Listener statusListener_;
    private Button overwriteImplCheckBox_;

    public IStatus getStatus() {
        IStatus status = Status.OK_STATUS;
        if (this.customizeJAXBPackageName_ != null && this.customizeJAXBPackageName_.getSelection() && this.jaxbPackageNameText_ != null) {
            String jaxbPackageName = this.jaxbPackageNameText_.getText();
            if (jaxbPackageName == null || jaxbPackageName.length() == 0) {
                return new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_ENTER_JAVA_PACKAGE_NAME);
            }
            status = JavaConventions.validatePackageName((String)jaxbPackageName, (String)"1.5", (String)"1.5");
            if (status.getSeverity() != 0) {
                return status;
            }
        }
        String fullClassName = this.implFullClassNameText_.getText();
        String implPackageName = JavaUtil.getPackageNameFromClassName((String)fullClassName);
        String implBaseName = JavaUtil.getSimpleClassNameFromQualifiedName((String)fullClassName);
        if (fullClassName == null || fullClassName.length() == 0) {
            return new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_ETNER_JAVA_IMPL_CLASS_NAME);
        }
        status = JavaConventions.validateJavaTypeName((String)fullClassName, (String)"1.5", (String)"1.5");
        if (status.getSeverity() != 0) {
            return status;
        }
        implBaseName = String.valueOf(implBaseName) + ".java";
        status = ResourcesPlugin.getWorkspace().validateName(implBaseName, 1);
        if (status != Status.OK_STATUS) {
            return status;
        }
        if (!this.overwriteImplCheckBox_.getSelection()) {
            IPath sourceFolderPath = (IPath)this.sourceFolderCombo_.getData(this.sourceFolderCombo_.getText());
            IFolder sourceFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(sourceFolderPath);
            IFolder outputContainer = sourceFolder.getFolder(implPackageName.replace('.', '/'));
            IFile composite = outputContainer.getFile((IPath)new Path(implBaseName));
            if (composite.exists() && (status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_JAVA_CLASS_ALREADY_EXISTS)) != Status.OK_STATUS) {
                return status;
            }
            if (!Workspace.caseSensitive) {
                try {
                    IResource[] iResourceArray = outputContainer.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getName().equalsIgnoreCase(implBaseName) && (status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_JAVA_CLASS_WITH_DIFFERENT_CASE_EXISTS)) != Status.OK_STATUS) {
                            return status;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return Status.OK_STATUS;
    }

    public WidgetDataEvents addControls(Composite parentComposite, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Composite parent = uiUtils.createComposite(parentComposite, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_NEWCOMPONENT_JAVAIMPL_CONFIG);
        this.sourceFolderCombo_ = uiUtils.createCombo(parent, Messages.JavaImplConfigWidget_LABEL_OUTPUT_LOCATION, null, null, 8);
        this.implFullClassNameText_ = uiUtils.createText(parent, Messages.LABEL_IMPL_CLASS_NAME, Messages.TOOLTIP_IMPL_CLASS_NAME, null, 2052);
        this.sourceFolderCombo_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaImplConfigWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.implFullClassNameText_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                JavaImplConfigWidget.this.statusListener_.handleEvent(null);
            }
        });
        Label separator = new Label(parent, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 2;
        griddata.verticalIndent = 12;
        separator.setLayoutData((Object)griddata);
        Composite bottomComposite = uiUtils.createComposite(parentComposite, 2);
        this.overwriteImplCheckBox_ = uiUtils.createCheckbox(bottomComposite, Messages.LABEL_OVERWRITE_JAVA_IMPL, null, null);
        this.overwriteImplCheckBox_.setSelection(false);
        griddata = new GridData(768);
        griddata.horizontalSpan = 2;
        this.overwriteImplCheckBox_.setLayoutData((Object)griddata);
        this.overwriteImplCheckBox_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaImplConfigWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.customizeJAXBPackageName_ = uiUtils.createCheckbox(bottomComposite, Messages.JavaImplConfigWidget_LABEL_CUSTOMIZE_JAXB_PACKAGE0, null, null);
        this.customizeJAXBPackageName_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaImplConfigWidget.this.jaxbPackageNameText_.setEnabled(JavaImplConfigWidget.this.customizeJAXBPackageName_.getSelection());
                JavaImplConfigWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.jaxbPackageNameText_ = new Text(bottomComposite, 2048);
        griddata = new GridData(768);
        this.jaxbPackageNameText_.setLayoutData((Object)griddata);
        this.jaxbPackageNameText_.setEnabled(false);
        this.jaxbPackageNameText_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                JavaImplConfigWidget.this.statusListener_.handleEvent(null);
            }
        });
        return this;
    }

    public ComponentData getComponentData() {
        IDataBean intf = this.componentData_.getServiceInterface();
        IDataBean impl = this.componentData_.getImplementation();
        Java javaImpl = (Java)impl;
        if (this.customizeJAXBPackageName_ != null && this.customizeJAXBPackageName_.getSelection()) {
            javaImpl.setJaxbPackageName(this.jaxbPackageNameText_.getText());
        }
        String fullClassName = this.implFullClassNameText_.getText().trim();
        javaImpl.setPackageName(JavaUtil.getPackageNameFromClassName((String)fullClassName));
        javaImpl.setBaseName(JavaUtil.getSimpleClassNameFromQualifiedName((String)fullClassName));
        IPath sourceFolderPath = (IPath)this.sourceFolderCombo_.getData(this.sourceFolderCombo_.getText());
        IFolder sourceFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(sourceFolderPath);
        javaImpl.setSourceFolder(sourceFolder);
        if (intf instanceof WSDL) {
            String interfaceFullName = javaImpl.getInterfaceFullyQualifiedName();
            String interfaceBaseName = JavaUtil.getSimpleClassNameFromQualifiedName((String)interfaceFullName);
            if (javaImpl.getJaxbPackageName() == null) {
                javaImpl.setInterfaceFullyQualifiedName(String.valueOf(javaImpl.getPackageName()) + "." + interfaceBaseName);
            } else {
                javaImpl.setInterfaceFullyQualifiedName(String.valueOf(javaImpl.getJaxbPackageName()) + '.' + interfaceBaseName);
            }
        }
        return this.componentData_;
    }

    public void setComponentData(ComponentData componentData) {
        assert (componentData != null);
        this.componentData_ = componentData;
        IDataBean intf = this.componentData_.getServiceInterface();
        if (intf == null || !(intf instanceof WSDL)) {
            this.customizeJAXBPackageName_.dispose();
            this.customizeJAXBPackageName_ = null;
            this.jaxbPackageNameText_.dispose();
            this.jaxbPackageNameText_ = null;
        }
        IDataBean impl = this.componentData_.getImplementation();
        assert (impl != null && impl instanceof Java);
        if (impl instanceof Java) {
            Java javaImpl = (Java)impl;
            this.implFullClassNameText_.setText(javaImpl.getFullyQualifiedName());
        }
        IProject project = this.componentData_.getComposite().getParent();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPath = iClasspathEntryArray[n2];
                if (classPath.getEntryKind() == 3) {
                    this.sourceFolderCombo_.add(classPath.getPath().toString());
                    this.sourceFolderCombo_.setData(classPath.getPath().toString(), (Object)classPath.getPath());
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        if (this.sourceFolderCombo_.getItemCount() > 0) {
            this.sourceFolderCombo_.select(0);
        }
    }
}

