/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.widgets;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.bean.NullObject;
import com.ibm.ccl.sca.core.interfacetypes.InterfaceType;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.core.util.QNameHelpers;
import com.ibm.ccl.sca.creation.core.bean.CommandFragmentBean;
import com.ibm.ccl.sca.creation.core.bean.Config;
import com.ibm.ccl.sca.creation.core.bean.Implementation;
import com.ibm.ccl.sca.creation.core.bean.NullImplementation;
import com.ibm.ccl.sca.creation.core.bean.NullServiceInterface;
import com.ibm.ccl.sca.creation.core.bean.ReflectServiceInterface;
import com.ibm.ccl.sca.creation.core.bean.ServiceInterface;
import com.ibm.ccl.sca.creation.core.extension.store.AbstractNewComponentCommandFragmentsStore;
import com.ibm.ccl.sca.creation.core.plugin.SCACreationCorePlugin;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.extension.IDataBeanValidator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.creation.core.data.ComponentData;
import com.ibm.ccl.sca.internal.creation.ui.command.NewSCAComponentDefaultingCommand;
import com.ibm.ccl.sca.internal.creation.ui.extension.WizardConfigStore;
import com.ibm.ccl.sca.internal.creation.ui.wizards.NewCompositeWizard;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialogFactory;
import com.ibm.ccl.sca.ui.contributions.UIContributionRegistry;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import com.ibm.ccl.sca.ui.util.LabelAndId;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ComponentConfigWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_COMPONENT_CONFIG_COMPONENT = "NEWCOMPONENT_COMPONENT_CONFIG_COMPONENT";
    private String INFOPOP_COMPONENT_CONFIG_INTERFACE = "NEWCOMPONENT_COMPONENT_CONFIG_INTERFACE";
    private String INFOPOP_COMPONENT_CONFIG_IMPL = "NEWCOMPONENT_COMPONENT_CONFIG_IMPL";
    private Combo projectCombo_;
    private Combo compositeCombo_;
    private Button browseCompositeButton_;
    private Button newCompositeButton_;
    protected Text componentNameText_;
    private Combo interfaceTypeCombo_;
    private Button createInterfaceRadio_;
    private Button reuseInterfaceRadio_;
    private Text interfaceText_;
    private Button interfaceConfigureButton_;
    private Combo implTypeCombo_;
    private Button createImplRadio_;
    private Button reuseImplRadio_;
    private Text implText_;
    private Button implConfigureButton_;
    private IProject project_;
    private boolean isProjectSet_ = false;
    private ISCAComposite composite_;
    private ComponentData componentData_;
    private AbstractNewComponentCommandFragmentsStore store;
    NewSCAComponentDefaultingCommand.SELECTION_TYPE selectionType_;
    private List<ISCAProject> scaProjects_;
    List<ISCAComposite> projectCompositesList_;
    List<ISCAComposite> allCompositesList_ = null;
    SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
    private int SERVICETYPE_NO_SERVICE_INDEX;
    private int NO_IMPL_INDEX;
    private UIUtils uiUtils;
    public static final String NONE_INTERFACE = "";
    public static final String REFLECT_INTERFACE = "<Reflect from implementation>";
    public static final String NONE_IMPLEMENTATION = "";
    private UIContributionRegistry uiContributionRegistry_ = SCAToolsUIPlugin.getUIContributionRegistry();
    private ISelectionDialogFactory implementationSelectionDialogFactory_;
    private ISelectionDialogFactory serviceInterfaceSelectionDialogFactory_;
    private Map<String, Object> dataMap_;
    private int SERVICETYPE_REFLECT_SERVICE_INDEX;
    private boolean noUserInputYet = true;
    private WizardConfigStore wizardStore;
    private IProgressService progressService_;

    public ComponentConfigWidget() {
        this.store = SCACreationCorePlugin.getNewComponentCommandFragmentsStore();
        this.store.newSession();
        this.wizardStore = WizardConfigStore.getInstance();
        this.dataMap_ = new HashMap<String, Object>();
        IWorkbench wb = PlatformUI.getWorkbench();
        this.progressService_ = wb.getProgressService();
    }

    public WidgetDataEvents addControls(Composite parentComposite, Listener statusListener) {
        this.uiUtils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Composite parent = this.uiUtils.createComposite(parentComposite, 4);
        Shell shell = parent.getShell();
        this.createComponentSection(statusListener, parent, shell);
        this.createServiceInterfaceSection(statusListener, parent, shell);
        this.createImplementationSection(statusListener, parent, shell);
        return this;
    }

    private void createComponentSection(final Listener statusListener, Composite parent, final Shell shell) {
        this.projectCombo_ = this.uiUtils.createCombo(parent, Messages.LABEL_NEWCOMPONENT_PROJECT, Messages.TOOLTIP_NEWCOMPOSITE_PROJECT, null, 2048);
        new Label(parent, 0);
        new Label(parent, 0);
        this.compositeCombo_ = this.uiUtils.createCombo(parent, Messages.LABEL_COMPOSITE_NAME, Messages.TOOLTIP_COMPOSITE_NAME, null, 2056);
        this.browseCompositeButton_ = this.uiUtils.createButton(8, parent, Messages.LABEL_SELECT_COMPOSITE_ComponentConfigWidget, Messages.TOOLTIP_SELECT_COMPOSITE_ComponentConfigWidget, null);
        GridData griddata = new GridData(256);
        this.browseCompositeButton_.setLayoutData((Object)griddata);
        this.newCompositeButton_ = this.uiUtils.createButton(8, parent, Messages.LABEL_NEW_COMPOSITE_ComponentConfigWidget, null, null);
        griddata = new GridData(256);
        this.newCompositeButton_.setLayoutData((Object)griddata);
        this.projectCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ComponentConfigWidget.this.projectCombo_.getSelectionIndex();
                ISCAProject scaProject = (ISCAProject)ComponentConfigWidget.this.scaProjects_.get(selectionIndex);
                if (scaProject == null) {
                    if (ComponentConfigWidget.this.allCompositesList_ == null) {
                        ComponentConfigWidget.this.initAllComposites();
                    }
                    if (ComponentConfigWidget.this.projectCompositesList_ != null) {
                        ComponentConfigWidget.this.projectCompositesList_.clear();
                    } else {
                        ComponentConfigWidget.this.projectCompositesList_ = new ArrayList<ISCAComposite>();
                    }
                    ComponentConfigWidget.this.projectCompositesList_.addAll(ComponentConfigWidget.this.allCompositesList_);
                } else {
                    ComponentConfigWidget.this.project_ = scaProject.getProject();
                    ComponentConfigWidget.this.dataMap_.put("CURRENT_RESOURCE", ComponentConfigWidget.this.project_);
                    ComponentConfigWidget.this.projectCompositesList_ = SCAModelManager.getComposites((ISCAProject)scaProject);
                }
                ComponentConfigWidget.this.compositeCombo_.removeAll();
                int k = 0;
                while (k < ComponentConfigWidget.this.projectCompositesList_.size()) {
                    ISCAComposite curComposite = ComponentConfigWidget.this.projectCompositesList_.get(k);
                    ComponentConfigWidget.this.compositeCombo_.add(QNameHelpers.renderQName((QName)curComposite.getName()));
                    ++k;
                }
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compositeCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentConfigWidget.this.projectCompositesList_ != null && ComponentConfigWidget.this.projectCompositesList_.size() > 0 && ComponentConfigWidget.this.compositeCombo_.getSelectionIndex() >= 0) {
                    ComponentConfigWidget.this.composite_ = ComponentConfigWidget.this.projectCompositesList_.get(ComponentConfigWidget.this.compositeCombo_.getSelectionIndex());
                    ComponentConfigWidget.this.dataMap_.put("CURRENT_RESOURCE", ComponentConfigWidget.this.composite_.getResource());
                    ComponentConfigWidget.this.project_ = ComponentConfigWidget.this.composite_.getParent();
                }
                ComponentConfigWidget.this.populateImplTypes(ComponentConfigWidget.this.implTypeCombo_);
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browseCompositeButton_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithSingleSelectTree((Shell)shell);
                selectDialog.setCurrentResource((IResource)ComponentConfigWidget.this.project_);
                selectDialog.initialize();
                if (selectDialog.open() == 0) {
                    List composites = selectDialog.getSelectedComposites();
                    if (composites == null || composites.isEmpty()) {
                        return;
                    }
                    ComponentConfigWidget.this.composite_ = (ISCAComposite)composites.get(0);
                    ComponentConfigWidget.this.dataMap_.put("CURRENT_RESOURCE", ComponentConfigWidget.this.composite_.getResource());
                    ComponentConfigWidget.this.project_ = ComponentConfigWidget.this.composite_.getParent();
                    ComponentConfigWidget.this.compositeCombo_.setText(QNameHelpers.renderQName((QName)ComponentConfigWidget.this.composite_.getName()));
                    ComponentConfigWidget.this.projectCombo_.setText(ComponentConfigWidget.this.project_.getName());
                    ComponentConfigWidget.this.populateImplTypes(ComponentConfigWidget.this.implTypeCombo_);
                }
                ComponentConfigWidget.this.validatePage(statusListener);
            }
        });
        this.newCompositeButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final NewCompositeWizard wizard = new NewCompositeWizard();
                wizard.setSecondaryProcess(true);
                ISCAProject proj = null;
                if (ComponentConfigWidget.this.projectCombo_.getItemCount() > 0 && ComponentConfigWidget.this.projectCombo_.getSelectionIndex() >= 0) {
                    proj = (ISCAProject)ComponentConfigWidget.this.scaProjects_.get(ComponentConfigWidget.this.projectCombo_.getSelectionIndex());
                }
                if (proj != null) {
                    wizard.setTargetProject(proj.getProject());
                }
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int retValue = dialog.open();
                if (retValue != 0) {
                    return;
                }
                WorkspaceModifyOperation waitForNewComposite = new WorkspaceModifyOperation((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        wizard.waitUntilFinish(monitor);
                        SCAModelManager.waitForModelJobs((IProgressMonitor)monitor);
                    }
                };
                LogWriter logger = new LogWriter();
                try {
                    ComponentConfigWidget.this.progressService_.runInUI((IRunnableContext)ComponentConfigWidget.this.progressService_, (IRunnableWithProgress)waitForNewComposite, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    logger.write((Plugin)SCAToolsUIPlugin.getDefault(), 4, (Throwable)ite);
                    return;
                }
                catch (InterruptedException ie) {
                    logger.write((Plugin)SCAToolsUIPlugin.getDefault(), 8, (Throwable)ie);
                    return;
                }
                if (proj != null) {
                    ComponentConfigWidget.this.projectCompositesList_ = SCAModelManager.getComposites((ISCAProject)proj);
                } else {
                    ComponentConfigWidget.this.initAllComposites();
                    ComponentConfigWidget.this.projectCompositesList_ = new ArrayList<ISCAComposite>();
                    ComponentConfigWidget.this.projectCompositesList_.addAll(ComponentConfigWidget.this.allCompositesList_);
                }
                IPath newCompositePath = wizard.getCompositePath();
                int selectionIndex = 0;
                ComponentConfigWidget.this.compositeCombo_.removeAll();
                int k = 0;
                while (k < ComponentConfigWidget.this.projectCompositesList_.size()) {
                    ISCAComposite curComposite = ComponentConfigWidget.this.projectCompositesList_.get(k);
                    ComponentConfigWidget.this.compositeCombo_.add(QNameHelpers.renderQName((QName)curComposite.getName()));
                    if (curComposite.getResource().getFullPath().equals((Object)newCompositePath)) {
                        selectionIndex = k;
                        ComponentConfigWidget.this.project_ = curComposite.getParent();
                        ComponentConfigWidget.this.projectCombo_.setText(ComponentConfigWidget.this.project_.getName());
                        ComponentConfigWidget.this.composite_ = curComposite;
                        ComponentConfigWidget.this.dataMap_.put("CURRENT_RESOURCE", ComponentConfigWidget.this.composite_.getResource());
                    }
                    ++k;
                }
                if (ComponentConfigWidget.this.projectCompositesList_.size() > 0) {
                    ComponentConfigWidget.this.compositeCombo_.select(selectionIndex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.componentNameText_ = this.uiUtils.createText(parent, Messages.LABEL_COMPONENT_NAME, Messages.TOOLTIP_COMPONENT_NAME, this.INFOPOP_COMPONENT_CONFIG_COMPONENT, 2048);
        this.componentNameText_.forceFocus();
        this.componentNameText_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ComponentConfigWidget.this.validatePage(statusListener);
            }
        });
        new Label(parent, 0);
        new Label(parent, 0);
    }

    private void createServiceInterfaceSection(final Listener statusListener, Composite parent, final Shell shell) {
        Label serviceSeparator = new Label(parent, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 12;
        serviceSeparator.setText(Messages.LABEL_SERVICE_SETTINGS_GROUP);
        serviceSeparator.setLayoutData((Object)griddata);
        Label interfaceTypeLabel = new Label(parent, 64);
        interfaceTypeLabel.setText(Messages.LABEL_SERVICE_INTERFACE_TYPE);
        interfaceTypeLabel.setToolTipText(Messages.TOOLTIP_SERVICE_INTERFACE_TYPE);
        griddata = new GridData(256);
        griddata.verticalIndent = 12;
        interfaceTypeLabel.setLayoutData((Object)griddata);
        griddata = new GridData(768);
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 12;
        this.interfaceTypeCombo_ = new Combo(parent, 8);
        this.interfaceTypeCombo_.setLayoutData((Object)griddata);
        this.interfaceTypeCombo_.setToolTipText(Messages.TOOLTIP_SERVICE_INTERFACE_TYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.interfaceTypeCombo_, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_COMPONENT_CONFIG_INTERFACE);
        new Label(parent, 0);
        new Label(parent, 0);
        Composite interfaceRadios = this.uiUtils.createComposite(parent, 1);
        griddata = new GridData(768);
        griddata.horizontalSpan = 4;
        interfaceRadios.setLayoutData((Object)griddata);
        this.createInterfaceRadio_ = this.uiUtils.createRadioButton(interfaceRadios, Messages.RADIO_CREATE_SERVICE_INTERFACE_ComponentConfigWidget, null, null);
        this.reuseInterfaceRadio_ = this.uiUtils.createRadioButton(interfaceRadios, Messages.RADIO_REUSE_SERVICE_INTERFACE_ComponentConfigWidget, null, null);
        this.createInterfaceRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.handleInterfaceSelectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.reuseInterfaceRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.handleInterfaceSelectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite interfaceComposite = this.uiUtils.createComposite(parent, 3);
        griddata = new GridData(768);
        griddata.horizontalIndent = 20;
        griddata.horizontalSpan = 4;
        interfaceComposite.setLayoutData((Object)griddata);
        this.interfaceText_ = this.uiUtils.createText(interfaceComposite, Messages.LABEL_JAVA_INTERFACE, Messages.TOOLTIP_JAVA_INTERFACE, null, 2056);
        this.interfaceConfigureButton_ = this.uiUtils.createButton(8, interfaceComposite, Messages.LABEL_INTERFACE_SELECT_BUTTON, null, null);
        this.interfaceConfigureButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentConfigWidget.this.serviceInterfaceSelectionDialogFactory_ == null) {
                    return;
                }
                ISelectionDialog serviceInterfaceSelectionDialog_ = ComponentConfigWidget.this.serviceInterfaceSelectionDialogFactory_.createSelectionDialog(shell, ComponentConfigWidget.this.dataMap_);
                if (serviceInterfaceSelectionDialog_.open() == 0) {
                    IDataBean intf = serviceInterfaceSelectionDialog_.getDataBean();
                    ComponentConfigWidget.this.interfaceText_.setText(intf.serialize());
                    ComponentConfigWidget.this.componentData_.setServiceInterface(intf);
                }
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.interfaceTypeCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.interfaceText_.setText("");
                ComponentConfigWidget.this.componentData_.setServiceInterface(null);
                ComponentConfigWidget.this.serviceInterfaceSelectionDialogFactory_ = ComponentConfigWidget.this.uiContributionRegistry_.getInterfaceSelectionDialogFactoryById(ComponentConfigWidget.this.getSelectedIntfType());
                ComponentConfigWidget.this.handleInterfaceSectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createImplementationSection(final Listener statusListener, Composite parent, final Shell shell) {
        Label implementationSeparator = new Label(parent, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 12;
        implementationSeparator.setText(Messages.LABEL_IMPL_SETTINGS_GROUP);
        implementationSeparator.setLayoutData((Object)griddata);
        Label implTypeLabel = new Label(parent, 64);
        implTypeLabel.setText(Messages.LABEL_IMPLEMENTATION_TYPE);
        implTypeLabel.setToolTipText(Messages.TOOLTIP_IMPLEMENTATION_TYPE);
        griddata = new GridData(256);
        griddata.verticalIndent = 12;
        implTypeLabel.setLayoutData((Object)griddata);
        griddata = new GridData(768);
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 12;
        this.implTypeCombo_ = new Combo(parent, 8);
        this.implTypeCombo_.setLayoutData((Object)griddata);
        this.implTypeCombo_.setToolTipText(Messages.TOOLTIP_IMPLEMENTATION_TYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.implTypeCombo_, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_COMPONENT_CONFIG_IMPL);
        new Label(parent, 0);
        new Label(parent, 0);
        Composite implRadios = this.uiUtils.createComposite(parent, 1);
        griddata = new GridData(768);
        griddata.horizontalSpan = 4;
        implRadios.setLayoutData((Object)griddata);
        this.createImplRadio_ = this.uiUtils.createRadioButton(implRadios, Messages.RADIO_CREATE_IMPLMENTATION_ComponentConfigWidget, null, null);
        this.reuseImplRadio_ = this.uiUtils.createRadioButton(implRadios, Messages.RADIO_REUSE_IMPLEMENTATION_ComponentConfigWidget, null, null);
        this.createImplRadio_.setLayoutData((Object)griddata);
        this.reuseImplRadio_.setLayoutData((Object)griddata);
        this.createImplRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.handleImplSelectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.reuseImplRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.handleImplSelectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite implComposite = this.uiUtils.createComposite(parent, 3);
        griddata = new GridData(768);
        griddata.horizontalIndent = 20;
        griddata.horizontalSpan = 4;
        implComposite.setLayoutData((Object)griddata);
        this.implText_ = this.uiUtils.createText(implComposite, Messages.LABEL_IMPLMENTATION_NAME_ComponentConfigWidget, null, null, 2056);
        this.implConfigureButton_ = this.uiUtils.createButton(8, implComposite, Messages.BUTTON_SELECT_IMPLEMENTATION_ComponentConfigWidget, null, null);
        this.implConfigureButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentConfigWidget.this.implementationSelectionDialogFactory_ == null) {
                    return;
                }
                ISelectionDialog implementationSelectionDialog_ = ComponentConfigWidget.this.implementationSelectionDialogFactory_.createSelectionDialog(shell, ComponentConfigWidget.this.dataMap_);
                if (implementationSelectionDialog_.open() == 0) {
                    IDataBean impl = implementationSelectionDialog_.getDataBean();
                    ComponentConfigWidget.this.implText_.setText(impl.serialize());
                    ComponentConfigWidget.this.componentData_.setImplementation(impl);
                }
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.implTypeCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentConfigWidget.this.implText_.setText("");
                ComponentConfigWidget.this.implementationSelectionDialogFactory_ = ComponentConfigWidget.this.uiContributionRegistry_.getImplementationSelectionDialogFactoryById(ComponentConfigWidget.this.getSelectedImplType());
                ComponentConfigWidget.this.componentData_.setImplementation(null);
                ComponentConfigWidget.this.handleImplConfigSectionEnablement();
                ComponentConfigWidget.this.validatePage(statusListener);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleInterfaceSelectionEnablement() {
        this.interfaceConfigureButton_.setEnabled(false);
        this.interfaceText_.setEnabled(false);
        if (this.reuseInterfaceRadio_.getSelection() && this.serviceInterfaceSelectionDialogFactory_ != null) {
            this.interfaceConfigureButton_.setEnabled(true);
            this.interfaceText_.setEnabled(true);
        }
    }

    private void handleImplSelectionEnablement() {
        this.implConfigureButton_.setEnabled(false);
        this.implText_.setEnabled(false);
        if (this.reuseImplRadio_.getSelection() && this.implementationSelectionDialogFactory_ != null) {
            this.implConfigureButton_.setEnabled(true);
            this.implText_.setEnabled(true);
        }
    }

    private void handleImplConfigSectionEnablement() {
        if (this.implTypeCombo_.getSelectionIndex() == this.NO_IMPL_INDEX) {
            this.createImplRadio_.setEnabled(false);
            this.reuseImplRadio_.setEnabled(false);
        } else {
            this.createImplRadio_.setEnabled(true);
            this.reuseImplRadio_.setEnabled(true);
            if (!this.createImplRadio_.getSelection() && !this.reuseImplRadio_.getSelection()) {
                this.createImplRadio_.setSelection(true);
            }
            if (REFLECT_INTERFACE.equals(this.getSelectedIntfType())) {
                this.createImplRadio_.setSelection(false);
                this.reuseImplRadio_.setSelection(true);
            }
        }
        this.handleImplSelectionEnablement();
    }

    private void handleInterfaceSectionEnablement() {
        int selectionIndex = this.interfaceTypeCombo_.getSelectionIndex();
        if (selectionIndex == this.SERVICETYPE_NO_SERVICE_INDEX || selectionIndex == this.SERVICETYPE_REFLECT_SERVICE_INDEX) {
            this.createInterfaceRadio_.setEnabled(false);
            this.reuseInterfaceRadio_.setEnabled(false);
        } else {
            this.createInterfaceRadio_.setEnabled(true);
            this.reuseInterfaceRadio_.setEnabled(true);
            if (!this.createInterfaceRadio_.getSelection() && !this.reuseInterfaceRadio_.getSelection()) {
                this.createInterfaceRadio_.setSelection(true);
            }
        }
        this.handleInterfaceSelectionEnablement();
    }

    private void populateInterfaceTypes(Combo interfaceTypeCombo) {
        interfaceTypeCombo.removeAll();
        List types = SCAToolsCorePlugin.getInstance().getInterfaceRegistry().getInterfaceTypes();
        LabelAndId[] labelAndIds = new LabelAndId[types.size() + 2];
        String defaultId = SCAToolsCorePlugin.getInstance().getPreferences().getDefaultInterfaceTypeID(this.project_);
        int defaultIndex = -1;
        labelAndIds[0] = new LabelAndId();
        labelAndIds[0].id = "";
        labelAndIds[0].label = com.ibm.ccl.sca.ui.messages.Messages.SCAPreferencesComposite_5;
        this.SERVICETYPE_NO_SERVICE_INDEX = 0;
        labelAndIds[1] = new LabelAndId();
        labelAndIds[1].id = REFLECT_INTERFACE;
        labelAndIds[1].label = com.ibm.ccl.sca.ui.messages.Messages.LABEL_REFLECT_FROM_IMPLEMENTATION;
        this.SERVICETYPE_REFLECT_SERVICE_INDEX = 1;
        int index = 2;
        while (index < labelAndIds.length) {
            labelAndIds[index] = new LabelAndId();
            labelAndIds[index].id = ((InterfaceType)types.get(index - 2)).getId();
            labelAndIds[index].label = ((InterfaceType)types.get(index - 2)).getName();
            ++index;
        }
        index = 0;
        while (index < labelAndIds.length) {
            LabelAndId labelAndId = labelAndIds[index];
            interfaceTypeCombo.add(labelAndId.label);
            if (labelAndId.id.equals(defaultId)) {
                defaultIndex = index;
            }
            ++index;
        }
        interfaceTypeCombo.select(defaultIndex);
        interfaceTypeCombo.setData((Object)labelAndIds);
        this.serviceInterfaceSelectionDialogFactory_ = this.uiContributionRegistry_.getInterfaceSelectionDialogFactoryById(this.getSelectedIntfType());
    }

    private void populateImplTypes(Combo implTypeCombo) {
        List types = this.preferences.getEnabledImplTypes(this.project_);
        LabelAndId[] labelAndIds = null;
        String defaultId = this.preferences.getDefaultImplTypeID(this.project_);
        int defaultIndex = -1;
        labelAndIds = new LabelAndId[types.size() + 1];
        labelAndIds[0] = new LabelAndId();
        labelAndIds[0].id = "";
        labelAndIds[0].label = com.ibm.ccl.sca.ui.messages.Messages.SCAPreferencesComposite_4;
        this.NO_IMPL_INDEX = 0;
        int index = 1;
        while (index < labelAndIds.length) {
            labelAndIds[index] = new LabelAndId();
            labelAndIds[index].id = ((ImplTypeEntry)types.get(index - 1)).getID();
            labelAndIds[index].label = ((ImplTypeEntry)types.get(index - 1)).getName();
            ++index;
        }
        String selectedImplId = this.getSelectedImplType();
        boolean foundSelectedImplId = false;
        implTypeCombo.removeAll();
        int index2 = 0;
        while (index2 < labelAndIds.length) {
            LabelAndId labelAndId = labelAndIds[index2];
            implTypeCombo.add(labelAndId.label);
            if (labelAndId.id.equals(selectedImplId)) {
                defaultIndex = index2;
                foundSelectedImplId = true;
            }
            if (labelAndId.id.equals(defaultId) && !foundSelectedImplId) {
                defaultIndex = index2;
            }
            ++index2;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        implTypeCombo.select(defaultIndex);
        implTypeCombo.setData((Object)labelAndIds);
        this.implementationSelectionDialogFactory_ = this.uiContributionRegistry_.getImplementationSelectionDialogFactoryById(this.getSelectedImplType());
    }

    private void initProjectAndComposite(IProject project) {
        this.projectCombo_.removeAll();
        try {
            int i = 0;
            int selectionIndex = 0;
            this.scaProjects_ = SCAModelUtil.getSCAProjectsList();
            this.scaProjects_.add(0, null);
            this.projectCombo_.add(Messages.LABEL_ALL_PROJECTS_ComponentConfigWidget);
            if (project == null) {
                selectionIndex = 0;
            }
            ++i;
            while (i < this.scaProjects_.size()) {
                ISCAProject scaProject = this.scaProjects_.get(i);
                String projectName = scaProject.getProject().getName();
                this.projectCombo_.add(projectName);
                if (project != null && projectName.equals(project.getName())) {
                    selectionIndex = i;
                }
                ++i;
            }
            this.projectCombo_.select(selectionIndex);
            ISCAComposite selectedComposite = this.componentData_.getComposite() != null ? this.componentData_.getComposite() : null;
            int compositeIndex = 0;
            ISCAProject selectedProject = this.scaProjects_.get(selectionIndex);
            if (selectedProject == null) {
                if (this.allCompositesList_ == null) {
                    this.initAllComposites();
                }
                if (this.projectCompositesList_ != null) {
                    this.projectCompositesList_.clear();
                } else {
                    this.projectCompositesList_ = new ArrayList<ISCAComposite>();
                }
                this.projectCompositesList_.addAll(this.allCompositesList_);
            } else {
                this.projectCompositesList_ = SCAModelManager.getComposites((ISCAProject)selectedProject);
                this.dataMap_.put("CURRENT_RESOURCE", selectedProject.getProject());
            }
            this.compositeCombo_.removeAll();
            int k = 0;
            while (k < this.projectCompositesList_.size()) {
                ISCAComposite curComposite = this.projectCompositesList_.get(k);
                this.compositeCombo_.add(QNameHelpers.renderQName((QName)curComposite.getName()));
                if (selectedComposite != null && selectedComposite.getName().equals(curComposite.getName())) {
                    compositeIndex = k;
                }
                ++k;
            }
            if (selectedComposite != null) {
                this.compositeCombo_.select(compositeIndex);
            }
        }
        catch (CoreException e) {
            IStatus errStatus = StatusUtils.errorStatus((String)Messages.ERROR_FAILS_TO_GET_SCA_PROJECT_LIST_ComponentConfigWidget, (Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
        }
    }

    private void initAllComposites() {
        this.allCompositesList_ = new ArrayList<ISCAComposite>();
        for (ISCAProject scaProject : SCAModelManager.getLoadedProjects()) {
            this.allCompositesList_.addAll(SCAModelManager.getComposites((ISCAProject)scaProject));
        }
    }

    private String getErrorMessage() {
        String intfID = this.getSelectedIntfType();
        String implID = this.getSelectedImplType();
        String intfName = this.getSelectedIntfName();
        String implName = this.getSelectedImplName();
        Config intfConfig = this.getInterfaceConfig();
        Config implConfig = this.getImplConfig();
        if ("".equals(intfID)) {
            if (implConfig == Config.CREATE && implName != null && implName.length() != 0) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG0, (Object)implName);
            }
            if (implConfig == Config.REUSE && implName != null && implName.length() != 0) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG1, (Object)implName);
            }
        }
        if (REFLECT_INTERFACE.equals(intfID)) {
            if (implConfig == Config.CREATE || "".equals(implID)) {
                return Messages.ComponentConfigWidget_ERROR_CONFIG2;
            }
            if (implConfig == Config.REUSE && implName != null && implName.length() != 0) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG3, (Object)implName);
            }
        }
        if ("".equals(implID)) {
            if (intfConfig == Config.CREATE && intfName != null && intfName.length() != 0) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG4, (Object)intfName);
            }
            if (intfConfig == Config.REUSE && intfName != null && intfName.length() != 0) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG5, (Object)intfName);
            }
        }
        if (implName != null && implName.length() != 0 && intfName != null && intfName.length() != 0) {
            if (intfConfig == Config.CREATE && implConfig == Config.CREATE) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG6, (Object[])new String[]{intfName, implName});
            }
            if (intfConfig == Config.CREATE && implConfig == Config.REUSE) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG7, (Object[])new String[]{intfName, implName});
            }
            if (intfConfig == Config.REUSE && implConfig == Config.CREATE) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG8, (Object[])new String[]{intfName, implName});
            }
            if (intfConfig == Config.REUSE && implConfig == Config.REUSE) {
                return Messages.bind((String)Messages.ComponentConfigWidget_ERROR_CONFIG9, (Object[])new String[]{intfName, implName});
            }
        }
        return Messages.ERROR_UNSUPPORTED_CONFIG_INTERFACE_AND_IMPL;
    }

    public IStatus getStatus() {
        CommandFragmentBean[] fragments;
        IStatus validatorStatus;
        String componentName;
        Status status = null;
        if (this.compositeCombo_.getText() == null || this.compositeCombo_.getText().trim().length() == 0) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_NO_TARGET_COMPOSITE_ComponentConfigWidget);
        }
        if ((componentName = this.componentNameText_.getText()) == null || componentName.trim().length() == 0) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_NO_COMPONENT_NAME_ComponentConfigWidget);
        } else if (!QNameHelpers.isValidNCName((String)componentName)) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_COMPONENT_NAME_NOT_NCNAME);
        }
        if (this.implTypeCombo_.getSelectionIndex() != this.NO_IMPL_INDEX && this.reuseImplRadio_.getSelection()) {
            IDataBean impl = this.componentData_.getImplementation();
            if (impl == null) {
                status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_NO_IMPL_ComponentConfigWidget);
            } else {
                IDataBeanValidator implValidator = this.wizardStore.getImplementationValidator(impl.getID());
                if (implValidator != null) {
                    implValidator.setProperty("com.ibm.ccl.sca.creation.ui.CURRENT_PROJECT", this.project_);
                    validatorStatus = implValidator.validate(impl);
                    if (!validatorStatus.isOK()) {
                        status = validatorStatus;
                    }
                }
            }
        }
        if (this.interfaceTypeCombo_.getSelectionIndex() != this.SERVICETYPE_NO_SERVICE_INDEX && this.interfaceTypeCombo_.getSelectionIndex() != this.SERVICETYPE_REFLECT_SERVICE_INDEX) {
            IDataBeanValidator intfValidator;
            if (this.reuseInterfaceRadio_.getSelection() && this.componentData_.getServiceInterface() == null) {
                status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_NO_SERVICE_INTERFACE_ComponentConfigWidget);
            }
            IDataBean intf = this.componentData_.getServiceInterface();
            if (this.reuseInterfaceRadio_.getSelection() && intf != null && (intfValidator = this.wizardStore.getServiceInterfaceValidator(intf.getID())) != null) {
                intfValidator.setProperty("com.ibm.ccl.sca.creation.ui.CURRENT_PROJECT", this.project_);
                validatorStatus = intfValidator.validate(intf);
                if (!validatorStatus.isOK()) {
                    status = validatorStatus;
                }
            }
        }
        if (this.composite_ != null) {
            for (String existingName : this.composite_.getComponents()) {
                if (!existingName.equals(componentName)) continue;
                status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ComponentConfigWidget_ERROR_COMPONENT_EXISTS);
                break;
            }
        }
        if ((fragments = this.getCommandFragments()) == null || fragments.length == 0) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", this.getErrorMessage());
        }
        if (fragments != null && fragments.length > 1) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_MORE_THAN_ONE_POSSIBLE_PATH);
        }
        if (status != null && status.getSeverity() == 4 && this.noUserInputYet) {
            return new Status(4, "com.ibm.ccl.sca.creation.ui", "");
        }
        return status;
    }

    private String getSelectedImplName() {
        int index = this.implTypeCombo_.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.implTypeCombo_.getData();
        if (index < 0) {
            return null;
        }
        return labelAndIds[index].label;
    }

    private String getSelectedIntfName() {
        int index = this.interfaceTypeCombo_.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.interfaceTypeCombo_.getData();
        if (index < 0) {
            return null;
        }
        return labelAndIds[index].label;
    }

    private String getSelectedImplType() {
        int index = this.implTypeCombo_.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.implTypeCombo_.getData();
        if (index < 0) {
            return null;
        }
        return labelAndIds[index].id;
    }

    private String getSelectedIntfType() {
        int index = this.interfaceTypeCombo_.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.interfaceTypeCombo_.getData();
        if (index < 0) {
            return null;
        }
        return labelAndIds[index].id;
    }

    private Config getInterfaceConfig() {
        if (!this.createInterfaceRadio_.getSelection() && !this.reuseInterfaceRadio_.getSelection()) {
            return null;
        }
        if (this.createInterfaceRadio_.getSelection()) {
            return Config.CREATE;
        }
        return Config.REUSE;
    }

    private Config getImplConfig() {
        if (!this.createImplRadio_.getSelection() && !this.reuseImplRadio_.getSelection()) {
            return null;
        }
        if (this.createImplRadio_.getSelection()) {
            return Config.CREATE;
        }
        return Config.REUSE;
    }

    private void selectIntfOrImplCombo(Combo combo, String id) {
        LabelAndId[] labelAndIds = (LabelAndId[])combo.getData();
        if (id == null) {
            combo.select(0);
            return;
        }
        int sel = 0;
        int i = 0;
        while (i < labelAndIds.length) {
            if (labelAndIds[i].id.equals(id)) {
                sel = i;
                break;
            }
            ++i;
        }
        combo.select(sel);
    }

    public IProject getProject() {
        return this.project_;
    }

    public void setProject(IProject project_) {
        this.project_ = project_;
        this.isProjectSet_ = true;
        this.init();
    }

    public CommandFragmentBean getCommandFragment() {
        CommandFragmentBean[] fragments = this.getCommandFragments();
        assert (fragments.length == 1);
        return fragments[0];
    }

    private CommandFragmentBean[] getCommandFragments() {
        String intfID = this.getSelectedIntfType();
        String implID = this.getSelectedImplType();
        Object intf = null;
        intf = "".equals(intfID) ? new NullServiceInterface() : (REFLECT_INTERFACE.equals(intfID) ? new ReflectServiceInterface() : new ServiceInterface(intfID, this.getInterfaceConfig()));
        Object impl = null;
        impl = "".equals(implID) ? new NullImplementation() : new Implementation(implID, this.getImplConfig());
        return this.store.getCommandFragments((ServiceInterface)intf, (Implementation)impl);
    }

    public ComponentData getComponentData() {
        String selectedImplId;
        String selectedIntfId;
        this.componentData_.setComposite(this.composite_);
        this.componentData_.setComponentName(this.componentNameText_.getText());
        IDataBean intf = this.componentData_.getServiceInterface();
        if (intf != null) {
            String serviceName = intf.getDefaultServiceName();
            this.componentData_.setServiceName(serviceName);
        }
        if ((selectedIntfId = this.getSelectedIntfType()) == null || selectedIntfId.equals("")) {
            this.componentData_.setServiceInterface((IDataBean)new NullObject());
        }
        if ((selectedImplId = this.getSelectedImplType()) == null || selectedImplId.equals("")) {
            this.componentData_.setImplementation((IDataBean)new NullObject());
        }
        return this.componentData_;
    }

    public void setComponentData(ComponentData componentData) {
        this.componentData_ = componentData;
        if (this.componentData_ == null) {
            this.componentData_ = new ComponentData();
        } else {
            this.composite_ = this.componentData_.getComposite();
            if (this.composite_ != null) {
                this.dataMap_.put("CURRENT_RESOURCE", this.composite_.getResource());
            }
        }
        this.init();
    }

    private void init() {
        if (this.isProjectSet_ && this.componentData_ != null && this.selectionType_ != null) {
            this.initProjectAndComposite(this.project_);
            this.populateInterfaceTypes(this.interfaceTypeCombo_);
            this.populateImplTypes(this.implTypeCombo_);
            this.initSelection();
        }
    }

    public void setSelectionType(NewSCAComponentDefaultingCommand.SELECTION_TYPE selectionType) {
        this.selectionType_ = selectionType;
        this.init();
    }

    private void initSelection() {
        IDataBean impl;
        IDataBean intf = this.componentData_.getServiceInterface();
        if (intf != null) {
            this.interfaceText_.setText(intf.serialize());
            this.reuseInterfaceRadio_.setSelection(true);
            this.selectIntfOrImplCombo(this.interfaceTypeCombo_, intf.getID());
            this.serviceInterfaceSelectionDialogFactory_ = this.uiContributionRegistry_.getInterfaceSelectionDialogFactoryById(intf.getID());
        }
        if ((impl = this.componentData_.getImplementation()) != null) {
            this.implText_.setText(impl.serialize());
            this.reuseImplRadio_.setSelection(true);
            this.selectIntfOrImplCombo(this.implTypeCombo_, impl.getID());
            this.implementationSelectionDialogFactory_ = this.uiContributionRegistry_.getImplementationSelectionDialogFactoryById(impl.getID());
        }
        this.handleInterfaceSectionEnablement();
        this.handleImplConfigSectionEnablement();
    }

    private void validatePage(Listener statusListener) {
        this.noUserInputYet = false;
        statusListener.handleEvent(null);
    }
}

