/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.dialogs;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.creation.ui.dialogs.RefreshComponentContentProvider;
import com.ibm.ccl.sca.internal.creation.ui.dialogs.RefreshComponentLabelProvider;
import com.ibm.ccl.sca.internal.creation.ui.dialogs.ServiceReferenceDeltaAnalyzer;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RefreshComponentDialog
extends TitleAreaDialog {
    private static final String INFOPOP_REFRESH_COMPONENT_DIALOG = "com.ibm.ccl.sca.creation.ui.REFRESH_COMPONENT_DIALOG";
    private ISCAComposite composite;
    private String componentName;
    private CheckboxTreeViewer viewer;
    private ServiceReferenceDeltaAnalyzer analyzer;
    private IStatus status;
    private List<ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta<?>> checkedReplaceDelta;
    private Set<ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta<?>> changeServices;
    private Set<ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta<?>> changeReferences;

    public RefreshComponentDialog(Shell shell, ISCAComposite composite, String componentName) {
        super(shell);
        this.composite = composite;
        this.componentName = componentName;
        this.checkedReplaceDelta = new ArrayList();
        this.changeServices = new HashSet();
        this.changeReferences = new HashSet();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LABEL_REFRESH_COMPONENT_DIALOG_TITLE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, INFOPOP_REFRESH_COMPONENT_DIALOG);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.RefreshComponentDialog_SECOND_TITLE);
        this.setMessage(Messages.LABEL_REFRESH_COMPONENT_SELECT_UPDATE);
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Text text = utils.createText(utils.createComposite(comp, 2), Messages.LABEL_REFRESH_COMPONENT_NAME, null, null, 2048);
        text.setEditable(false);
        text.setText(this.componentName);
        Composite content = utils.createComposite(comp, 1);
        content.setLayoutData((Object)new GridData(1808));
        this.analyzer = new ServiceReferenceDeltaAnalyzer(this.composite, this.componentName);
        this.status = this.analyzer.init();
        if (!this.status.isOK()) {
            int type = 1;
            if (this.status.getSeverity() == 2) {
                type = 2;
            } else if (this.status.getSeverity() == 4) {
                type = 3;
            }
            this.setMessage(this.status.getMessage(), type);
        }
        this.viewer = new CheckboxTreeViewer(content, 2048);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        if (this.status.isOK()) {
            this.viewer.setContentProvider((IContentProvider)new RefreshComponentContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new RefreshComponentLabelProvider());
            this.viewer.setInput((Object)this.analyzer);
            this.viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    RefreshComponentDialog.this.handleChecking(event.getElement(), event.getChecked());
                    RefreshComponentDialog.this.getButton(0).setEnabled(RefreshComponentDialog.this.viewer.getCheckedElements().length != 0);
                }
            });
            this.viewer.expandAll();
            this.viewer.setSubtreeChecked((Object)RefreshComponentContentProvider.SERVICES_ROOT, true);
            this.viewer.setSubtreeChecked((Object)RefreshComponentContentProvider.REFERENCES_ROOT, true);
            Object[] objectArray = this.viewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta checkedDelta;
                Object checked = objectArray[n2];
                if (checked instanceof ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta && (checkedDelta = (ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta)checked).getKind() == ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta.Kind.CHANGE) {
                    this.viewer.setChecked(checked, false);
                    this.handleChecking(checked, false);
                    if (checkedDelta.get() instanceof ComponentService) {
                        this.changeServices.add(checkedDelta);
                    }
                    if (checkedDelta.get() instanceof ComponentReference) {
                        this.changeReferences.add(checkedDelta);
                    }
                }
                ++n2;
            }
        }
        return comp;
    }

    private void handleChecking(Object source, boolean checked) {
        if (source instanceof String) {
            this.viewer.setGrayChecked(source, false);
            this.viewer.setSubtreeChecked(source, checked);
            String label = (String)source;
            if (RefreshComponentContentProvider.SERVICES_ROOT.equals(label)) {
                if (checked) {
                    this.checkedReplaceDelta.addAll(this.changeServices);
                } else {
                    this.checkedReplaceDelta.removeAll(this.changeServices);
                }
            }
            if (RefreshComponentContentProvider.REFERENCES_ROOT.equals(label)) {
                if (checked) {
                    this.checkedReplaceDelta.addAll(this.changeReferences);
                } else {
                    this.checkedReplaceDelta.removeAll(this.changeReferences);
                }
            }
        } else {
            ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta checkedDelta;
            ITreeContentProvider provider = (ITreeContentProvider)this.viewer.getContentProvider();
            Object parent = provider.getParent(source);
            Object[] children = provider.getChildren(parent);
            boolean grayChecked = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.viewer.getChecked(child) != checked) {
                    grayChecked = true;
                    break;
                }
                ++n2;
            }
            this.viewer.setGrayChecked(parent, grayChecked);
            if (!grayChecked) {
                this.viewer.setChecked(parent, checked);
            }
            if (source instanceof ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta && (checkedDelta = (ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta)source).getKind() == ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta.Kind.CHANGE) {
                if (checked) {
                    this.checkedReplaceDelta.add(checkedDelta);
                } else {
                    this.checkedReplaceDelta.remove(checkedDelta);
                }
            }
        }
        if (this.checkedReplaceDelta.size() > 0) {
            String items = "";
            int count = 0;
            for (ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta<?> delta : this.checkedReplaceDelta) {
                if (count > 3) {
                    items = String.valueOf(items) + ", ...";
                    break;
                }
                String name = delta.getName();
                items = items.length() > 0 ? String.valueOf(items) + ", " + name : String.valueOf(items) + name;
                ++count;
            }
            this.setMessage(Messages.bind((String)Messages.RefreshComponentDialog_WARNING_REPLACE_ITEMS, (Object)items), 2);
        } else {
            this.setMessage(Messages.LABEL_REFRESH_COMPONENT_SELECT_UPDATE);
        }
    }

    public void create() {
        super.create();
        if (!this.status.isOK() || this.viewer.getCheckedElements().length == 0) {
            this.getButton(0).setEnabled(false);
        }
        Point size = this.getShell().computeSize(400, 500);
        this.getShell().setSize(size);
    }

    protected void okPressed() {
        this.status = this.analyzer.performUpdate(this.viewer.getCheckedElements());
        super.close();
    }

    public IStatus getStatus() {
        return this.status;
    }
}

