/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.dialogs;

import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.creation.ui.dialogs.ServiceReferenceDeltaAnalyzer;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RefreshComponentContentProvider
implements ITreeContentProvider {
    public static final String SERVICES_ROOT = Messages.LABEL_REFRESH_COMPONENT_SERVICES;
    public static final String REFERENCES_ROOT = Messages.LABEL_REFRESH_COMPONENT_REFERENCES;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private ServiceReferenceDeltaAnalyzer analyzer;

    public Object[] getElements(Object inputElement) {
        ArrayList<String> rootElements = new ArrayList<String>(2);
        if (!this.analyzer.getServiceDeltas().isEmpty()) {
            rootElements.add(SERVICES_ROOT);
        }
        if (!this.analyzer.getReferenceDeltas().isEmpty()) {
            rootElements.add(REFERENCES_ROOT);
        }
        return rootElements.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta) {
            ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta delta = (ServiceReferenceDeltaAnalyzer.ServiceReferenceDelta)element;
            if (this.analyzer.isService(delta)) {
                return SERVICES_ROOT;
            }
            return REFERENCES_ROOT;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element.equals(SERVICES_ROOT)) {
            return !this.analyzer.getServiceDeltas().isEmpty();
        }
        if (element.equals(REFERENCES_ROOT)) {
            return !this.analyzer.getReferenceDeltas().isEmpty();
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement.equals(SERVICES_ROOT)) {
            return this.analyzer.getServiceDeltas().toArray();
        }
        if (parentElement.equals(REFERENCES_ROOT)) {
            return this.analyzer.getReferenceDeltas().toArray();
        }
        return EMPTY_ARRAY;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.analyzer = (ServiceReferenceDeltaAnalyzer)newInput;
    }

    public void dispose() {
    }
}

