/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.command;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.bean.NullObject;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import com.ibm.ccl.sca.core.util.QNameHelpers;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.core.bean.interfaces.Java;
import com.ibm.ccl.sca.internal.core.bean.interfaces.WSDL;
import com.ibm.ccl.sca.internal.creation.ui.command.RecognitionException;
import com.ibm.ccl.sca.wsdl.core.model.ISCAWsdlInterface;
import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class RecognizeInterfaceCommand {
    public static IDataBean recognize(ISCAComposite composite, ComponentService service) throws RecognitionException {
        if (service == null) {
            return new NullObject();
        }
        InterfaceContract intfContract = service.getInterfaceContract();
        if (intfContract == null) {
            return null;
        }
        Interface intf = intfContract.getInterface();
        if (intf instanceof JavaInterface) {
            JavaInterface javaIntf = (JavaInterface)intf;
            String qualifiedClassName = javaIntf.getName();
            IJavaProject javaProject = JavaCore.create((IProject)composite.getParent());
            IType javaType = null;
            try {
                javaType = javaProject.findType(qualifiedClassName);
            }
            catch (JavaModelException javaModelException) {}
            if (javaType == null) {
                Status status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.bind((String)Messages.ERROR_REGEN_COMPONENT_IMPL_JAVA_NOT_FOUND, (Object[])new String[]{qualifiedClassName, service.getName()}));
                throw new RecognitionException(status.getMessage(), (IStatus)status);
            }
            Java java = new Java();
            java.setType(javaType, true);
            return java;
        }
        if (intf instanceof WSDLInterface) {
            WSDLInterface wsdlIntf = (WSDLInterface)intf;
            QName name = wsdlIntf.getName();
            WSDL wsdl = new WSDL();
            wsdl.setPortType(name);
            SCAModelResolver resolver = new SCAModelResolver(composite);
            try {
                resolver.run(null);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            List artifacts = resolver.getArtifacts();
            if (artifacts == null || artifacts.isEmpty()) {
                return null;
            }
            boolean foundWSDL = false;
            for (ISCAArtifact artifact : artifacts) {
                if (!(artifact instanceof ISCAWsdlInterface)) continue;
                ISCAWsdlInterface wsdlArtifact = (ISCAWsdlInterface)artifact;
                IResource wsdlResource = wsdlArtifact.getResource();
                URI wsdlURI = wsdlResource.getLocation().toFile().toURI();
                wsdl.setWsdlURI(wsdlURI);
                wsdl.setPath(wsdlResource.getFullPath());
                foundWSDL = true;
                break;
            }
            if (!foundWSDL) {
                Status status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.bind((String)Messages.ERROR_REGEN_COMPONENT_IMPL_WSDL_NOT_FOUND, (Object[])new String[]{QNameHelpers.renderQName((QName)name), service.getName()}));
                throw new RecognitionException(status.getMessage(), (IStatus)status);
            }
            return wsdl;
        }
        return null;
    }
}

