/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.command;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.core.bean.interfaces.Java;
import com.ibm.ccl.sca.internal.core.bean.interfaces.WSDL;
import com.ibm.ccl.sca.internal.creation.core.data.ComponentData;
import com.ibm.ccl.sca.internal.creation.core.util.WsdlUtils;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class NewSCAComponentDefaultingCommand
extends AbstractDataModelOperation {
    private IStructuredSelection selection_;
    private Definition definition_;
    private IProject project_;
    private URI wsdlURI_;
    private ComponentData componentData_ = new ComponentData();
    SELECTION_TYPE selectionType_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!(this.selection_ instanceof TreeSelection)) {
            this.selectionType_ = SELECTION_TYPE.OTHER;
            return Status.OK_STATUS;
        }
        Object element = ((TreeSelection)this.selection_).getFirstElement();
        if (element instanceof IType) {
            IType javaType = (IType)element;
            try {
                if (javaType.isInterface()) {
                    this.selectionType_ = SELECTION_TYPE.JAVA_INTERFACE;
                    Java javaIntf = new Java();
                    javaIntf.setType(javaType, true);
                    this.componentData_.setServiceInterface((IDataBean)javaIntf);
                } else {
                    this.selectionType_ = SELECTION_TYPE.JAVA_CLASS;
                    com.ibm.ccl.sca.internal.core.bean.implementations.Java javaImpl = new com.ibm.ccl.sca.internal.core.bean.implementations.Java();
                    javaImpl.setType(javaType, true);
                    this.componentData_.setImplementation((IDataBean)javaImpl);
                }
                this.project_ = javaType.getJavaProject().getProject();
                return Status.OK_STATUS;
            }
            catch (JavaModelException javaModelException) {
                IStatus errStatus = StatusUtil.errorStatus((String)Messages.MSG_ERROR_JAVA_MODELEXCEPTION);
                Activator.getDefault().getLog().log(errStatus);
                return errStatus;
            }
        }
        if (element instanceof ICompilationUnit) {
            try {
                ICompilationUnit icu = (ICompilationUnit)element;
                IType javaType = icu.getTypes()[0];
                if (javaType.isInterface()) {
                    this.selectionType_ = SELECTION_TYPE.JAVA_INTERFACE;
                    Java javaIntf = new Java();
                    javaIntf.setType(javaType, true);
                    this.componentData_.setServiceInterface((IDataBean)javaIntf);
                } else {
                    this.selectionType_ = SELECTION_TYPE.JAVA_CLASS;
                    com.ibm.ccl.sca.internal.core.bean.implementations.Java javaImpl = new com.ibm.ccl.sca.internal.core.bean.implementations.Java();
                    javaImpl.setType(javaType, true);
                    this.componentData_.setImplementation((IDataBean)javaImpl);
                }
                this.project_ = javaType.getJavaProject().getProject();
                return Status.OK_STATUS;
            }
            catch (JavaModelException javaModelException) {
                IStatus errStatus = StatusUtil.errorStatus((String)Messages.MSG_ERROR_JAVA_MODELEXCEPTION);
                Activator.getDefault().getLog().log(errStatus);
                return errStatus;
            }
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            this.project_ = file.getProject();
            if (file.getName().endsWith(".wsdl")) {
                try {
                    this.wsdlURI_ = file.getLocationURI();
                    this.definition_ = WsdlUtils.loadWSDL((String)this.wsdlURI_.toString());
                }
                catch (IOException e) {
                    this.selectionType_ = SELECTION_TYPE.OTHER;
                    IStatus errStatus = StatusUtil.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_CANNOT_LOAD_WSDL, (Object)file.getLocation()), (Throwable)e);
                    Activator.getDefault().getLog().log(errStatus);
                    return errStatus;
                }
                this.selectionType_ = SELECTION_TYPE.WSDL_DOCUMENT;
                WSDL wsdlIntf = new WSDL();
                wsdlIntf.setWsdlURI(this.wsdlURI_);
                this.componentData_.setServiceInterface((IDataBean)wsdlIntf);
                EList ptList = this.definition_.getEPortTypes();
                if (ptList.size() >= 1) {
                    PortType pt = (PortType)ptList.get(0);
                    wsdlIntf.setPortType(pt.getQName());
                    return Status.OK_STATUS;
                }
                IStatus errStatus = StatusUtil.errorStatus((String)Messages.MSG_ERROR_CANNOT_LOAD_WSDL);
                Activator.getDefault().getLog().log(errStatus);
                return errStatus;
            }
            if (file.getName().endsWith(".composite")) {
                ISCAComposite artifact = (ISCAComposite)file.getAdapter(ISCAArtifact.class);
                this.componentData_.setComposite(artifact);
                this.selectionType_ = SELECTION_TYPE.SCA_COMPOSITE;
                return Status.OK_STATUS;
            }
            this.selectionType_ = SELECTION_TYPE.OTHER;
            return Status.OK_STATUS;
        }
        if (element instanceof ISCAArtifact) {
            if (element instanceof ISCAComposite) {
                ISCAComposite artifact = (ISCAComposite)element;
                this.componentData_.setComposite(artifact);
                this.selectionType_ = SELECTION_TYPE.SCA_COMPOSITE;
                this.project_ = artifact.getParent();
                return Status.OK_STATUS;
            }
            ISCAArtifact artifact = (ISCAArtifact)element;
            this.selectionType_ = SELECTION_TYPE.OTHER;
            this.project_ = artifact.getParent();
            return Status.OK_STATUS;
        }
        if (element instanceof ISCANode) {
            ISCANode node = (ISCANode)element;
            if (node instanceof ComponentNode) {
                this.componentData_.setComposite((ISCAComposite)node.getParent());
                this.selectionType_ = SELECTION_TYPE.SCA_COMPONENT;
            } else {
                this.selectionType_ = SELECTION_TYPE.OTHER;
            }
            this.project_ = node.getProject();
            return Status.OK_STATUS;
        }
        if (!(element instanceof IProject)) {
            this.selectionType_ = SELECTION_TYPE.OTHER;
            return Status.OK_STATUS;
        }
        IProject p = (IProject)element;
        if (this.isSCAProject(p)) {
            this.selectionType_ = SELECTION_TYPE.SCA_PROJECT;
            this.project_ = p;
            return Status.OK_STATUS;
        }
        this.selectionType_ = SELECTION_TYPE.OTHER;
        return Status.OK_STATUS;
    }

    private boolean isSCAProject(IProject project) {
        try {
            IProjectFacet facet;
            IFacetedProject facetProj = ProjectFacetsManager.create((IProject)project, (boolean)false, null);
            if (facetProj != null && facetProj.hasProjectFacet(facet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.ccl.sca"))) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IStructuredSelection getInitialSelection() {
        return this.selection_;
    }

    public SELECTION_TYPE getSelectionType() {
        return this.selectionType_;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.selection_ = initialSelection;
    }

    public IProject getProject() {
        return this.project_;
    }

    public ComponentData getComponentData() {
        return this.componentData_;
    }

    public static enum SELECTION_TYPE {
        JAVA_INTERFACE,
        JAVA_CLASS,
        WSDL_DOCUMENT,
        SCA_PROJECT,
        SCA_COMPOSITE,
        SCA_COMPONENT,
        OTHER;

    }
}

