/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class ScaMatchingStrategy
implements IEditorMatchingStrategy {
    private static final String DIAGRAM_SUFFIX = "_diagram";

    private boolean matchInputFiles(IFile input1, IFile input2) {
        String path2;
        String path1 = input1.getFullPath().toString();
        if (!path1.endsWith(DIAGRAM_SUFFIX)) {
            path1 = String.valueOf(path1) + DIAGRAM_SUFFIX;
        }
        if (!(path2 = input2.getFullPath().toString()).endsWith(DIAGRAM_SUFFIX)) {
            path2 = String.valueOf(path2) + DIAGRAM_SUFFIX;
        }
        return path1.equals(path2);
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        try {
            editorInput = editorRef.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return false;
        }
        if (editorInput.equals(input)) {
            return true;
        }
        if (editorInput instanceof URIEditorInput && input instanceof URIEditorInput) {
            return ((URIEditorInput)editorInput).getURI().equals((Object)((URIEditorInput)input).getURI());
        }
        if (editorInput instanceof FileEditorInput && input instanceof FileEditorInput) {
            return this.matchInputFiles(((FileEditorInput)editorInput).getFile(), ((FileEditorInput)input).getFile());
        }
        return false;
    }
}

