/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.util.EcoreEMap;

public class SCANameUtil {
    public static String getUniquePrefixForNamespace(EMap map, String prefix, String ns) {
        int count = 1;
        while (map.get((Object)prefix) != null) {
            prefix = String.valueOf(prefix) + Integer.toString(count);
            ++count;
        }
        return prefix;
    }

    public static boolean namespaceExists(EMap map, String ns) {
        for (String item : map.values()) {
            if (!item.equals(ns)) continue;
            return true;
        }
        return false;
    }

    public static String getNamespacePrefix(EMap map, String ns) {
        for (String key : map.keySet()) {
            String item = (String)map.get((Object)key);
            if (!item.equals(ns)) continue;
            return key;
        }
        return null;
    }

    public static String getUniqueCompositeServiceName(Composite composite, String baseName) {
        Iterator it = composite.getService().iterator();
        return SCANameUtil.getUniqueName(SCANameUtil.getServiceNames(it), baseName);
    }

    public static String getUniqueCompositeReferenceName(Composite composite, String baseName) {
        Iterator it = composite.getReference().iterator();
        return SCANameUtil.getUniqueName(SCANameUtil.getReferenceNames(it), baseName);
    }

    public static String getUniqueComponentServiceName(Component component, String baseName) {
        Iterator it = component.getService().iterator();
        return SCANameUtil.getUniqueName(SCANameUtil.getComponentServiceNames(it), baseName);
    }

    public static String getUniqueComponentReferenceName(Component component, String baseName) {
        Iterator it = component.getReference().iterator();
        return SCANameUtil.getUniqueName(SCANameUtil.getComponentReferenceNames(it), baseName);
    }

    public static String getUniqueComponentName(Composite composite, String baseName) {
        Iterator it = composite.getComponent().iterator();
        ArrayList<String> existingNames = new ArrayList<String>();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            existingNames.add(component.getName());
        }
        return SCANameUtil.getUniqueName(existingNames, baseName);
    }

    private static List getServiceNames(Iterator<Service> it) {
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            Service service = it.next();
            names.add(service.getName());
        }
        return names;
    }

    private static List getComponentServiceNames(Iterator<ComponentService> it) {
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            ComponentService service = it.next();
            names.add(service.getName());
        }
        return names;
    }

    private static List getReferenceNames(Iterator<Reference> it) {
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            Reference reference = it.next();
            names.add(reference.getName());
        }
        return names;
    }

    private static List getComponentReferenceNames(Iterator<ComponentReference> it) {
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            ComponentReference reference = it.next();
            names.add(reference.getName());
        }
        return names;
    }

    public static String getUniqueName(List<String> existingNames, String baseName) {
        String newName = baseName;
        int index = 1;
        boolean exists = existingNames.contains(baseName);
        while (exists) {
            newName = String.valueOf(baseName) + String.valueOf(index);
            ++index;
            exists = existingNames.contains(newName);
        }
        return newName;
    }

    public static String getQNameString(QName qName) {
        String local = qName.getLocalPart();
        String prefix = qName.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            return String.valueOf(prefix) + ":" + local;
        }
        return local;
    }

    public static QName getQName(String text, EcoreEMap prefixNsMap) {
        String local = "";
        String prefix = null;
        String ns = null;
        int i = text.indexOf(":");
        if (i > 0) {
            prefix = text.substring(0, i);
            local = text.substring(i + 1, text.length());
        } else {
            local = i == 0 ? text.substring(i + 1, text.length()) : text;
        }
        if (prefix != null && prefixNsMap != null) {
            ns = (String)prefixNsMap.get((Object)prefix);
        }
        if (ns != null && local != null && prefix != null) {
            return new QName(ns, local, prefix);
        }
        if (ns == null) {
            local = text;
        }
        return new QName(local);
    }

    public static QName getQName(String text) {
        String ns = null;
        String local = null;
        int index = text.indexOf(58);
        if (index >= 0 && index < text.length()) {
            ns = text.substring(0, index);
            if (index + 1 < text.length()) {
                local = text.substring(index + 1, text.length());
            }
        } else if (index == -1) {
            local = text;
        }
        return new QName(ns, local);
    }

    public static String getComponentName(String name) {
        int index = name.indexOf("/");
        if (index > 0) {
            return name.substring(0, index);
        }
        return "";
    }

    public static String getServiceOrReferenceName(String name) {
        int index = name.indexOf("/");
        if (index > 0 && index + 1 < name.length()) {
            return name.substring(index + 1, name.length());
        }
        return "";
    }
}

