/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.util.SCANameUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class SCALayoutUtil {
    public static void layoutLayoutNodesViews(List<LayoutNode> nodes) {
        ArrayList<View> views = new ArrayList<View>(nodes.size());
        Iterator<LayoutNode> it = nodes.iterator();
        while (it.hasNext()) {
            views.add((View)it.next().getNode());
        }
        SCALayoutUtil.layoutViews(views);
    }

    public static void layoutViews(List<View> views) {
        DirectedGraph graph = SCALayoutUtil.createDirectedGraph(views);
        graph.setDirection(16);
        new DirectedGraphLayout().visit(graph);
        for (Node graphNode : graph.nodes) {
            int x = graphNode.x + 0;
            int y = graphNode.y;
            View viewItem = (View)graphNode.data;
            ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(x));
            ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(y));
        }
    }

    public static DirectedGraph createDirectedGraph(List<View> views) {
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(20, 10, 40, 10));
        Node top = new Node(null);
        top.height = 0;
        top.width = 0;
        top.setPadding(new Insets(-10, 0, 0, 0));
        graph.nodes.add((Object)top);
        WeakHashMap<View, Node> nodesMap = new WeakHashMap<View, Node>();
        int i = 0;
        while (i < views.size()) {
            View view = views.get(i);
            Dimension size = SCALayoutUtil.getNodeSize(view);
            if (size != null) {
                Node graphNode = new Node((Object)view);
                graphNode.width = size.width;
                graphNode.height = size.height;
                graph.nodes.add((Object)graphNode);
                nodesMap.put(view, graphNode);
            }
            ++i;
        }
        i = 0;
        while (i < graph.nodes.size()) {
            Node n = graph.nodes.getNode(i);
            View view = (View)n.data;
            if (view != null) {
                List<View> edgeTargets = SCALayoutUtil.getEdgeTargets(view, views);
                int j = 0;
                while (j < edgeTargets.size()) {
                    View targetView = edgeTargets.get(j);
                    Node source = n;
                    Node target = (Node)nodesMap.get(targetView);
                    if (view.getElement() instanceof Reference) {
                        source = (Node)nodesMap.get(targetView);
                        target = n;
                    }
                    if (source != null && target != null && !source.equals(target)) {
                        Edge edge = new Edge(source, target);
                        edge.setSourceOffset(0);
                        edge.setTargetOffset(0);
                        graph.edges.add((Object)edge);
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<Node> nodesNotConnected = SCALayoutUtil.findAllNodesNotConnected(top, graph);
        List<Node> servicesNotConnected = SCALayoutUtil.findAllServicesNotConnected(nodesNotConnected);
        List<Node> componentsNotConnected = SCALayoutUtil.findAllComponentsNotConnected(nodesNotConnected);
        List<Node> referencesNotConnected = SCALayoutUtil.findAllReferencesNotConnected(nodesNotConnected);
        SCALayoutUtil.chainNodesTogether(graph, servicesNotConnected);
        SCALayoutUtil.chainNodesTogether(graph, componentsNotConnected);
        SCALayoutUtil.chainNodesTogether(graph, referencesNotConnected);
        if (servicesNotConnected.size() > 0) {
            graph.edges.add((Object)new Edge(top, servicesNotConnected.get(0)));
            Node nextConnector = servicesNotConnected.get(servicesNotConnected.size() - 1);
            if (componentsNotConnected.size() > 0) {
                graph.edges.add((Object)new Edge(nextConnector, componentsNotConnected.get(0)));
                nextConnector = componentsNotConnected.get(componentsNotConnected.size() - 1);
            }
            if (referencesNotConnected.size() > 0) {
                graph.edges.add((Object)new Edge(nextConnector, referencesNotConnected.get(0)));
            }
        } else if (componentsNotConnected.size() > 0) {
            graph.edges.add((Object)new Edge(top, componentsNotConnected.get(0)));
            Node nextConnector = componentsNotConnected.get(componentsNotConnected.size() - 1);
            if (referencesNotConnected.size() > 0) {
                graph.edges.add((Object)new Edge(nextConnector, referencesNotConnected.get(0)));
            }
        } else if (referencesNotConnected.size() > 0) {
            graph.edges.add((Object)new Edge(top, referencesNotConnected.get(0)));
        }
        return graph;
    }

    private static List<Node> findAllServicesNotConnected(List<Node> nodes) {
        Iterator<Node> it = nodes.iterator();
        ArrayList<Node> list = new ArrayList<Node>();
        while (it.hasNext()) {
            Node node = it.next();
            View view = (View)node.data;
            if (!(view.getElement() instanceof Service)) continue;
            list.add(node);
        }
        return list;
    }

    private static List<Node> findAllComponentsNotConnected(List<Node> nodes) {
        Iterator<Node> it = nodes.iterator();
        ArrayList<Node> list = new ArrayList<Node>();
        while (it.hasNext()) {
            Node node = it.next();
            View view = (View)node.data;
            if (!(view.getElement() instanceof Component)) continue;
            list.add(node);
        }
        return list;
    }

    private static List<Node> findAllReferencesNotConnected(List<Node> nodes) {
        Iterator<Node> it = nodes.iterator();
        ArrayList<Node> list = new ArrayList<Node>();
        while (it.hasNext()) {
            Node node = it.next();
            View view = (View)node.data;
            if (!(view.getElement() instanceof Reference)) continue;
            list.add(node);
        }
        return list;
    }

    private static void chainNodesTogether(DirectedGraph graph, List<Node> nodes) {
        int index = 0;
        while (index < nodes.size()) {
            Node node1 = nodes.get(index);
            if (index + 1 < nodes.size()) {
                Node node2 = nodes.get(index + 1);
                graph.edges.add((Object)new Edge(node1, node2));
            }
            ++index;
        }
    }

    private static List<Node> findAllNodesNotConnected(Node topNode, DirectedGraph g) {
        List nodes = (List)g.nodes.clone();
        for (Edge edge : g.edges) {
            nodes.remove(edge.source);
            nodes.remove(edge.target);
        }
        nodes.remove(topNode);
        return nodes;
    }

    private static List<View> getEdgeTargets(View view, List<View> views) {
        ArrayList<View> list;
        block5: {
            EObject viewElement;
            block6: {
                String serviceString;
                String componentName;
                View viewComp;
                block4: {
                    list = new ArrayList<View>();
                    viewElement = view.getElement();
                    if (!(viewElement instanceof Component)) break block4;
                    for (ComponentReference cr : ((Component)viewElement).getReference()) {
                        if (cr.getTarget() == null) continue;
                        for (String targetString : cr.getTarget()) {
                            String serviceString2;
                            String componentName2 = SCANameUtil.getComponentName(targetString);
                            View viewComp2 = SCALayoutUtil.getCorrespondingViewComponent(componentName2, views);
                            if (viewComp2 == null || !SCALayoutUtil.containsService(serviceString2 = SCANameUtil.getServiceOrReferenceName(targetString), (Component)viewComp2.getElement())) continue;
                            list.add(viewComp2);
                        }
                    }
                    break block5;
                }
                if (!(viewElement instanceof Service)) break block6;
                String promoteString = ((Service)viewElement).getPromote();
                if (promoteString == null || promoteString.equals("") || (viewComp = SCALayoutUtil.getCorrespondingViewComponent(componentName = SCANameUtil.getComponentName(promoteString), views)) == null || !SCALayoutUtil.containsService(serviceString = SCANameUtil.getServiceOrReferenceName(promoteString), (Component)viewComp.getElement())) break block5;
                list.add(viewComp);
                break block5;
            }
            if (viewElement instanceof Reference && ((Reference)viewElement).getPromote() != null) {
                for (String promoteString : ((Reference)viewElement).getPromote()) {
                    String refString;
                    String componentName;
                    View viewComp;
                    if (promoteString.equals("") || (viewComp = SCALayoutUtil.getCorrespondingViewComponent(componentName = SCANameUtil.getComponentName(promoteString), views)) == null || !SCALayoutUtil.containsReference(refString = SCANameUtil.getServiceOrReferenceName(promoteString), (Component)viewComp.getElement())) continue;
                    list.add(viewComp);
                }
            }
        }
        return list;
    }

    private static View getCorrespondingViewComponent(String componentName, List<View> views) {
        for (View view : views) {
            Component component;
            if (!(view.getElement() instanceof Component) || !(component = (Component)view.getElement()).getName().equals(componentName)) continue;
            return view;
        }
        return null;
    }

    private static boolean containsService(String serviceName, Component component) {
        for (ComponentService cs : component.getService()) {
            if (!cs.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsReference(String referenceName, Component component) {
        for (ComponentReference cr : component.getReference()) {
            if (!cr.getName().equals(referenceName)) continue;
            return true;
        }
        return false;
    }

    private static Dimension getNodeSize(View view) {
        String type = view.getType();
        if (type.equals("1001")) {
            int horizontalPadding = 100;
            int verticalPadding = 20;
            return new Dimension(ComponentRelatedFigureConstants.COMPONENT_MINIMUM_WIDTH + horizontalPadding, ComponentRelatedFigureConstants.COMPONENT_MINIMUM_HEIGHT + verticalPadding);
        }
        int horizontalPadding = 50;
        int verticalPadding = 20;
        return new Dimension(ComponentRelatedFigureConstants.COMPOSITE_CHEVRON_WIDTH + horizontalPadding, ComponentRelatedFigureConstants.COMPOSITE_CHEVRON_HEIGHT + verticalPadding);
    }
}

