/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class PositionCompositeChevronCommand
extends AbstractTransactionalCommand {
    public static int SHIFT_LEFT = -80;
    public static int SHIFT_RIGHT = 50;
    private CreateViewRequest request;
    private CreateViewRequest.ViewDescriptor descriptor;
    private int xShift;
    private EditPart editPart;
    private Dimension defaultFigureSize = new Dimension(ComponentRelatedFigureConstants.COMPOSITE_CHEVRON_WIDTH, ComponentRelatedFigureConstants.COMPOSITE_CHEVRON_HEIGHT);

    public PositionCompositeChevronCommand(TransactionalEditingDomain editingDomain, String label, CreateViewRequest request, int xShift, EditPart ep) {
        super(editingDomain, label, null);
        this.request = request;
        this.xShift = xShift;
        this.editPart = ep;
    }

    public PositionCompositeChevronCommand(TransactionalEditingDomain editingDomain, String label, CreateViewRequest.ViewDescriptor descriptor, int xShift, EditPart ep) {
        super(editingDomain, label, null);
        this.descriptor = descriptor;
        this.xShift = xShift;
        this.editPart = ep;
    }

    private Point getChevronLocation(List existingFigures) {
        Point pointerLocation = this.getPreferredChevronLocation();
        Rectangle preferredBounds = new Rectangle(pointerLocation, this.defaultFigureSize);
        Rectangle offendingBounds = this.intersectsWithFigures(preferredBounds, existingFigures);
        if (offendingBounds == null) {
            return preferredBounds.getLocation();
        }
        Point newLocation = null;
        Rectangle testBounds = null;
        Rectangle bottomBounds = null;
        Rectangle badBounds = offendingBounds;
        int index = 0;
        while (index < 4) {
            newLocation = new Point(pointerLocation.x, badBounds.getBottom().y + 5);
            testBounds = new Rectangle(newLocation, this.defaultFigureSize);
            badBounds = this.intersectsWithFigures(testBounds, existingFigures);
            if (badBounds == null) {
                bottomBounds = testBounds;
                break;
            }
            ++index;
        }
        Rectangle topBounds = null;
        badBounds = offendingBounds;
        index = 0;
        while (index < 4) {
            newLocation = new Point(pointerLocation.x, badBounds.getTop().y - this.defaultFigureSize.height - 10);
            testBounds = new Rectangle(newLocation, this.defaultFigureSize);
            badBounds = this.intersectsWithFigures(testBounds, existingFigures);
            if (badBounds == null) {
                topBounds = testBounds;
                break;
            }
            ++index;
        }
        if (topBounds != null && bottomBounds == null) {
            return topBounds.getLocation();
        }
        if (topBounds == null && bottomBounds != null) {
            return bottomBounds.getLocation();
        }
        if (topBounds != null && bottomBounds != null) {
            if (pointerLocation.y - topBounds.y > bottomBounds.y - pointerLocation.y) {
                return bottomBounds.getLocation();
            }
            return topBounds.getLocation();
        }
        return pointerLocation;
    }

    private Rectangle intersectsWithFigures(Rectangle itemBounds, List existingFigures) {
        Iterator it = existingFigures.iterator();
        while (it.hasNext()) {
            Rectangle bounds = ((IFigure)it.next()).getBounds();
            if (!bounds.intersects(itemBounds)) continue;
            return bounds;
        }
        return null;
    }

    private Point getPreferredChevronLocation() {
        Point location = this.calculatePointerLocation();
        if (this.xShift == SHIFT_RIGHT) {
            location.setLocation(location.x + this.xShift, location.y - 40);
        } else {
            location.setLocation(location.x + this.xShift, location.y - 40);
        }
        return location;
    }

    private Point calculatePointerLocation() {
        GraphicalViewer viewer = (GraphicalViewer)ScaUtil.getActiveEditor(this.editPart).getAdapter(GraphicalViewer.class);
        if (viewer.getSelectedEditParts().size() < 1) {
            return new Point(-1, -1);
        }
        GraphicalEditPart selectedEP = (GraphicalEditPart)viewer.getSelectedEditParts().get(0);
        IFigure figure = selectedEP.getFigure();
        Rectangle bounds = figure.getBounds();
        return bounds.getCenter();
    }

    private View getView() {
        if (this.descriptor != null) {
            return (View)this.descriptor.getAdapter(View.class);
        }
        if (this.request instanceof CreateViewRequest) {
            CreateViewRequest.ViewDescriptor descriptor = (CreateViewRequest.ViewDescriptor)this.request.getViewDescriptors().get(0);
            return (View)descriptor.getAdapter(View.class);
        }
        if (this.request instanceof CreateViewAndElementRequest) {
            CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = ((CreateViewAndElementRequest)this.request).getViewAndElementDescriptor();
            return (View)descriptor.getAdapter(View.class);
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = this.getView();
        if (view != null && ScaUtil.getActiveEditor(this.editPart) != null) {
            GraphicalViewer viewer = (GraphicalViewer)ScaUtil.getActiveEditor(this.editPart).getAdapter(GraphicalViewer.class);
            Iterator rootKidsList = ((GraphicalEditPart)viewer.getRootEditPart().getChildren().get(0)).getChildren().iterator();
            ArrayList rootFigures = new ArrayList();
            block0: while (rootKidsList.hasNext()) {
                IFigure fig = ((GraphicalEditPart)rootKidsList.next()).getFigure();
                if (fig instanceof ComponentGroupingFigure) {
                    for (Object o : fig.getChildren()) {
                        if (!(o instanceof ComponentFigure)) continue;
                        rootFigures.add(o);
                        continue block0;
                    }
                    continue;
                }
                rootFigures.add(fig);
            }
            Point location = this.getChevronLocation(rootFigures);
            int shiftX = 0;
            int shiftY = 0;
            if (location.x < 0) {
                shiftX = Math.abs(location.x) + 5;
            }
            if (location.y < 0) {
                shiftY = Math.abs(location.y) + 5;
            }
            if (shiftX > 0 || shiftY > 0) {
                for (View viewItem : this.getRootViewObjects(this.editPart)) {
                    Integer itemX = (Integer)ViewUtil.getStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                    Integer itemY = (Integer)ViewUtil.getStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(itemX + shiftX));
                    ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(itemY + shiftY));
                }
                location.x += shiftX;
                location.y += shiftY;
            }
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(location.x));
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(location.y));
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)Messages.PositionComponentCommand_0);
    }

    private List getRootViewObjects(EditPart ep) {
        ArrayList<Object> views = new ArrayList<Object>();
        GraphicalViewer viewer = (GraphicalViewer)ScaUtil.getActiveEditor(this.editPart).getAdapter(GraphicalViewer.class);
        for (Object item : ((GraphicalEditPart)viewer.getRootEditPart().getChildren().get(0)).getChildren()) {
            if (!(item instanceof EditPart)) continue;
            views.add(((EditPart)item).getModel());
        }
        return views;
    }
}

