/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentFigure;
import com.ibm.ccl.sca.composite.ui.custom.util.ComponentWrapper;
import com.ibm.ccl.sca.composite.ui.custom.util.DiagramOverlapMetadata;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.edit.parts.ComponentEditPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class PositionComponentCommand
extends AbstractTransactionalCommand {
    private CreateViewRequest request;
    private CreateViewRequest.ViewDescriptor viewDescriptor;
    private Dimension defaultFigureSize = new Dimension(167, 92);
    private EditPart editPart;
    private Point specifiedLocation = new Point(5, 5);
    private int nudgeCounter = 0;

    public PositionComponentCommand(TransactionalEditingDomain editingDomain, String label, CreateViewRequest request, EditPart ep, Point point) {
        super(editingDomain, label, null);
        this.request = request;
        this.editPart = ep;
        this.specifiedLocation = point;
    }

    public PositionComponentCommand(TransactionalEditingDomain editingDomain, String label, CreateViewRequest request, EditPart ep) {
        super(editingDomain, label, null);
        this.request = request;
        this.editPart = ep;
    }

    public PositionComponentCommand(TransactionalEditingDomain editingDomain, String label, CreateViewRequest.ViewDescriptor viewDescriptor, EditPart ep) {
        super(editingDomain, label, null);
        this.viewDescriptor = viewDescriptor;
        this.editPart = ep;
    }

    private List getComponentWrappers(ComponentEditPart ep) {
        ArrayList<ComponentWrapper> componentWrappers = new ArrayList<ComponentWrapper>();
        GraphicalViewer viewer = (GraphicalViewer)ScaUtil.getActiveEditor(this.editPart).getAdapter(GraphicalViewer.class);
        for (Object item : ((GraphicalEditPart)viewer.getRootEditPart().getChildren().get(0)).getChildren()) {
            if (!(item instanceof ComponentEditPart) || item.equals(ep)) continue;
            componentWrappers.add(this.getComponentView((ComponentEditPart)item));
        }
        return componentWrappers;
    }

    private View getDescriptor() {
        if (this.viewDescriptor != null) {
            return (View)this.viewDescriptor.getAdapter(View.class);
        }
        if (this.request instanceof CreateViewRequest) {
            CreateViewRequest.ViewDescriptor descriptor = (CreateViewRequest.ViewDescriptor)this.request.getViewDescriptors().get(0);
            return (View)descriptor.getAdapter(View.class);
        }
        if (this.request instanceof CreateViewAndElementRequest) {
            CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = ((CreateViewAndElementRequest)this.request).getViewAndElementDescriptor();
            return (View)descriptor.getAdapter(View.class);
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = this.getDescriptor();
        if (view != null && ScaUtil.getActiveEditor(this.editPart) != null) {
            Map epRegistry;
            GraphicalViewer viewer = (GraphicalViewer)ScaUtil.getActiveEditor(this.editPart).getAdapter(GraphicalViewer.class);
            ComponentEditPart ep = null;
            if (viewer != null && (epRegistry = viewer.getEditPartRegistry()) != null) {
                ep = (ComponentEditPart)epRegistry.get(view);
            }
            ComponentFigure itemComponentFigure = null;
            Point defaultPoint = this.specifiedLocation;
            if (ep != null) {
                itemComponentFigure = this.getComponentFigure(ep);
                defaultPoint = this.calculateDefaultPoint((IFigure)itemComponentFigure);
            }
            List componentWrappers = this.getComponentWrappers(ep);
            Point setPoint = defaultPoint;
            List<DiagramOverlapMetadata> overlaps = this.calculateOverlap(new Rectangle(defaultPoint, this.defaultFigureSize), null, componentWrappers);
            if (overlaps.size() > 0) {
                List<Dimension> possibleShifts = this.calculateShiftDimensions(overlaps);
                Iterator<Dimension> possibleShiftsIt = possibleShifts.iterator();
                boolean overlapStillExists = true;
                while (possibleShiftsIt.hasNext()) {
                    Dimension testDimension = possibleShiftsIt.next();
                    Point testPoint = new Point(defaultPoint.x + testDimension.width, defaultPoint.y + testDimension.height);
                    List<DiagramOverlapMetadata> testPointOverlap = this.calculateOverlap(new Rectangle(testPoint, this.defaultFigureSize), null, componentWrappers);
                    HashMap<Point, List<DiagramOverlapMetadata>> secondaryPointList = new HashMap<Point, List<DiagramOverlapMetadata>>();
                    if (testPointOverlap.size() == 0) {
                        setPoint = testPoint;
                        overlapStillExists = false;
                        break;
                    }
                    secondaryPointList.put(testPoint, testPointOverlap);
                    if (!overlapStillExists) continue;
                    for (Point testPoint2 : secondaryPointList.keySet()) {
                        List overlaps2 = (List)secondaryPointList.get(testPoint2);
                        List<Dimension> possibleShifts2 = this.calculateShiftDimensions(overlaps2);
                        for (Dimension testDimension2 : possibleShifts2) {
                            Point testPoint3 = new Point(testPoint2.x + testDimension2.width, testPoint2.y + testDimension2.height);
                            List<DiagramOverlapMetadata> testPointOverlap2 = this.calculateOverlap(new Rectangle(testPoint3, this.defaultFigureSize), null, componentWrappers);
                            if (testPointOverlap2.size() != 0) continue;
                            setPoint = testPoint3;
                            overlapStillExists = false;
                            break;
                        }
                        if (!overlapStillExists) break;
                    }
                    if (!overlapStillExists) continue;
                    this.nudgeOverlaps(overlaps, componentWrappers, true, null);
                }
            }
            int shiftX = 0;
            int shiftY = 0;
            if (setPoint.x < 0) {
                shiftX = Math.abs(setPoint.x) + 5;
            }
            if (setPoint.y < 0) {
                shiftY = Math.abs(setPoint.y) + 5;
            }
            if (shiftX > 0 || shiftY > 0) {
                Iterator it = componentWrappers.iterator();
                while (it.hasNext()) {
                    View viewItem = ((ComponentWrapper)it.next()).getView();
                    Integer itemX = (Integer)ViewUtil.getStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                    Integer itemY = (Integer)ViewUtil.getStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(itemX + shiftX));
                    ViewUtil.setStructuralFeatureValue((View)viewItem, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(itemY + shiftY));
                }
                setPoint.x += shiftX;
                setPoint.y += shiftY;
            }
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(setPoint.x));
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(setPoint.y));
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)Messages.PositionComponentCommand_0);
    }

    private void nudgeOverlaps(List<DiagramOverlapMetadata> overlaps, List<ComponentWrapper> componentWrappers, boolean deep, String incomingShiftDirection) {
        for (DiagramOverlapMetadata md : overlaps) {
            List<DiagramOverlapMetadata> newOverlaps;
            View viewMD = md.getComponentWrapperObject().getView();
            IFigure figureMD = md.getComponentWrapperObject().getfigure();
            Integer x = (Integer)ViewUtil.getStructuralFeatureValue((View)viewMD, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Integer y = (Integer)ViewUtil.getStructuralFeatureValue((View)viewMD, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            int mdWidth = figureMD.getBounds().width;
            int mdHeight = figureMD.getBounds().height;
            String shiftDirection = incomingShiftDirection;
            if (incomingShiftDirection == null) {
                shiftDirection = md.getShiftDirection();
            }
            Dimension shift = this.convertAbsToDirectional(md.getOverlapDimension(), shiftDirection);
            Point shiftPoint = new Point(x + shift.width, y + shift.height);
            ViewUtil.setStructuralFeatureValue((View)viewMD, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(shiftPoint.x));
            ViewUtil.setStructuralFeatureValue((View)viewMD, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(shiftPoint.y));
            if (!deep || (newOverlaps = this.calculateOverlap(new Rectangle(shiftPoint, new Dimension(mdWidth, mdHeight)), viewMD, componentWrappers)).size() <= 0 || this.nudgeCounter >= 25) continue;
            ++this.nudgeCounter;
            this.nudgeOverlaps(newOverlaps, componentWrappers, deep, null);
        }
    }

    private Dimension convertAbsToDirectional(Dimension dim, String shiftDirection) {
        int width = dim.width;
        int height = dim.height;
        if (shiftDirection.equals("NORTH")) {
            return new Dimension(0, height * -1);
        }
        if (shiftDirection.equals("NORTH_EAST")) {
            return new Dimension(width, height * -1);
        }
        if (shiftDirection.equals("EAST")) {
            return new Dimension(width, 0);
        }
        if (shiftDirection.equals("SOUTH_EAST")) {
            return new Dimension(width, height);
        }
        if (shiftDirection.equals("SOUTH")) {
            return new Dimension(0, height);
        }
        if (shiftDirection.equals("SOUTH_WEST")) {
            return new Dimension(width * -1, height);
        }
        if (shiftDirection.equals("WEST")) {
            return new Dimension(width * -1, 0);
        }
        return new Dimension(width * -1, height * -1);
    }

    private List<Dimension> calculateShiftDimensions(List<DiagramOverlapMetadata> overlapList) {
        Dimension nwOverlap = new Dimension(0, 0);
        Dimension neOverlap = new Dimension(0, 0);
        Dimension swOverlap = new Dimension(0, 0);
        Dimension seOverlap = new Dimension(0, 0);
        for (DiagramOverlapMetadata metadata : overlapList) {
            if (metadata.getOverlapLocation().equals("NORTH_WEST")) {
                seOverlap = this.getLargestDimension(nwOverlap, metadata.getOverlapDimension());
                continue;
            }
            if (metadata.getOverlapLocation().equals("NORTH_EAST")) {
                swOverlap = this.getLargestDimension(nwOverlap, metadata.getOverlapDimension());
                continue;
            }
            if (metadata.getOverlapLocation().equals("SOUTH_EAST")) {
                nwOverlap = this.getLargestDimension(nwOverlap, metadata.getOverlapDimension());
                continue;
            }
            if (!metadata.getOverlapLocation().equals("SOUTH_WEST")) continue;
            neOverlap = this.getLargestDimension(nwOverlap, metadata.getOverlapDimension());
        }
        ArrayList<Dimension> shifts = new ArrayList<Dimension>();
        if (nwOverlap.equals(0, 0) && neOverlap.equals(0, 0) && seOverlap.equals(0, 0) && swOverlap.equals(0, 0)) {
            shifts.add(new Dimension(0, -this.defaultFigureSize.height - 5));
        } else if (nwOverlap.equals(0, 0)) {
            if (neOverlap.equals(0, 0)) {
                shifts.add(new Dimension(0, this.getLargestNumber(seOverlap.height, swOverlap.height) * -1));
                if (seOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(this.getLargestNumber(nwOverlap.width, swOverlap.width), 0));
                } else if (swOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(this.getLargestNumber(neOverlap.width, seOverlap.width) * -1 - 12, 0));
                }
            } else if (swOverlap.equals(0, 0)) {
                shifts.add(new Dimension(this.getLargestNumber(neOverlap.width, seOverlap.width) * -1 - 12, 0));
                if (neOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(0, this.getLargestNumber(seOverlap.height, swOverlap.height) * -1));
                } else if (seOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(0, this.getLargestNumber(neOverlap.height, nwOverlap.height)));
                }
            } else {
                shifts.add(new Dimension(neOverlap.width * -1 - 12, this.getLargestNumber(seOverlap.height, swOverlap.height) * -1));
            }
        } else if (neOverlap.equals(0, 0)) {
            if (seOverlap.equals(0, 0)) {
                shifts.add(new Dimension(this.getLargestNumber(nwOverlap.width, swOverlap.width), 0));
                if (nwOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(0, this.getLargestNumber(seOverlap.height, swOverlap.height) * -1));
                } else if (swOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(0, this.getLargestNumber(neOverlap.height, nwOverlap.height)));
                }
            } else {
                shifts.add(new Dimension(nwOverlap.width, this.getLargestNumber(seOverlap.height, swOverlap.height) * -1));
            }
        } else if (seOverlap.equals(0, 0)) {
            if (swOverlap.equals(0, 0)) {
                shifts.add(new Dimension(0, this.getLargestNumber(neOverlap.height, nwOverlap.height)));
                if (nwOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(this.getLargestNumber(neOverlap.width, seOverlap.width) * -1 - 12, 0));
                } else if (neOverlap.equals(0, 0)) {
                    shifts.add(new Dimension(this.getLargestNumber(nwOverlap.width, swOverlap.width), 0));
                }
            } else {
                shifts.add(new Dimension(swOverlap.width, this.getLargestNumber(neOverlap.height, nwOverlap.height)));
            }
        } else if (swOverlap.equals(0, 0)) {
            shifts.add(new Dimension(seOverlap.width * -1 - 12, this.getLargestNumber(neOverlap.height, nwOverlap.height)));
        }
        return shifts;
    }

    private int getLargestNumber(int n1, int n2) {
        if (n1 >= n2) {
            return n1;
        }
        return n2;
    }

    private Dimension getLargestDimension(Dimension d1, Dimension d2) {
        int width = d1.width >= d2.width ? d1.width : d2.width;
        int height = d1.height >= d2.height ? d1.height : d2.height;
        return new Dimension(width, height);
    }

    private List<DiagramOverlapMetadata> calculateOverlap(Rectangle figBounds, View originalView, List<ComponentWrapper> wrappers) {
        ArrayList<DiagramOverlapMetadata> overlap = new ArrayList<DiagramOverlapMetadata>();
        for (ComponentWrapper wrapperItem : wrappers) {
            Rectangle bounds;
            DiagramOverlapMetadata metadata;
            View wrapperView = wrapperItem.getView();
            IFigure wrapperFig = wrapperItem.getfigure();
            if (wrapperView.equals(originalView)) continue;
            Integer x = (Integer)ViewUtil.getStructuralFeatureValue((View)wrapperView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Integer y = (Integer)ViewUtil.getStructuralFeatureValue((View)wrapperView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            int width = wrapperFig.getBounds().width;
            int height = wrapperFig.getBounds().height;
            if (width == 0 || height == 0) {
                width = this.defaultFigureSize.width;
                height = this.defaultFigureSize.height;
            }
            if ((metadata = this.calculateOverlapMetadata(figBounds, bounds = new Rectangle(x.intValue(), y.intValue(), width, height))) == null) continue;
            metadata.setComponentWrapperObject(wrapperItem);
            overlap.add(metadata);
        }
        return overlap;
    }

    private DiagramOverlapMetadata calculateOverlapMetadata(Rectangle figBounds, Rectangle otherBounds) {
        DiagramOverlapMetadata metadata = null;
        if (figBounds.intersects(otherBounds) || figBounds.x == otherBounds.x && figBounds.y == otherBounds.y) {
            metadata = new DiagramOverlapMetadata();
            metadata.setFigureSize(otherBounds.getSize());
            if (figBounds.x < otherBounds.x) {
                if (figBounds.y < otherBounds.y) {
                    metadata.setOverlapLoation("NORTH_WEST");
                    metadata.setOverlapHeight(figBounds.height - (otherBounds.y - figBounds.y));
                    metadata.setOverlapWidth(figBounds.width - (otherBounds.x - figBounds.x));
                } else {
                    metadata.setOverlapLoation("SOUTH_WEST");
                    metadata.setOverlapHeight(otherBounds.height - (figBounds.y - otherBounds.y));
                    metadata.setOverlapWidth(figBounds.width - (otherBounds.x - figBounds.x));
                }
            } else if (figBounds.y < otherBounds.y) {
                metadata.setOverlapLoation("NORTH_EAST");
                metadata.setOverlapHeight(figBounds.height - (otherBounds.y - figBounds.y));
                metadata.setOverlapWidth(otherBounds.width - (figBounds.x - otherBounds.x));
            } else {
                metadata.setOverlapLoation("SOUTH_EAST");
                metadata.setOverlapHeight(otherBounds.height - (figBounds.y - otherBounds.y));
                metadata.setOverlapWidth(otherBounds.width - (figBounds.x - otherBounds.x));
            }
        }
        return metadata;
    }

    private ComponentWrapper getComponentView(ComponentEditPart ep) {
        for (Object childItem : ep.getFigure().getChildren()) {
            if (!(childItem instanceof ComponentFigure)) continue;
            return new ComponentWrapper((View)ep.getModel(), (IFigure)((ComponentFigure)((Object)childItem)));
        }
        return null;
    }

    private ComponentFigure getComponentFigure(ComponentEditPart ep) {
        for (Object childItem : ep.getFigure().getChildren()) {
            if (!(childItem instanceof ComponentFigure)) continue;
            return (ComponentFigure)((Object)childItem);
        }
        return null;
    }

    private Point calculateDefaultPoint(IFigure figure) {
        Point point = this.request.getLocation();
        figure.translateToRelative((Translatable)point);
        figure.translateFromParent((Translatable)point);
        return point.setLocation(point.x - 9, point.y);
    }
}

