/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Property;
import com.ibm.ccl.sca.composite.emf.sca.PropertyValue;
import com.ibm.ccl.sca.composite.emf.sca.SCAFactory;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCABaseAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.properties.RemovePropertiesAction;
import com.ibm.ccl.sca.composite.ui.custom.emf.properties.CreateComplexLiteralActionTest;
import com.ibm.ccl.sca.composite.ui.custom.util.BasePropertyWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LiteralValueProcessor {
    private List getComplexValues(BasicFeatureMap map) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < map.size()) {
            EStructuralFeatureImpl.BasicFeatureMapEntry entry = (EStructuralFeatureImpl.BasicFeatureMapEntry)map.get(index);
            EStructuralFeature feature = entry.getEStructuralFeature();
            String featureName = feature.getName();
            Object o = entry.getValue();
            if (o instanceof AnyTypeImpl) {
                AnyTypeImpl any = (AnyTypeImpl)o;
                this.traverseAnyType(sb, (AnyType)any);
                list.add(sb.toString());
                sb = new StringBuffer();
            } else if (o instanceof String) {
                String value = (String)o;
                if (featureName.equals("cDATA")) {
                    value = String.valueOf(CreateComplexLiteralActionTest.CDATA_START_TAG) + value + CreateComplexLiteralActionTest.CDATA_END_TAG;
                } else if (featureName.equals("comment")) {
                    value = String.valueOf(CreateComplexLiteralActionTest.COMMENT_START_TAG) + value + CreateComplexLiteralActionTest.COMMENT_END_TAG;
                }
                sb.append(value);
            }
            ++index;
        }
        if (!sb.toString().equals("")) {
            int size = list.size();
            if (size > 0) {
                String lastItem = (String)list.get(size - 1);
                StringBuffer buffer = new StringBuffer(lastItem);
                buffer.append(sb.toString());
                list.remove(size - 1);
                list.add(buffer.toString());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }

    public List getComplexValues(Object input) {
        if (input instanceof BasePropertyWrapper) {
            BasicFeatureMap map = ((BasePropertyWrapper)input).getMixed();
            return this.getComplexValues(map);
        }
        return new ArrayList();
    }

    private String stripEscapeCharsAndSpacing(String s) {
        String newString = s.replaceAll("\n", "");
        newString = newString.replaceAll("\t", "");
        newString = newString.trim();
        return newString;
    }

    private List getSimpleValues(BasicFeatureMap map) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while (index < map.size()) {
            EStructuralFeatureImpl.BasicFeatureMapEntry entry = (EStructuralFeatureImpl.BasicFeatureMapEntry)map.get(index);
            Object o = entry.getValue();
            if (o instanceof String) {
                list.add(this.stripEscapeCharsAndSpacing((String)o));
            }
            ++index;
        }
        return list;
    }

    protected EAttribute getEAttribute(EObject eObject, String attr) {
        EAttribute attribute = null;
        EList list = eObject.eClass().getEAllAttributes();
        int i = 0;
        while (i < list.size()) {
            EAttribute att = (EAttribute)list.get(i);
            if (att.getName().equals(attr)) {
                attribute = att;
                break;
            }
            ++i;
        }
        return attribute;
    }

    public List getSimpleValues(EObject eObject) {
        if (eObject instanceof Property) {
            return this.getSimpleValues((Property)eObject);
        }
        if (eObject instanceof PropertyValue) {
            return this.getSimpleValue((PropertyValue)eObject);
        }
        return new ArrayList();
    }

    public List getSimpleValues(Property property) {
        BasicFeatureMap map = (BasicFeatureMap)property.getMixed();
        List simpleValues = this.getSimpleValues(map);
        if (simpleValues.size() <= 0) {
            simpleValues.add("");
        }
        return simpleValues;
    }

    public List getSimpleValue(PropertyValue propertyValue) {
        BasicFeatureMap map = (BasicFeatureMap)propertyValue.getMixed();
        List simpleValues = this.getSimpleValues(map);
        if (simpleValues.size() <= 0) {
            simpleValues.add("");
        }
        return simpleValues;
    }

    public List getSimpleValues(Object input) {
        if (input instanceof BasePropertyWrapper) {
            BasePropertyWrapper wrapper = (BasePropertyWrapper)input;
            List propertyObjects = wrapper.getPropertyObjects();
            if (propertyObjects.size() > 1) {
                Iterator it = propertyObjects.iterator();
                ArrayList values = new ArrayList();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (!(item instanceof EObject)) continue;
                    values.addAll(this.getSimpleValues((EObject)item));
                }
                return values;
            }
            BasicFeatureMap map = wrapper.getMixed();
            List simpleValues = this.getSimpleValues(map);
            return simpleValues;
        }
        return new ArrayList();
    }

    public void createComplexValues(EObject eObject, List<String> values) {
        CreateComplexLiteralActionTest action = new CreateComplexLiteralActionTest(this.getWorkbenchPart(), eObject, values);
        action.run();
    }

    public void addSimpleValue(BasePropertyWrapper wrapper, String value) {
        List propertyObjects = wrapper.getPropertyObjects();
        DuplicatePropertiesAction action = new DuplicatePropertiesAction(this.getWorkbenchPart(), (EObject)propertyObjects.get(0));
        action.run();
        EObject propertyObject = action.getNewProperty();
        wrapper.addPropertyObject(propertyObject);
    }

    public void createSimpleValues(BasePropertyWrapper wrapper, List<String> values) {
        int valuesIndex = 0;
        List propertyObjects = wrapper.getPropertyObjects();
        while (valuesIndex < values.size()) {
            SCABaseAction action;
            String value = values.get(valuesIndex);
            EObject propertyObject = null;
            if (valuesIndex < propertyObjects.size()) {
                propertyObject = (EObject)wrapper.getPropertyObjects().get(valuesIndex);
            } else {
                action = new DuplicatePropertiesAction(this.getWorkbenchPart(), (EObject)propertyObjects.get(0));
                ((DuplicatePropertiesAction)action).run();
                propertyObject = ((DuplicatePropertiesAction)action).getNewProperty();
                wrapper.addPropertyObject(propertyObject);
            }
            action = new EditSimpleLiteralAction(this.getWorkbenchPart(), propertyObject, value);
            ((EditSimpleLiteralAction)action).run();
            ++valuesIndex;
        }
        int extraPropertyObjects = propertyObjects.size() - values.size();
        while (extraPropertyObjects > 0) {
            if (propertyObjects.size() == 1) {
                EditSimpleLiteralAction action = new EditSimpleLiteralAction(this.getWorkbenchPart(), (EObject)propertyObjects.get(0), null);
                action.run();
            } else if (propertyObjects.size() > 1) {
                int removeIndex = propertyObjects.size() - 1;
                EObject removeObject = (EObject)propertyObjects.get(removeIndex);
                RemovePropertiesAction action = new RemovePropertiesAction(this.getWorkbenchPart(), removeObject);
                action.run();
                wrapper.removePropertyObject(removeIndex);
            }
            --extraPropertyObjects;
        }
    }

    public void editSimpleLiteralValue(BasePropertyWrapper wrapper, EObject propertyObject, String newValue) {
        SCABaseAction action;
        if (propertyObject == null) {
            action = new DuplicatePropertiesAction(this.getWorkbenchPart(), (EObject)wrapper.getPropertyObjects().get(0));
            ((DuplicatePropertiesAction)action).run();
            propertyObject = ((DuplicatePropertiesAction)action).getNewProperty();
            wrapper.addPropertyObject(propertyObject);
        }
        action = new EditSimpleLiteralAction(this.getWorkbenchPart(), propertyObject, newValue);
        ((EditSimpleLiteralAction)action).run();
    }

    public void traverseAnyType(StringBuffer sb, AnyType anyType) {
        FeatureMap attributesMap = anyType.getAnyAttribute();
        FeatureMap mixedMap = anyType.getMixed();
        ResourceSet resourceSet = anyType.eResource().getResourceSet();
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
        String ns = extendedMetaData.getNamespace((EStructuralFeature)anyType.eContainmentFeature());
        String elementName = extendedMetaData.getName((EStructuralFeature)anyType.eContainmentFeature());
        if (mixedMap.size() == 0) {
            this.createStartElementTag(anyType, sb, ns, elementName, attributesMap, "/>");
        } else {
            this.createStartElementTag(anyType, sb, ns, elementName, attributesMap, ">");
            int i = 0;
            int size = mixedMap.size();
            while (i < size) {
                EStructuralFeature feature = mixedMap.getEStructuralFeature(i);
                if (FeatureMapUtil.isText((EStructuralFeature)feature)) {
                    sb.append(mixedMap.getValue(i));
                } else if (FeatureMapUtil.isComment((EStructuralFeature)feature)) {
                    sb.append(" <!--" + mixedMap.getValue(i) + "-->");
                } else if (FeatureMapUtil.isCDATA((EStructuralFeature)feature)) {
                    sb.append(" <![CDATA[" + mixedMap.getValue(i) + "]]>");
                } else if (feature instanceof EReference) {
                    this.traverseAnyType(sb, (AnyType)mixedMap.getValue(i));
                }
                ++i;
            }
            this.createEndElementTag(anyType, sb, ns, elementName);
        }
    }

    private void appendAttributes(StringBuffer sb, FeatureMap attributesMap) {
        int i = 0;
        int size = attributesMap.size();
        while (i < size) {
            EStructuralFeature feature = attributesMap.getEStructuralFeature(i);
            if (feature instanceof EAttribute) {
                String name = ((EAttribute)feature).getName();
                Object value = attributesMap.getValue(i);
                sb.append(" " + name + "=\"" + value + "\"");
            }
            ++i;
        }
    }

    private void createStartElementTag(Object input, StringBuffer sb, String namespace, String elementName, FeatureMap attributesMap, String endTag) {
        String prefix;
        sb.append("<");
        if (namespace != null && (prefix = this.getNamespacePrefix(this.getComposite(input), namespace)) != null && !prefix.equals("")) {
            sb.append(String.valueOf(prefix) + ":");
        }
        sb.append(elementName);
        this.appendAttributes(sb, attributesMap);
        sb.append(endTag);
    }

    private void createEndElementTag(Object input, StringBuffer sb, String namespace, String elementName) {
        String prefix;
        sb.append("</");
        if (namespace != null && (prefix = this.getNamespacePrefix(this.getComposite(input), namespace)) != null && !prefix.equals("")) {
            sb.append(String.valueOf(prefix) + ":");
        }
        sb.append(String.valueOf(elementName) + ">");
    }

    private Composite getComposite(Object child) {
        if (!(child instanceof EObject)) {
            return null;
        }
        if (child == null) {
            return null;
        }
        if (child instanceof Composite) {
            return (Composite)child;
        }
        if (child instanceof EObject) {
            return this.getComposite(((EObject)child).eContainer());
        }
        return null;
    }

    private String getNamespacePrefix(Composite composite, String namespace) {
        EcoreEMap xmlnsMap = this.getPrefixNamespaceMap(composite);
        if (xmlnsMap != null) {
            for (Object key : xmlnsMap.keySet()) {
                Object value = xmlnsMap.get(key);
                if (!value.equals(namespace)) continue;
                return (String)key;
            }
        }
        return null;
    }

    private EcoreEMap getPrefixNamespaceMap(Composite composite) {
        if (composite == null) {
            return null;
        }
        EObject parent = composite.eContainer();
        for (EStructuralFeature eStructFeature : parent.eClass().getEAllStructuralFeatures()) {
            if (!(eStructFeature instanceof EReference) || !((EReference)eStructFeature).getName().equals("xMLNSPrefixMap")) continue;
            EcoreEMap xmlnsMap = (EcoreEMap)parent.eGet(eStructFeature);
            return xmlnsMap;
        }
        return null;
    }

    public static boolean isComplex(BasicFeatureMap featureMap) {
        int index = 0;
        while (index < featureMap.size()) {
            EStructuralFeatureImpl.BasicFeatureMapEntry entry = (EStructuralFeatureImpl.BasicFeatureMapEntry)featureMap.get(index);
            EStructuralFeature feature = entry.getEStructuralFeature();
            String featureName = feature.getName();
            Object o = entry.getValue();
            if (o instanceof AnyType) {
                return true;
            }
            if (o instanceof String) {
                if (featureName.equals("cDATA")) {
                    return true;
                }
                if (featureName.equals("comment")) {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public class DuplicatePropertiesAction
    extends SCABaseAction {
        private EObject propertyObject;
        private EObject newPropertyObject;

        public DuplicatePropertiesAction(IWorkbenchPart part, EObject propertyObject) {
            super(part);
            this.propertyObject = propertyObject;
        }

        public void run() {
            CreateElementRequest request = new CreateElementRequest(this.propertyObject.eContainer(), null);
            request.setLabel(Messages.LiteralValueProcessor_25);
            DuplicatePropertiesCommand dupCommand = new DuplicatePropertiesCommand(request, this.propertyObject);
            try {
                dupCommand.execute(null, null);
                this.newPropertyObject = dupCommand.getNewProperty();
            }
            catch (Exception exception) {}
        }

        public EObject getNewProperty() {
            return this.newPropertyObject;
        }
    }

    public class DuplicatePropertiesCommand
    extends EditElementCommand {
        private CreateElementRequest request;
        private EObject originalProperty;
        private EObject newProperty;

        public DuplicatePropertiesCommand(CreateElementRequest request, EObject originalProperty) {
            super(request.getLabel(), null, (IEditCommandRequest)request);
            this.request = request;
            this.originalProperty = originalProperty;
        }

        public EObject getNewProperty() {
            return this.newProperty;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EObject parent = this.request.getContainer();
            if (parent instanceof Component) {
                PropertyValue propertyValue = SCAFactory.eINSTANCE.createPropertyValue();
                propertyValue.setName(this.getPropertyNameValue());
                propertyValue.setElement(this.getPropertyElementValue());
                propertyValue.setType(this.getPropertyTypeValue());
                propertyValue.setFile(this.getFile());
                propertyValue.setSource(this.getSource());
                if (this.isSetGetMany()) {
                    propertyValue.setMany(this.getManyValue());
                }
                ((Component)parent).getProperty().add((Object)propertyValue);
                this.newProperty = propertyValue;
            } else if (parent instanceof Composite) {
                Property property = SCAFactory.eINSTANCE.createProperty();
                property.setName(this.getPropertyNameValue());
                property.setName(this.getPropertyNameValue());
                property.setElement(this.getPropertyElementValue());
                property.setType(this.getPropertyTypeValue());
                if (this.isSetGetMany()) {
                    property.setMany(this.getManyValue());
                }
                if (this.isSetMustSupply()) {
                    property.setMustSupply(this.getMustSupplyValue());
                }
                ((Composite)parent).getProperty().add((Object)property);
                this.newProperty = property;
            }
            return CommandResult.newOKCommandResult();
        }

        private String getPropertyNameValue() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).getName();
            }
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).getName();
            }
            return null;
        }

        private QName getPropertyElementValue() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).getElement();
            }
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).getElement();
            }
            return null;
        }

        private QName getPropertyTypeValue() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).getType();
            }
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).getType();
            }
            return null;
        }

        private boolean isSetGetMany() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).isSetMany();
            }
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).isSetMany();
            }
            return false;
        }

        private boolean getManyValue() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).isMany();
            }
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).isMany();
            }
            return false;
        }

        private boolean isSetMustSupply() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).isSetMustSupply();
            }
            return false;
        }

        private boolean getMustSupplyValue() {
            if (this.originalProperty instanceof Property) {
                return ((Property)this.originalProperty).isMustSupply();
            }
            return false;
        }

        private String getFile() {
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).getFile();
            }
            return null;
        }

        private String getSource() {
            if (this.originalProperty instanceof PropertyValue) {
                return ((PropertyValue)this.originalProperty).getSource();
            }
            return null;
        }
    }

    private class EditAnyAttributeSimpleLiteralCommand
    extends EditElementCommand {
        private SetRequest request;

        public EditAnyAttributeSimpleLiteralCommand(SetRequest request) {
            super(request.getLabel(), null, (IEditCommandRequest)request);
            this.request = request;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EObject element = this.request.getElementToEdit();
            String newValue = (String)this.request.getValue();
            if (element instanceof PropertyValue) {
                PropertyValue pv = (PropertyValue)element;
                FeatureMap map = pv.getMixed();
                map.clear();
                if (newValue != null) {
                    FeatureMapUtil.addText((FeatureMap)map, (String)newValue);
                }
            } else if (element instanceof Property) {
                Property property = (Property)element;
                FeatureMap map = property.getMixed();
                map.clear();
                if (newValue != null) {
                    FeatureMapUtil.addText((FeatureMap)map, (String)newValue);
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }

    private class EditSimpleLiteralAction
    extends SCABaseAction {
        private EObject propertyObject;
        private String value;

        public EditSimpleLiteralAction(IWorkbenchPart part, EObject propertyObject, String value) {
            super(part);
            this.propertyObject = propertyObject;
            this.value = value;
        }

        public void run() {
            SetRequest setRequest = new SetRequest(this.propertyObject, (EStructuralFeature)this.getEAttribute(this.propertyObject, "anyAttribute"), (Object)this.value);
            setRequest.setLabel(Messages.LiteralValueProcessor_7);
            EditAnyAttributeSimpleLiteralCommand command = new EditAnyAttributeSimpleLiteralCommand(setRequest);
            try {
                command.execute(null, null);
            }
            catch (Exception exception) {}
        }
    }
}

