/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.ui.custom.util.ComponentWrapper;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;

public class DiagramOverlapMetadata {
    public static final String NORTH = "NORTH";
    public static final String NORTH_EAST = "NORTH_EAST";
    public static final String EAST = "EAST";
    public static final String SOUTH_EAST = "SOUTH_EAST";
    public static final String SOUTH = "SOUTH";
    public static final String SOUTH_WEST = "SOUTH_WEST";
    public static final String WEST = "WEST";
    public static final String NORTH_WEST = "NORTH_WEST";
    private ComponentWrapper object;
    private String overlapLocation;
    private int overlapWidth;
    private int overlapHeight;
    private Dimension figureSize;

    public void setComponentWrapperObject(ComponentWrapper object) {
        this.object = object;
    }

    public void setFigureSize(Dimension d) {
        this.figureSize = d;
    }

    public void setOverlapLoation(String overlapLocation) {
        this.overlapLocation = overlapLocation;
    }

    public String getOverlapLocation() {
        return this.overlapLocation;
    }

    public ComponentWrapper getComponentWrapperObject() {
        return this.object;
    }

    public void setOverlapWidth(int width) {
        this.overlapWidth = width;
    }

    public void setOverlapHeight(int height) {
        this.overlapHeight = height;
    }

    public int getOverlapWidth() {
        return this.overlapWidth;
    }

    public int getOverlapHeight() {
        return this.overlapHeight;
    }

    public Dimension getOverlapDimension() {
        return new Dimension(this.overlapWidth, this.overlapHeight);
    }

    public String getShiftDirection() {
        ArrayList<String> list = new ArrayList<String>(4);
        String shiftDirection = "";
        if (this.overlapWidth > this.figureSize.width / 2) {
            if (this.overlapHeight > this.figureSize.width / 2) {
                list.add(NORTH_EAST);
                list.add(NORTH_WEST);
                list.add(SOUTH_EAST);
                list.add(SOUTH_WEST);
                shiftDirection = this.overlapLocation.equals(NORTH_EAST) ? this.getNonDiagonalShiftDirection(SOUTH_WEST) : (this.overlapLocation.equals(NORTH_WEST) ? this.getNonDiagonalShiftDirection(SOUTH_EAST) : (this.overlapLocation.equals(SOUTH_EAST) ? this.getNonDiagonalShiftDirection(NORTH_WEST) : this.getNonDiagonalShiftDirection(NORTH_EAST)));
            } else if (this.overlapLocation.equals(NORTH_EAST) || this.overlapLocation.equals(NORTH_WEST)) {
                list.add(NORTH_EAST);
                list.add(NORTH_WEST);
                shiftDirection = this.getNonDiagonalShiftDirection(SOUTH);
            } else {
                list.add(SOUTH_EAST);
                list.add(SOUTH_WEST);
                shiftDirection = this.getNonDiagonalShiftDirection(NORTH);
            }
        } else if (this.overlapLocation.equals(NORTH_EAST) || this.overlapLocation.equals(SOUTH_EAST)) {
            if (this.overlapHeight > this.figureSize.height / 2) {
                list.add(NORTH_EAST);
                list.add(SOUTH_EAST);
                shiftDirection = this.getNonDiagonalShiftDirection(WEST);
            } else {
                list.add(NORTH_EAST);
                shiftDirection = this.getNonDiagonalShiftDirection(SOUTH_WEST);
            }
        } else if (this.overlapLocation.equals(NORTH_WEST) || this.overlapLocation.equals(SOUTH_WEST)) {
            if (this.overlapHeight > this.figureSize.height / 2) {
                list.add(NORTH_WEST);
                list.add(SOUTH_WEST);
                shiftDirection = this.getNonDiagonalShiftDirection(EAST);
            } else {
                list.add(NORTH_WEST);
                shiftDirection = this.getNonDiagonalShiftDirection(SOUTH_EAST);
            }
        }
        return shiftDirection;
    }

    private String getNonDiagonalShiftDirection(String shift) {
        if (shift.equals(NORTH_EAST)) {
            if (this.overlapHeight < this.overlapWidth) {
                return NORTH;
            }
            return EAST;
        }
        if (shift.equals(SOUTH_EAST)) {
            if (this.overlapHeight < this.overlapWidth) {
                return SOUTH;
            }
            return EAST;
        }
        if (shift.equals(SOUTH_WEST)) {
            if (this.overlapHeight < this.overlapWidth) {
                return SOUTH;
            }
            return WEST;
        }
        if (shift.equals(NORTH_WEST)) {
            if (this.overlapHeight < this.overlapWidth) {
                return NORTH;
            }
            return WEST;
        }
        return shift;
    }
}

