/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.providers;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetJavaInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetWSDLInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCABaseAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCACreateComponentAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCACreateComponentReferenceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCACreateComponentServiceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCACreateCompositeReferenceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCACreateCompositeServiceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAReferencePromotionAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCARefreshComponentAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCARegenComponentImplAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAServicePromotionAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.IBindingUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.SCABindingUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.IImplementationUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.SCAImplementationUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialogFactory;
import com.ibm.ccl.sca.ui.contributions.UIContributionRegistry;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SCAContextMenuProvider
extends DiagramContextMenuProvider {
    private IWorkbenchPart part;
    private EditPartViewer viewer;
    private UIContributionRegistry uiContributionRegistry;

    public SCAContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
        super(part, viewer);
        this.part = part;
        this.viewer = viewer;
        this.uiContributionRegistry = SCAToolsUIPlugin.getUIContributionRegistry();
    }

    public void buildContextMenu(IMenuManager menu) {
        EditPart ep;
        List editParts = this.viewer.getSelectedEditParts();
        RootEditPart rootPart = this.viewer.getRootEditPart();
        EditPart rootEditPart = rootPart.getContents();
        if (editParts.size() == 0) {
            EObject composite;
            Object model = rootEditPart.getModel();
            if (model instanceof View && (composite = ((View)model).getElement()) instanceof Composite) {
                menu.add((IAction)new SCACreateComponentAction(this.part, composite));
                menu.add((IAction)new SCACreateCompositeServiceAction(this.part, composite));
                menu.add((IAction)new SCACreateCompositeReferenceAction(this.part, composite));
            }
        } else if (editParts.size() > 0 && (ep = (EditPart)editParts.get(0)).getModel() instanceof View) {
            EObject element = ((View)ep.getModel()).getElement();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (element instanceof Component) {
                Component component = (Component)element;
                menu.add((IAction)new SCACreateComponentServiceAction(this.part, (EObject)component));
                menu.add((IAction)new SCACreateComponentReferenceAction(this.part, (EObject)component));
                SCAImplementationUIExtensibilityElementFactoryRegistry registry = ScaDiagramEditorPlugin.getInstance().getSCAImplementationUIExtensibilityElementProviderRegistry();
                MenuManager setImplementationSubMenu = new MenuManager(Messages.SCAContextMenuProvider_0);
                for (IImplementationUIProvider provider : registry.getExtensibilityElementUIProviders()) {
                    Action action = provider.getAddAndSetImplementationAction((Component)element);
                    if (action == null) continue;
                    setImplementationSubMenu.add((IAction)action);
                }
                menu.add((IContributionItem)setImplementationSubMenu);
                IEditorPart editorPart = (IEditorPart)this.part;
                IFile compositeFile = this.getCompositeFile();
                if (compositeFile != null && !editorPart.isDirty() && component.getImplementation() != null) {
                    SCARefreshComponentAction refreshComponentAction = new SCARefreshComponentAction(this.part, compositeFile, component.getName());
                    menu.add((IAction)refreshComponentAction);
                }
                if (compositeFile != null) {
                    EList services = component.getService();
                    ComponentService componentService = null;
                    String serviceName = null;
                    if (services.size() == 1) {
                        componentService = (ComponentService)services.get(0);
                        serviceName = componentService.getName();
                    }
                    if (!editorPart.isDirty() && (services.size() == 0 || componentService != null && componentService.getInterface() != null)) {
                        menu.add((IAction)new SCARegenComponentImplAction(this.part, compositeFile, component.getName(), serviceName));
                    }
                }
            } else if (element instanceof Service || element instanceof Reference || element instanceof ComponentService || element instanceof ComponentReference) {
                ISelectionDialogFactory wsdlDialogFactory;
                MenuManager setInterfaceSubMenu = new MenuManager(Messages.SCAContextMenuProvider_3);
                HashMap<String, IFile> dataMap = new HashMap<String, IFile>();
                dataMap.put("CURRENT_RESOURCE", ScaUtil.getIFile());
                SCAAddAndSetJavaInterfaceAction action = new SCAAddAndSetJavaInterfaceAction(this.part, Messages.SCAContextMenuProvider_4, element);
                ImageDescriptor desc = ImageDescriptor.createFromImage((Image)ScaDiagramEditorPlugin.getInstance().getImage("icons/java_interface_obj.gif"));
                action.setImageDescriptor(desc);
                ISelectionDialogFactory javaDialogFactory = this.uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.java");
                if (javaDialogFactory != null) {
                    ISelectionDialog dialog = javaDialogFactory.createSelectionDialog(shell, dataMap);
                    action.setDialog(dialog);
                    setInterfaceSubMenu.add((IAction)action);
                }
                if ((wsdlDialogFactory = this.uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.wsdl")) != null) {
                    SCAAddAndSetWSDLInterfaceAction action2 = new SCAAddAndSetWSDLInterfaceAction(this.part, Messages.SCAContextMenuProvider_5, element);
                    ImageDescriptor desc2 = ImageDescriptor.createFromImage((Image)ScaDiagramEditorPlugin.getInstance().getImage("icons/wsdl_interface_obj.gif"));
                    action2.setImageDescriptor(desc2);
                    ISelectionDialog dialog2 = wsdlDialogFactory.createSelectionDialog(shell, dataMap);
                    action2.setDialog(dialog2);
                    setInterfaceSubMenu.add((IAction)action2);
                }
                menu.add((IContributionItem)setInterfaceSubMenu);
                MenuManager addBindingSubMenu = new MenuManager(Messages.SCAContextMenuProvider_6);
                SCABindingUIExtensibilityElementFactoryRegistry registry = ScaDiagramEditorPlugin.getInstance().getSCABindingUIExtensibilityElementProviderRegistry();
                List<IBindingUIProvider> providers = registry.getExtensibilityElementUIProviders();
                List bindings = ScaUtil.getBindings(element);
                List filteredProviders = ScaUtil.getFilteredBindingProviders(providers, bindings);
                Iterator<IBindingUIProvider> providersIT = providers.iterator();
                ArrayList<SCABaseAction> disabledActions = new ArrayList<SCABaseAction>();
                while (providersIT.hasNext()) {
                    IBindingUIProvider extProvider = providersIT.next();
                    SCABaseAction addBindingAction = extProvider.getBindingAction(this.part, element);
                    if (addBindingAction == null) continue;
                    if (!filteredProviders.contains(extProvider)) {
                        addBindingAction.setEnablementState(false);
                        disabledActions.add(addBindingAction);
                        continue;
                    }
                    addBindingSubMenu.add((IAction)addBindingAction);
                }
                Iterator disabledIT = disabledActions.iterator();
                while (disabledIT.hasNext()) {
                    addBindingSubMenu.add((IAction)disabledIT.next());
                }
                menu.add((IContributionItem)addBindingSubMenu);
                if (element instanceof ComponentService) {
                    menu.add((IAction)new SCAServicePromotionAction(this.part, Messages.SCAContextMenuProvider_7, null, (ComponentService)element));
                    IFile compositeFile = this.getCompositeFile();
                    if (compositeFile != null) {
                        ComponentService componentService = (ComponentService)element;
                        Component component = (Component)componentService.eContainer();
                        if (!((IEditorPart)this.part).isDirty() && componentService.getInterface() != null) {
                            menu.add((IAction)new SCARegenComponentImplAction(this.part, compositeFile, component.getName(), componentService.getName()));
                        }
                    }
                } else if (element instanceof ComponentReference) {
                    menu.add((IAction)new SCAReferencePromotionAction(this.part, Messages.SCAContextMenuProvider_8, null, (ComponentReference)element));
                }
            }
        }
        super.buildContextMenu(menu);
    }

    private IFile getCompositeFile() {
        if (this.part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)this.part).getEditorInput();
            IFile diagramFile = (IFile)input.getAdapter(IFile.class);
            String filename = diagramFile.getName();
            filename = filename.substring(0, filename.length() - 8);
            return diagramFile.getParent().getFile((IPath)new Path(filename));
        }
        return null;
    }
}

