/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.promote;

import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.AddRemoveTableAction;
import com.ibm.ccl.sca.composite.ui.custom.mixed.HasChildrenFilter;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComponent;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComposite;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedItem;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedUtils;
import com.ibm.ccl.sca.composite.ui.custom.promote.DialogPromoteContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.promote.DialogPromoteLabelProvider;
import com.ibm.ccl.sca.composite.ui.custom.promote.EditPromoteCommand;
import com.ibm.ccl.sca.composite.ui.custom.promote.HasSamePromoteFilter;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.SelectionDialog;
import com.ibm.ccl.sca.internal.ui.common.controls.ValidateSelectedContentProvider;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.ui.IWorkbenchPart;

public class AddPromoteAction
extends AddRemoveTableAction {
    private boolean isService;

    public AddPromoteAction(IWorkbenchPart part, EObject element, boolean isService) {
        super(part, element);
        this.setText(Messages.AddRemoveTableAction_0);
        this.isService = isService;
    }

    public void run() {
        String title = this.isService ? Messages.AddServiceAction_0 : Messages.AddPromoteAction_0;
        SelectionDialog diag = new SelectionDialog(ScaUtil.getShell(), title, true);
        HasChildrenFilter<MixedComposite> compositeFilter = new HasChildrenFilter<MixedComposite>(this.isService);
        HasChildrenFilter<MixedComponent> componentFilter = new HasChildrenFilter<MixedComponent>(this.isService);
        HasSamePromoteFilter itemFilter = new HasSamePromoteFilter(this.parent);
        diag.setLabelProvider((IBaseLabelProvider)new DialogPromoteLabelProvider(this.isService));
        diag.setContentProvider((ValidateSelectedContentProvider)new DialogPromoteContentProvider(this.isService));
        diag.setRoot(MixedUtils.getRootComposites(this.parent, compositeFilter, componentFilter, itemFilter));
        int code = diag.open();
        Object selection = diag.getSelection();
        if (code == 0 && selection != null && (selection instanceof MixedItem || selection instanceof String)) {
            SetRequest request = new SetRequest(this.parent, null, this.getPromoteList(selection));
            EditPromoteCommand command = new EditPromoteCommand(request, this.isService);
            CompositeCommand topCompositeCommand = new CompositeCommand("");
            topCompositeCommand.add((IUndoableOperation)command);
            try {
                List<String> addEdges = ScaUtil.edgesToAdd((List)request.getValue(), this.isService);
                ScaUtil.addUpdateWiresCommand(addEdges, topCompositeCommand, this.isService);
                topCompositeCommand.execute(null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<String> getPromoteList(Object selection) {
        Reference reference = (Reference)this.parent;
        String newReference = null;
        if (selection instanceof String) {
            newReference = (String)selection;
        } else if (selection instanceof MixedItem) {
            newReference = ((MixedItem)selection).getRelativePath();
        }
        return MixedUtils.addStrings(newReference, reference.getPromote());
    }
}

