/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.part;

import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaVisualIDRegistry;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;

public class ScaInitDiagramFileCommand {
    private IFile diagramFile;
    private TransactionalEditingDomain editingDomain;
    private EObject rootModelElement;

    public ScaInitDiagramFileCommand(IFile diagramFile, TransactionalEditingDomain editingDomain, EObject rootModelElement) {
        this.diagramFile = diagramFile;
        this.editingDomain = editingDomain;
        this.rootModelElement = rootModelElement;
    }

    public void run() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        affectedFiles.add(this.diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)this.diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.editingDomain, Messages.ScaNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = ScaVisualIDRegistry.getDiagramVisualID(ScaInitDiagramFileCommand.this.rootModelElement);
                if (diagramVID != 79) {
                    return CommandResult.newErrorCommandResult((String)Messages.ScaNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = ViewService.createDiagram((EObject)ScaInitDiagramFileCommand.this.rootModelElement, (String)"Sca", (PreferencesHint)ScaDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(ScaDiagramEditorUtil.getSaveOptions());
            ScaDiagramEditorUtil.setCharset(this.diagramFile);
        }
        catch (ExecutionException e) {
            ScaDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            ScaDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
    }
}

